/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.ds.GroupDataSource;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.enums.ParamEnum;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbTableDataForm;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.database.model.JdbcPageMod;
import com.bringspring.common.database.model.dto.DbConnDTO;
import com.bringspring.common.database.model.dto.JdbcDTO;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.sql.impl.SqlKingbase;
import com.bringspring.common.database.util.CommonUtil;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ParameterUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.model.dbtable.DbTableCreate;
import com.bringspring.system.base.model.dbtable.DbTableUpdate;
import com.bringspring.system.base.service.DbTableService;
import com.bringspring.system.base.service.DblinkService;
import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DbTableServiceImpl
implements DbTableService {
    private static final Logger log = LoggerFactory.getLogger(DbTableServiceImpl.class);
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private DataSourceModel dataSourceUtils;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    DbTableService dbTableService;
    @Autowired
    private DataSource dataSource;

    @Override
    public List<DbTableModel> getList(String dbId) throws DataException {
        DbConnDTO connDTO = this.setResource(dbId);
        List<DbTableModel> tableModelList = this.getListCommon(null, DbTableModel.class, connDTO);
        return tableModelList;
    }

    @Override
    public List<DbTableFieldModel> getFieldList(String dbId, String table) throws DataException {
        DbConnDTO connDTO = this.setResource(dbId);
        List<DbTableFieldModel> listCommon = this.getListCommon(table, DbTableFieldModel.class, connDTO);
        return listCommon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JdbcGetMod> List<T> getListCommon(String table, Class<T> modType, DbConnDTO connDTO) throws DataException {
        List list;
        block6: {
            Connection conn = connDTO.getConn();
            try {
                SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
                PreparedStatementDTO preparedStatementDTO = null;
                preparedStatementDTO = modType == DbTableModel.class ? sqlBase.getTableListPSD(conn, (DataSourceMod)connDTO.getDbSource()) : sqlBase.getFieldListPSD(conn, table, (DataSourceMod)connDTO.getDbSource());
                list = JdbcUtil.queryCustomMods((PreparedStatementDTO)preparedStatementDTO, modType);
                if (Collections.singletonList(conn).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(conn).get(0) != null) {
                        conn.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new DataException(e.getMessage());
                }
            }
            conn.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExistByTableName(String dbId, String table) throws DataException {
        boolean bl;
        block6: {
            DbConnDTO connDTO = this.setResource(dbId);
            Connection conn = connDTO.getConn();
            try {
                SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
                PreparedStatementDTO preparedStatementDTO = sqlBase.getExistsTablePSD(conn, table, (DataSourceMod)connDTO.getDbSource());
                List list = JdbcUtil.queryList((PreparedStatementDTO)preparedStatementDTO);
                boolean bl2 = bl = list != null && !list.isEmpty();
                if (Collections.singletonList(conn).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(conn).get(0) != null) {
                        conn.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DataException(e.getMessage());
                }
            }
            conn.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getData(DbTableDataForm dbTableDataForm, String dbId, String table) throws Exception {
        Object list = null;
        JdbcPageMod result = new JdbcPageMod();
        DbConnDTO connDTO = this.setResource(dbId);
        Connection conn = connDTO.getConn();
        try {
            if (conn != null) {
                LinkedList<String> dataList = new LinkedList<String>();
                StringBuilder sql = new StringBuilder(connDTO.getDbBase().getSqlBase().getDataSql(table));
                if (!StringUtils.isEmpty((String)dbTableDataForm.getKeyword()) && !StringUtils.isEmpty((String)dbTableDataForm.getField())) {
                    sql.append(" where " + dbTableDataForm.getField() + " like ?");
                    dataList.add("%" + dbTableDataForm.getKeyword() + "%");
                }
                JdbcDTO jdbcDTO = new JdbcDTO();
                jdbcDTO.setReturnType("mapMods");
                jdbcDTO.setAliasFlag(Boolean.valueOf(true));
                jdbcDTO.setLowercaseFlag(Boolean.valueOf(true));
                result = JdbcUtil.queryPage((PreparedStatementDTO)new PreparedStatementDTO(conn, sql.toString(), dataList), null, (Integer)((int)dbTableDataForm.getCurrentPage()), (Integer)((int)dbTableDataForm.getPageSize()), (JdbcDTO)jdbcDTO);
            }
            dbTableDataForm.setCurrentPage((long)result.getCurrentPage().intValue());
            dbTableDataForm.setPageSize((long)result.getPageSize().intValue());
            dbTableDataForm.setData(result.getDataList(), (long)result.getTotalRecord().intValue());
            List list2 = result.getDataList();
            return list2;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSum(String dbId, String table) throws DataException {
        int sum = 0;
        try {
            DbConnDTO connDTO = this.setResource(dbId);
            Connection conn = connDTO.getConn();
            try {
                if (conn != null) {
                    String sql = SqlKingbase.DATA_SUM_SQL.replace(ParamEnum.TABLE.getTarget(), table);
                    PreparedStatementDTO dto = new PreparedStatementDTO(conn, sql);
                    sum = JdbcUtil.queryOneInt((PreparedStatementDTO)dto, (String)"COUNT_SUM");
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String dbId, String table) throws DataException {
        if (!this.sumExistFlag(dbId, table).booleanValue()) {
            if (this.checkRepetition(table).booleanValue()) {
                throw new DataException("\u7cfb\u7edf\u81ea\u5e26\u8868,\u4e0d\u5141\u8bb8\u88ab\u4fee\u6539");
            }
        } else {
            throw new DataException("\u8868\u5df2\u7ecf\u88ab\u4f7f\u7528,\u4e0d\u5141\u8bb8\u88ab\u7f16\u8f91");
        }
        try {
            DbConnDTO connDTO = this.setResource(dbId);
            Connection conn = connDTO.getConn();
            try {
                JdbcUtil.creUpDe((PreparedStatementDTO)connDTO.getDbBase().getSqlBase().getDeleteSqlPSD(conn, table));
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int createTable(DbTableCreate dbTableCreate) throws DataException {
        String dbLink = dbTableCreate.getDbLinkId();
        DbConnDTO connDTO = this.setResource(dbLink);
        SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
        try {
            Connection conn = connDTO.getConn();
            try {
                if (this.dbTableService.isExistByTableName(dbLink, dbTableCreate.getNewTable())) {
                    int n2 = 0;
                    return n2;
                }
                this.checkPrimary(dbTableCreate.getDbTableFieldModelList());
                DbBase dbBase = DbTypeUtil.getDb((Connection)conn);
                JdbcUtil.creUpDeBatch((Connection)conn, (List)sqlBase.getCreateTablePSD(dbTableCreate.getNewTable(), dbTableCreate.getTableComment(), dbTableCreate.getDbTableFieldModelList(), dbBase));
                return 1;
            }
            catch (Exception e) {
                JdbcUtil.creUpDe((PreparedStatementDTO)sqlBase.getDeleteSqlPSD(conn, dbTableCreate.getNewTable()));
                throw new DataException(e.getMessage());
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(DbTableUpdate dbTableUpdate) throws DataException {
        if (!this.sumExistFlag(dbTableUpdate.getDbLinkId(), dbTableUpdate.getOldTable()).booleanValue()) {
            if (this.checkRepetition(dbTableUpdate.getNewTable()).booleanValue()) {
                throw new DataException("\u7cfb\u7edf\u81ea\u5e26\u8868,\u4e0d\u5141\u8bb8\u88ab\u4fee\u6539");
            }
        } else {
            throw new DataException("\u8868\u5df2\u7ecf\u88ab\u4f7f\u7528,\u4e0d\u5141\u8bb8\u88ab\u7f16\u8f91");
        }
        try {
            DbConnDTO connDTO = this.setResource(dbTableUpdate.getDbLinkId());
            String oldTable = dbTableUpdate.getOldTable();
            String signTableName = oldTable + "_" + CommonUtil.getStringRandom((int)5);
            SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
            Connection conn = connDTO.getConn();
            try {
                try {
                    String sql = sqlBase.getRenameSql(oldTable, signTableName);
                    JdbcUtil.creUpDe((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
                    DbBase dbBase = DbTypeUtil.getDb((Connection)conn);
                    JdbcUtil.creUpDeBatch((Connection)conn, (List)sqlBase.getCreateTablePSD(dbTableUpdate.getNewTable(), dbTableUpdate.getTableComment(), dbTableUpdate.getDbTableFieldModelList(), dbBase));
                }
                catch (Exception e) {
                    JdbcUtil.creUpDe((PreparedStatementDTO)new PreparedStatementDTO(conn, sqlBase.getRenameSql(signTableName, oldTable)));
                    throw e;
                }
                conn.commit();
                JdbcUtil.creUpDe((PreparedStatementDTO)sqlBase.getDeleteSqlPSD(conn, signTableName));
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    @Override
    public void getSyncTable(String lindId) {
        try {
            Connection conn = ConnUtil.ConnCommon.getConnRemarks((DataSourceModel)this.dblinkService.getInfo(lindId));
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void checkPrimary(List<DbTableFieldModel> tableFieldList) throws DataException {
        for (DbTableFieldModel field : tableFieldList) {
            if (field.getPrimaryKey() != 1 || field.getDataType().equals("varchar")) continue;
            throw new DataException("\u8bf7\u4fee\u6539\u4e3b\u952e\u4e3a\u9ed8\u8ba4\"\u5b57\u7b26\u4e32\"\u7c7b\u578b\u3002");
        }
    }

    private DbConnDTO setResource(String linkId) throws DataException {
        try {
            DbLinkEntity dbSourceOrDbLink;
            if ("0".equals(linkId)) {
                String tenSource = Boolean.parseBoolean(this.configValueUtil.getMultiTenancy()) ? this.userProvider.get().getTenantDbConnectionString() : null;
                dbSourceOrDbLink = this.dataSourceUtils;
                if (!"true".equals(tenSource)) {
                    if (tenSource != null) {
                        dbSourceOrDbLink.setDbName(tenSource);
                    }
                } else {
                    GroupDataSource groupDataSource;
                    DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)this.dataSource;
                    if (dynamicRoutingDataSource.getGroupDataSources().containsKey(DataSourceContextHolder.getDatasourceId() + "-master") && (groupDataSource = (GroupDataSource)dynamicRoutingDataSource.getGroupDataSources().get(DataSourceContextHolder.getDatasourceId() + "-master")).getDataSourceMap().size() > 0) {
                        String key = "";
                        Iterator iterator = groupDataSource.getDataSourceMap().keySet().iterator();
                        if (iterator.hasNext()) {
                            String string;
                            key = string = (String)iterator.next();
                        }
                        DruidDataSource dataSource = (DruidDataSource)groupDataSource.getDataSourceMap().get(key);
                        String url = dataSource.getUrl();
                        String username = dataSource.getUsername();
                        String password = dataSource.getPassword();
                        String driverClassName = dataSource.getDriverClassName();
                        dbSourceOrDbLink.setUserName(username);
                        dbSourceOrDbLink.setPassword(password);
                        dbSourceOrDbLink.setPrepareUrl(url);
                        dbSourceOrDbLink.setDbType(ParameterUtil.getDbType((String)driverClassName));
                    }
                }
            } else {
                dbSourceOrDbLink = this.dblinkService.getInfo(linkId);
            }
            return new DbConnDTO(DbTypeUtil.getDb((DataSourceMod)dbSourceOrDbLink), (DataSourceModel)dbSourceOrDbLink, ConnUtil.getConn((DataSourceMod)dbSourceOrDbLink));
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    private Boolean sumExistFlag(String linkId, String oldTable) throws DataException {
        return this.checkCommon(linkId, oldTable);
    }

    private Boolean checkCommon(String linkId, String tableName) throws DataException {
        List<DbTableModel> tableList = this.dbTableService.getList(linkId);
        Optional<DbTableModel> table = tableList.stream().filter(m -> m.getTable().equals(tableName)).findFirst();
        if (table.isPresent()) {
            Integer sum = table.get().getSum();
            if (sum != null) {
                log.debug("\u8868\u7684\u6570\u636e\u603b\u6570sum\u662f\uff1a" + sum.toString());
            } else {
                sum = this.dbTableService.getSum(linkId, tableName);
            }
            if (sum != 0 && sum > 0) {
                return true;
            }
            log.debug("\u8868\u7684\u6570\u636e\u8868\u4fe1\u606f\uff1a" + table.get().toString());
            return false;
        }
        throw new DataException("\u8be5\u8868\u5df2\u88ab\u5220\u9664\uff0c\u6216\u8005\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u518d\u5c1d\u8bd5\u3002");
    }

    private Boolean checkRepetition(String tableName) {
        String[] tables;
        for (String table : tables = "base_authorize,base_comfields,base_billrule,base_dbbackup,base_dblink,base_dictionarydata,base_dictionarytype,base_im_content,base_languagemap,base_languagetype,base_menu,base_message,base_message_receive,base_module,base_modulebutton,base_modulecolumn,base_moduledataauthorize,base_moduledataauthorizescheme,base_organize,base_position,base_province,base_role,base_system_config,base_syslog,base_timetask,base_timetasklog,base_user,base_user_relation,crm_busines,crm_businesproduct,crm_clue,crm_contract,crm_contractinvoice,crm_contractmoney,crm_contractproduct,,crm_customercontacts,crm_followlog,crm_invoice,crm_product,crm_receivable,ext_bigdata,ext_document,ext_documentshare,ext_email_config,ext_email_receive,ext_email_send,ext_employee,ext_order,ext_orderentry,ext_orderreceivable,ext_projectgantt,ext_schedule,ext_tableexample,ext_worklog,ext_worklogshare,flow_delegate,flow_engine,flow_engineform,flow_enginevisible,flow_task,flow_taskcirculate,flow_tasknode,flow_taskoperator,flow_taskoperatorrecord,wechat_mpeventcontent,wechat_mpmaterial,wechat_mpmessage,wechat_qydepartment,wechat_qymessage,wechat_qyuser,wform_applybanquet,wform_applydelivergoods,wform_applydelivergoodsentry,wform_applymeeting,wform_archivalborrow,wform_articleswarehous,wform_batchpack,wform_batchtable,wform_conbilling,wform_contractapproval,wform_contractapprovalsheet,wform_debitbill,wform_documentapproval,wform_documentsigning,wform_expenseexpenditure,wform_finishedproduct,wform_finishedproductentry,wform_incomerecognition,wform_leaveapply,wform_letterservice,wform_materialrequisition,wform_materialrequisitionentry,wform_monthlyreport,wform_officesupplies,wform_outboundorder,wform_outboundorderentry,wform_outgoingapply,wform_paydistribution,wform_paymentapply,wform_postbatchtab,wform_procurementmaterial,wform_procurementmaterialentry,wform_purchaselist,wform_purchaselistentry,wform_quotationapproval,wform_receiptprocessing,wform_receiptsign,wform_rewardpunishment,wform_salesorder,wform_salesorderentry,wform_salessupport,wform_staffovertime,wform_supplementcard,wform_travelapply,wform_travelreimbursement,wform_vehicleapply,wform_violationhandling,wform_warehousereceipt,wform_warehousereceiptentry,wform_workcontactsheet".split(",")) {
            boolean exists = tableName.toLowerCase().equals(table);
            if (!exists) continue;
            return true;
        }
        return false;
    }
}

