/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.mapper.DbLinkMapper;
import com.bringspring.system.base.model.dblink.PaginationDbLink;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DblinkServiceImpl
extends ServiceImpl<DbLinkMapper, DbLinkEntity>
implements DblinkService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<DbLinkEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DbLinkEntity::getSortCode)).orderByDesc(DbLinkEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DbLinkEntity> getList(PaginationDbLink pagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)t.like(DbLinkEntity::getFullName, (Object)pagination.getKeyword());
            });
        }
        if (StringUtils.isNotEmpty((String)pagination.getDbType())) {
            flag = true;
            queryWrapper.lambda().eq(DataSourceModel::getDbType, (Object)pagination.getDbType());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DbLinkEntity::getSortCode)).orderByDesc(DbLinkEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(DbLinkEntity::getLastModifyTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public DbLinkEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DbLinkEntity::getId, (Object)id);
        return (DbLinkEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DbLinkEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(DbLinkEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void create(DbLinkEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setEnabledMark(Integer.valueOf(1));
        this.save(entity);
    }

    @Override
    public boolean update(String id, DbLinkEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(DbLinkEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        DbLinkEntity upEntity = (DbLinkEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().lt(DbLinkEntity::getSortCode, (Object)upSortCode)).orderByDesc(DbLinkEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((DbLinkEntity)downEntity.get(0)).getSortCode());
            ((DbLinkEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById(downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        DbLinkEntity downEntity = (DbLinkEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().gt(DbLinkEntity::getSortCode, (Object)upSortCode)).orderByAsc(DbLinkEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((DbLinkEntity)upEntity.get(0)).getSortCode());
            downEntity.setLastModifyTime(new Date());
            ((DbLinkEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById(upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public boolean testDbConnection(DbLinkEntity entity) throws DataException {
        DbBase db = DbTypeUtil.getDb((DataSourceMod)entity);
        if (db == null) {
            throw new DataException(MsgCode.DB001.get());
        }
        Connection conn = ConnUtil.getConn((DataSourceMod)entity);
        return conn != null;
    }

    @Override
    public List<DbLinkEntity> getListByPermission(PaginationDbLink page) {
        Object rkMarketLogObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, "c50f18d0568244a5b85878050bbc5a40", "base_db_link"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<DbLinkEntity>();
            }
            queryWrapper = (QueryWrapper)rkMarketLogObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, "c50f18d0568244a5b85878050bbc5a40", "base_db_link"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<DbLinkEntity>();
            }
            queryWrapper = (QueryWrapper)rkMarketLogObj;
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DbLinkEntity::getSortCode)).orderByDesc(DbLinkEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }
}

