/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.ModuleButtonEntity;
import com.bringspring.system.base.mapper.ModuleButtonMapper;
import com.bringspring.system.base.service.ModuleButtonService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleButtonServiceImpl
extends ServiceImpl<ModuleButtonMapper, ModuleButtonEntity>
implements ModuleButtonService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ModuleButtonEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleButtonEntity::getSortCode)).orderByDesc(ModuleButtonEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleButtonEntity> getEnabledMarkList(String enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleButtonEntity::getEnabledMark, (Object)enabledMark);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleButtonEntity::getSortCode)).orderByDesc(ModuleButtonEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleButtonEntity> getList(String moduleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleButtonEntity::getModuleId, (Object)moduleId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleButtonEntity::getSortCode)).orderByDesc(ModuleButtonEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleButtonEntity> getList(String moduleId, Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleButtonEntity::getModuleId, (Object)moduleId)).orderByAsc(ModuleButtonEntity::getSortCode)).orderByDesc(ModuleButtonEntity::getCreatorTime);
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(ModuleButtonEntity::getFullName, (Object)pagination.getKeyword())).or()).like(ModuleButtonEntity::getEnCode, (Object)pagination.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleButtonEntity::getSortCode)).orderByDesc(ModuleButtonEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ModuleButtonEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleButtonEntity::getId, (Object)id);
        return (ModuleButtonEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByFullName(String moduleId, String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleButtonEntity::getFullName, (Object)fullName)).eq(ModuleButtonEntity::getModuleId, (Object)moduleId);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(ModuleButtonEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String moduleId, String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleButtonEntity::getEnCode, (Object)enCode);
        if (moduleId != null) {
            queryWrapper.lambda().eq(ModuleButtonEntity::getModuleId, (Object)moduleId);
        }
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(ModuleButtonEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void create(ModuleButtonEntity entity) {
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
        }
        this.save(entity);
    }

    @Override
    public boolean update(String id, ModuleButtonEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(ModuleButtonEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }
}

