/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.bringspring.common.base.Page;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.service.UserOnlineService;
import com.bringspring.system.base.util.RemoveUtil;
import com.bringspring.system.message.model.UserOnlineModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserOnlineServiceImpl
implements UserOnlineService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private CacheUtil cacheUtil;

    @Override
    public List<UserOnlineModel> getList(Page page) {
        List<Object> userOnlineList = new ArrayList();
        String onlineUserKey = this.cacheKeyUtil.getLoginOnline();
        Set cacheKeys = this.cacheUtil.getAllKeys("loginCacheSpace");
        for (String cacheKey : cacheKeys) {
            if (cacheKey.length() <= onlineUserKey.length() || !cacheKey.substring(0, onlineUserKey.length()).equals(onlineUserKey) || !cacheKey.contains(onlineUserKey)) continue;
            String onlineToken = String.valueOf(this.cacheUtil.query("loginCacheSpace", cacheKey));
            Object onlineVal = this.cacheUtil.query("loginCacheSpace", onlineToken);
            UserInfo userInfo = null;
            userInfo = onlineVal instanceof String ? (UserInfo)JsonUtil.getJsonToBean((String)String.valueOf(onlineVal), UserInfo.class) : (UserInfo)onlineVal;
            if (userInfo == null) continue;
            UserOnlineModel userOnlineModel = new UserOnlineModel();
            userOnlineModel.setUserId(userInfo.getUserId());
            userOnlineModel.setUserAccount(userInfo.getUserAccount());
            userOnlineModel.setUserName(userInfo.getRealName() + "/" + userInfo.getUserAccount());
            userOnlineModel.setLoginIPAddress(userInfo.getLoginIpAddress());
            userOnlineModel.setLoginTime(userInfo.getLoginTime());
            userOnlineModel.setLoginPlatForm(userInfo.getLoginPlatForm());
            userOnlineModel.setTenantId(userInfo.getTenantId());
            userOnlineModel.setToken(onlineToken);
            userOnlineList.add(userOnlineModel);
        }
        String tenantId = this.userProvider.get().getTenantId();
        userOnlineList = userOnlineList.stream().filter(t -> String.valueOf(t.getTenantId()).equals(String.valueOf(tenantId))).collect(Collectors.toList());
        if (!StringUtils.isEmpty((String)page.getKeyword())) {
            userOnlineList = userOnlineList.stream().filter(t -> t.getUserName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        userOnlineList.sort(Comparator.comparing(UserOnlineModel::getLoginTime).reversed());
        return userOnlineList;
    }

    @Override
    public void delete(String id) {
        this.userProvider.removeOnLine(id);
        RemoveUtil.removeOnline(id);
    }
}

