/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util;

import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.DateUtil;
import com.bringspring.system.base.model.monitor.CpuModel;
import com.bringspring.system.base.model.monitor.DiskModel;
import com.bringspring.system.base.model.monitor.MemoryModel;
import com.bringspring.system.base.model.monitor.SwapModel;
import com.bringspring.system.base.model.monitor.SystemModel;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;

public class MonitorUtil {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private CpuModel cpu = null;
    private DiskModel disk = null;
    private MemoryModel memory = null;
    private SwapModel swap = null;
    private SystemModel system = null;

    public MonitorUtil() {
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        HardwareAbstractionLayer hal = si.getHardware();
        this.cpu = this.getCpuInfo(hal.getProcessor());
        this.memory = this.getMemoryInfo(hal.getMemory());
        this.disk = this.getDiskInfo(os);
        this.system = this.getSystemInfo(os);
        this.swap = this.getSwapInfo(hal.getMemory());
    }

    private DiskModel getDiskInfo(OperatingSystem os) {
        DiskModel diskInfo = new DiskModel();
        FileSystem fileSystem = os.getFileSystem();
        List fsArray = fileSystem.getFileStores();
        long total = 0L;
        long available = 0L;
        long used = 0L;
        for (OSFileStore fs : fsArray) {
            total += fs.getTotalSpace();
            available += fs.getUsableSpace();
        }
        used = total - available;
        diskInfo.setTotal(FormatUtil.formatBytes((long)total));
        diskInfo.setAvailable(FormatUtil.formatBytes((long)available));
        diskInfo.setUsed(FormatUtil.formatBytes((long)used));
        diskInfo.setUsageRate(DECIMAL_FORMAT.format((double)used / (double)total * 100.0));
        return diskInfo;
    }

    private SwapModel getSwapInfo(GlobalMemory memory) {
        SwapModel swapInfo = new SwapModel();
        swapInfo.setTotal(FormatUtil.formatBytes((long)memory.getVirtualMemory().getSwapTotal()));
        swapInfo.setAvailable(FormatUtil.formatBytes((long)(memory.getVirtualMemory().getSwapTotal() - memory.getVirtualMemory().getSwapUsed())));
        swapInfo.setUsageRate(DECIMAL_FORMAT.format((double)memory.getVirtualMemory().getSwapUsed() / (double)memory.getVirtualMemory().getSwapTotal() * 100.0));
        swapInfo.setUsed(FormatUtil.formatBytes((long)memory.getVirtualMemory().getSwapUsed()));
        return swapInfo;
    }

    private MemoryModel getMemoryInfo(GlobalMemory memory) {
        MemoryModel memoryInfo = new MemoryModel();
        memoryInfo.setTotal(FormatUtil.formatBytes((long)memory.getTotal()));
        memoryInfo.setAvailable(FormatUtil.formatBytes((long)memory.getAvailable()));
        memoryInfo.setUsed(FormatUtil.formatBytes((long)(memory.getTotal() - memory.getAvailable())));
        memoryInfo.setUsageRate(DECIMAL_FORMAT.format((double)(memory.getTotal() - memory.getAvailable()) / (double)memory.getTotal() * 100.0));
        return memoryInfo;
    }

    private CpuModel getCpuInfo(CentralProcessor processor) {
        CpuModel cpuInfo = new CpuModel();
        cpuInfo.setName(processor.getProcessorIdentifier().getName());
        cpuInfo.setPackageName(processor.getPhysicalPackageCount() + "\u4e2a\u7269\u7406CPU");
        cpuInfo.setCore(processor.getPhysicalProcessorCount() + "\u4e2a\u7269\u7406\u6838\u5fc3");
        cpuInfo.setCoreNumber(processor.getPhysicalProcessorCount());
        cpuInfo.setLogic(processor.getLogicalProcessorCount() + "\u4e2a\u903b\u8f91CPU");
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        cpuInfo.setUsed(DECIMAL_FORMAT.format(100.0 * (double)user / (double)totalCpu + 100.0 * (double)sys / (double)totalCpu));
        cpuInfo.setIdle(DECIMAL_FORMAT.format(100.0 * (double)idle / (double)totalCpu));
        return cpuInfo;
    }

    private SystemModel getSystemInfo(OperatingSystem operatingSystem) {
        String osName;
        SystemModel systemInfo = new SystemModel();
        String os = osName = System.getProperty("os.name");
        if (osName.contains("Linux")) {
            os = operatingSystem.toString();
        }
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        Date date = new Date(time);
        String formatBetween = DateUtil.formatBetween((Date)date, (Date)new Date(), (BetweenFormatter.Level)BetweenFormatter.Level.HOUR);
        systemInfo.setOs(os);
        systemInfo.setDay(formatBetween);
        systemInfo.setIp(MonitorUtil.getLocalhostIp());
        return systemInfo;
    }

    private static String getLocalhostIp() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isMulticastAddress()) continue;
                    String hostAddress = address.getHostAddress();
                    result.add(hostAddress);
                }
            }
        }
        catch (Exception networkInterfaces) {
            // empty catch block
        }
        String ip = String.join((CharSequence)",", result);
        return ip;
    }

    public CpuModel getCpu() {
        return this.cpu;
    }

    public DiskModel getDisk() {
        return this.disk;
    }

    public MemoryModel getMemory() {
        return this.memory;
    }

    public SwapModel getSwap() {
        return this.swap;
    }

    public SystemModel getSystem() {
        return this.system;
    }

    public void setCpu(CpuModel cpu) {
        this.cpu = cpu;
    }

    public void setDisk(DiskModel disk) {
        this.disk = disk;
    }

    public void setMemory(MemoryModel memory) {
        this.memory = memory;
    }

    public void setSwap(SwapModel swap) {
        this.swap = swap;
    }

    public void setSystem(SystemModel system) {
        this.system = system;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorUtil)) {
            return false;
        }
        MonitorUtil other = (MonitorUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CpuModel this$cpu = this.getCpu();
        CpuModel other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
            return false;
        }
        DiskModel this$disk = this.getDisk();
        DiskModel other$disk = other.getDisk();
        if (this$disk == null ? other$disk != null : !((Object)this$disk).equals(other$disk)) {
            return false;
        }
        MemoryModel this$memory = this.getMemory();
        MemoryModel other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        SwapModel this$swap = this.getSwap();
        SwapModel other$swap = other.getSwap();
        if (this$swap == null ? other$swap != null : !((Object)this$swap).equals(other$swap)) {
            return false;
        }
        SystemModel this$system = this.getSystem();
        SystemModel other$system = other.getSystem();
        return !(this$system == null ? other$system != null : !((Object)this$system).equals(other$system));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitorUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CpuModel $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
        DiskModel $disk = this.getDisk();
        result = result * 59 + ($disk == null ? 43 : ((Object)$disk).hashCode());
        MemoryModel $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        SwapModel $swap = this.getSwap();
        result = result * 59 + ($swap == null ? 43 : ((Object)$swap).hashCode());
        SystemModel $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : ((Object)$system).hashCode());
        return result;
    }

    public String toString() {
        return "MonitorUtil(cpu=" + this.getCpu() + ", disk=" + this.getDisk() + ", memory=" + this.getMemory() + ", swap=" + this.getSwap() + ", system=" + this.getSystem() + ")";
    }
}

