/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util.jobutil;

import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);
    private SchedulerFactory schedulerFactory = new StdSchedulerFactory();
    private String trigger = "tri_";

    public void addJob(String jobName, String jobGroupName, String cron, JobDataMap jobDataMap, Date startDate, Date endDate, Class<? extends Job> jobClass) {
        this.addJob(jobName, jobGroupName, jobClass, cron, jobDataMap, startDate, endDate);
    }

    public void updateJob(String jobName, String jobGroupName, String cron, JobDataMap jobDataMap, Date startDate, Date endDate) {
        this.updateJob(jobName, jobGroupName, this.trigger + jobName, this.trigger + jobGroupName, cron, jobDataMap, startDate, endDate);
    }

    public void removeJob(String jobName, String jobGroupName) {
        this.removeJob(jobName, jobGroupName, this.trigger + jobName, this.trigger + jobGroupName);
    }

    public void startJobNow(String jobName, String jobGroupName, JobDataMap jobDataMap, Class<? extends Job> jobClass) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobDetail jobDetail = null;
            jobDetail = jobDataMap != null ? JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).setJobData(jobDataMap).build() : JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity(this.trigger + jobName, this.trigger + jobGroupName);
            triggerBuilder.startNow();
            Trigger trigger = triggerBuilder.build();
            sched.scheduleJob(jobDetail, trigger);
            if (!sched.isShutdown()) {
                sched.start();
                log.info("\u7acb\u5373\u6267\u884c\u4e00\u6b21\u4efb\u52a1\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u7acb\u5373\u6267\u884c\u4e00\u6b21\u4efb\u52a1\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private void addJob(String jobName, String jobGroupName, Class<? extends Job> jobClass, String cron, JobDataMap jobDataMap, Date startDate, Date endDate) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobDetail jobDetail = null;
            jobDetail = jobDataMap != null ? JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).setJobData(jobDataMap).build() : JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity(this.trigger + jobName, this.trigger + jobGroupName);
            triggerBuilder.startNow();
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
            if (endDate != null) {
                triggerBuilder.endAt(endDate);
            }
            CronTrigger trigger = (CronTrigger)triggerBuilder.build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
                log.info("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u6210\u529f,\u4efb\u52a1\u540d\uff1a{}", (Object)jobName);
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private void removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
            JobDetail jobDetail = sched.getJobDetail(jobKey);
            if (null != jobDetail) {
                TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
                sched.pauseTrigger(triggerKey);
                sched.unscheduleJob(triggerKey);
                sched.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            log.error("\u79fb\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private void updateJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, String cron, JobDataMap jobDataMap, Date startDate, Date endDate) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            CronTrigger trigger = (CronTrigger)sched.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(cron)) {
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
                if (jobDataMap != null) {
                    triggerBuilder.withIdentity(triggerName, triggerGroupName).usingJobData(jobDataMap);
                } else {
                    triggerBuilder.withIdentity(triggerName, triggerGroupName);
                }
                triggerBuilder.startNow();
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
                if (endDate != null) {
                    triggerBuilder.endAt(endDate);
                }
                trigger = (CronTrigger)triggerBuilder.build();
                sched.rescheduleJob(triggerKey, (Trigger)trigger);
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private boolean isTriKey(String jobName, String jobGroupName) {
        boolean flag = false;
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)(this.trigger + jobName), (String)(this.trigger + jobGroupName));
            CronTrigger trigger = (CronTrigger)sched.getTrigger(triggerKey);
            if (trigger != null) {
                flag = true;
            }
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u4efb\u52a1\u8c03\u5ea6\u89e6\u53d1\u5668\u662f\u5426\u5b58\u5728:{}", (Object)e.getMessage());
        }
        return flag;
    }

    public void startJobs() {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            sched.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdownJobs() {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            if (!sched.isShutdown()) {
                sched.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

