/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util.jobutil;

import cn.hutool.core.bean.BeanUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.model.ContentModel;
import com.bringspring.system.scheduletask.service.TimeService;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(TimeJob.class);

    public void execute(JobExecutionContext context) {
        JobDataMap dataMap = context.getMergedJobDataMap();
        ContentModel model = dataMap.get((Object)"content") != null ? (ContentModel)dataMap.get((Object)"content") : null;
        String type = dataMap.getString("type");
        String id = dataMap.getString("id");
        String tenantId = dataMap.getString("tenantId");
        String token = dataMap.getString("token");
        TimeTaskEntity timeTaskEntity = (TimeTaskEntity)dataMap.get((Object)"timeTaskEntity");
        Map stringObjectMap = BeanUtil.beanToMap((Object)timeTaskEntity, (String[])new String[0]);
        String tenantDbConnectionString = dataMap.getString("tenantDbConnectionString");
        if (model != null) {
            if (StringUtils.isNotEmpty((String)tenantId)) {
                DataSourceContextHolder.setDatasource((String)tenantId, (String)tenantDbConnectionString);
            }
            TimeService timeService = (TimeService)SpringContext.getBean(TimeService.class);
            if ("1".equals(type)) {
                timeService.connector(model, id, token, tenantId, tenantDbConnectionString);
            } else if ("3".equals(type)) {
                timeService.localTask(model, id, token, tenantId, tenantDbConnectionString, stringObjectMap);
            } else {
                timeService.storage(model, id, tenantId, tenantDbConnectionString, token);
            }
        }
    }
}

