/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util.visualUtil;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.ModuleButtonEntity;
import com.bringspring.system.base.entity.ModuleColumnEntity;
import com.bringspring.system.base.entity.ModuleDataAuthorizeEntity;
import com.bringspring.system.base.entity.ModuleDataAuthorizeSchemeEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.entity.ModuleFormEntity;
import com.bringspring.system.base.model.module.PropertyJsonModel;
import com.bringspring.system.base.model.online.AuthFlieds;
import com.bringspring.system.base.model.online.PerColModels;
import com.bringspring.system.base.model.online.VisualMenuModel;
import com.bringspring.system.base.service.ModuleButtonService;
import com.bringspring.system.base.service.ModuleColumnService;
import com.bringspring.system.base.service.ModuleDataAuthorizeSchemeService;
import com.bringspring.system.base.service.ModuleDataAuthorizeService;
import com.bringspring.system.base.service.ModuleFormService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionEnum;
import com.bringspring.system.permission.model.authorize.ConditionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PubulishUtil {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ModuleButtonService moduleButtonService;
    @Autowired
    private ModuleColumnService moduleColumnService;
    @Autowired
    private ModuleFormService moduleFormService;
    @Autowired
    private ModuleDataAuthorizeService moduleDataAuthorizeService;
    @Autowired
    private ModuleDataAuthorizeSchemeService moduleDataAuthorizeSchemeService;
    private static final Integer Type = 3;
    private static final String pcCate = "\u529f\u80fd\u793a\u4f8b";
    private static final String appCate = "\u79fb\u52a8\u5e94\u7528";
    private static final String pcCategory = "Web";
    private static final String appCategory = "App";
    private String parentId;
    private String appParentId;
    private static final String icon = "icon-ym icon-ym-webForm";

    public Integer publishMenu(VisualMenuModel visualMenuModel) {
        String menuId;
        UserInfo userInfo = this.userProvider.get();
        List<ModuleEntity> moduleList = this.moduleService.getModuleList(visualMenuModel.getId());
        ModuleEntity moduleEntity = new ModuleEntity();
        String uuid = RandomUtil.uuId();
        String appUuid = RandomUtil.uuId();
        PerColModels pcPerCols = visualMenuModel.getPcPerCols();
        PerColModels appPerCols = visualMenuModel.getAppPerCols();
        moduleEntity.setCategory(pcCategory);
        moduleEntity.setFullName(visualMenuModel.getFullName());
        moduleEntity.setEnCode(visualMenuModel.getEncode());
        moduleEntity.setIcon(icon);
        moduleEntity.setType(Type);
        moduleEntity.setModuleId(visualMenuModel.getId());
        PropertyJsonModel jsonModel = new PropertyJsonModel();
        jsonModel.setModuleId(visualMenuModel.getId());
        jsonModel.setIconBackgroundColor("");
        jsonModel.setIsTree(0);
        moduleEntity.setPropertyJson(JsonUtil.getObjectToString((Object)jsonModel));
        moduleEntity.setSortCode(999L);
        moduleEntity.setEnabledMark(1);
        moduleEntity.setIsButtonAuthorize(1);
        moduleEntity.setIsColumnAuthorize(1);
        moduleEntity.setIsDataAuthorize(1);
        moduleEntity.setIsFormAuthorize(1);
        moduleEntity.setCreatorTime(DateUtil.getNowDate());
        moduleEntity.setCreatorUserId(userInfo.getUserId());
        moduleEntity.setId(uuid);
        moduleEntity.setUrlAddress("model/" + visualMenuModel.getEncode());
        boolean menu = false;
        if (1 == visualMenuModel.getPc()) {
            List pcModuleList = moduleList.stream().filter(module -> pcCategory.equals(module.getCategory())).collect(Collectors.toList());
            if (pcModuleList.size() > 0) {
                for (ModuleEntity entity : pcModuleList) {
                    menuId = entity.getId();
                    this.alterPer(entity, pcPerCols);
                    moduleEntity.setParentId(entity.getParentId());
                    moduleEntity.setId(menuId);
                    menu = this.moduleService.update(entity.getId(), moduleEntity);
                }
            } else {
                moduleEntity.setParentId(visualMenuModel.getPcModuleParentId());
                if (StringUtils.isEmpty((String)moduleEntity.getParentId())) {
                    return 3;
                }
                menu = this.createMenu(moduleEntity);
                this.batchCreatePermissions(pcPerCols, uuid);
            }
        }
        moduleEntity.setCategory(appCategory);
        moduleEntity.setId(appUuid);
        moduleEntity.setUrlAddress("/pages/apply/dynamicModel/index?id=" + visualMenuModel.getId());
        moduleEntity.setEnCode(visualMenuModel.getEncode());
        if (1 == visualMenuModel.getApp()) {
            List appModuleList = moduleList.stream().filter(module -> appCategory.equals(module.getCategory())).collect(Collectors.toList());
            if (appModuleList.size() > 0) {
                for (ModuleEntity entity : appModuleList) {
                    menuId = entity.getId();
                    this.alterPer(entity, appPerCols);
                    moduleEntity.setParentId(entity.getParentId());
                    moduleEntity.setId(menuId);
                    menu = this.moduleService.update(entity.getId(), moduleEntity);
                }
            } else {
                moduleEntity.setParentId(visualMenuModel.getAppModuleParentId());
                if (StringUtils.isEmpty((String)moduleEntity.getParentId())) {
                    return 3;
                }
                menu = this.createMenu(moduleEntity);
                this.batchCreatePermissions(appPerCols, appUuid);
            }
        }
        if (!menu) {
            return 2;
        }
        return 1;
    }

    private boolean createMenu(ModuleEntity moduleEntity) {
        if (this.moduleService.isExistByFullName(moduleEntity, moduleEntity.getCategory())) {
            return false;
        }
        if (this.moduleService.isExistByEnCode(moduleEntity, moduleEntity.getCategory())) {
            return false;
        }
        this.moduleService.create(moduleEntity);
        return true;
    }

    private void batchCreatePermissions(PerColModels perColModels, String moduleId) {
        Boolean exist;
        ArrayList buttonPermission = Objects.nonNull(perColModels.getButtonPermission()) ? perColModels.getButtonPermission() : new ArrayList();
        ArrayList formPermission = Objects.nonNull(perColModels.getFormPermission()) ? perColModels.getFormPermission() : new ArrayList();
        ArrayList listPermission = Objects.nonNull(perColModels.getListPermission()) ? perColModels.getListPermission() : new ArrayList();
        ArrayList dataPermission = Objects.nonNull(perColModels.getDataPermission()) ? perColModels.getDataPermission() : new ArrayList();
        ArrayList dataPermissionScheme = Objects.nonNull(perColModels.getDataPermissionScheme()) ? perColModels.getDataPermissionScheme() : new ArrayList();
        List buttonEntities = buttonPermission.stream().map(button -> {
            ModuleButtonEntity buttonEntity = new ModuleButtonEntity();
            buttonEntity.setEnabledMark(button.getStatus() != false ? 1 : 0);
            buttonEntity.setEnCode(button.getEncode());
            buttonEntity.setFullName(button.getFullName());
            buttonEntity.setParentId("-1");
            buttonEntity.setModuleId(moduleId);
            buttonEntity.setSortCode(0L);
            return buttonEntity;
        }).collect(Collectors.toList());
        List moduleFormEntities = formPermission.stream().map(form -> {
            ModuleFormEntity formEntity = new ModuleFormEntity();
            formEntity.setEnabledMark(form.getStatus() != false ? 1 : 0);
            formEntity.setEnCode(form.getEncode());
            formEntity.setFullName(form.getFullName());
            formEntity.setParentId("-1");
            formEntity.setModuleId(moduleId);
            formEntity.setFieldRule(form.getRule());
            formEntity.setSortCode(0L);
            return formEntity;
        }).collect(Collectors.toList());
        List moduleColumnEntities = listPermission.stream().map(list -> {
            ModuleColumnEntity moduleColumnEntity = new ModuleColumnEntity();
            moduleColumnEntity.setEnabledMark(list.getStatus() != false ? 1 : 0);
            moduleColumnEntity.setEnCode(list.getEncode());
            moduleColumnEntity.setFullName(list.getFullName());
            moduleColumnEntity.setParentId("-1");
            moduleColumnEntity.setModuleId(moduleId);
            moduleColumnEntity.setSortCode(0L);
            moduleColumnEntity.setFieldRule(list.getRule());
            return moduleColumnEntity;
        }).collect(Collectors.toList());
        ArrayList<ModuleDataAuthorizeEntity> moduleDataEntities = new ArrayList<ModuleDataAuthorizeEntity>();
        for (Iterator<Object> authFlieds : dataPermission) {
            ModuleDataAuthorizeEntity authorizeEntity = new ModuleDataAuthorizeEntity();
            authorizeEntity.setConditionSymbol("Equal");
            authorizeEntity.setId(((AuthFlieds)((Object)authFlieds)).getId());
            authorizeEntity.setDescription("\u540c\u6b65\u83dc\u5355\u81ea\u52a8\u751f\u6210");
            authorizeEntity.setEnCode(((AuthFlieds)((Object)authFlieds)).getEncode());
            authorizeEntity.setFieldRule(0);
            authorizeEntity.setFullName(((AuthFlieds)((Object)authFlieds)).getFullName());
            authorizeEntity.setModuleId(moduleId);
            authorizeEntity.setType("varchar");
            authorizeEntity.setConditionText(((AuthFlieds)((Object)authFlieds)).getAuthCondition());
            authorizeEntity.setDeleteMark(0);
            moduleDataEntities.add(authorizeEntity);
        }
        ArrayList<ModuleDataAuthorizeEntity> moduleDataSchemeEntities = new ArrayList<ModuleDataAuthorizeEntity>();
        for (AuthFlieds authFlieds : dataPermissionScheme) {
            ModuleDataAuthorizeEntity authorizeEntity = new ModuleDataAuthorizeEntity();
            authorizeEntity.setConditionSymbol("Equal");
            authorizeEntity.setId(authFlieds.getId());
            authorizeEntity.setDescription("\u540c\u6b65\u83dc\u5355\u81ea\u52a8\u751f\u6210");
            authorizeEntity.setEnCode(authFlieds.getEncode());
            authorizeEntity.setFieldRule(0);
            authorizeEntity.setFullName(authFlieds.getFullName());
            authorizeEntity.setModuleId(moduleId);
            authorizeEntity.setType("varchar");
            authorizeEntity.setConditionText(authFlieds.getAuthCondition());
            authorizeEntity.setDeleteMark(0);
            moduleDataSchemeEntities.add(authorizeEntity);
        }
        for (ModuleButtonEntity btn : buttonEntities) {
            this.moduleButtonService.create(btn);
        }
        for (ModuleFormEntity formEntity : moduleFormEntities) {
            this.moduleFormService.create(formEntity);
        }
        for (ModuleColumnEntity moduleColumnEntity : moduleColumnEntities) {
            this.moduleColumnService.create(moduleColumnEntity);
        }
        for (ModuleDataAuthorizeEntity authorizeEntity : moduleDataEntities) {
            this.moduleDataAuthorizeService.create(authorizeEntity);
        }
        for (ModuleDataAuthorizeEntity moduleDataAuthorizeEntity : moduleDataSchemeEntities) {
            this.moduleDataAuthorizeSchemeService.create(this.getSchemeEntity(moduleDataAuthorizeEntity));
        }
        if (Objects.nonNull(perColModels.getDataPermission()) && !(exist = this.moduleDataAuthorizeSchemeService.isExistByEnCode(null, "alldata", moduleId)).booleanValue()) {
            ModuleDataAuthorizeSchemeEntity moduleDataAuthorizeSchemeEntity = new ModuleDataAuthorizeSchemeEntity();
            moduleDataAuthorizeSchemeEntity.setFullName("\u5168\u90e8\u6570\u636e");
            moduleDataAuthorizeSchemeEntity.setEnCode("alldata");
            moduleDataAuthorizeSchemeEntity.setModuleId(moduleId);
            this.moduleDataAuthorizeSchemeService.create(moduleDataAuthorizeSchemeEntity);
        }
    }

    private void getModuleParentId() {
        QueryWrapper moduleWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)moduleWrapper.lambda().eq(ModuleEntity::getFullName, (Object)pcCate)).eq(ModuleEntity::getCategory, (Object)pcCategory);
        ModuleEntity pcModule = (ModuleEntity)this.moduleService.getOne((Wrapper)moduleWrapper);
        if (pcModule != null) {
            this.setParentId(pcModule.getId());
        }
        QueryWrapper appWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)appWrapper.lambda().eq(ModuleEntity::getFullName, (Object)appCate)).eq(ModuleEntity::getCategory, (Object)appCategory);
        ModuleEntity appModule = (ModuleEntity)this.moduleService.getOne((Wrapper)appWrapper);
        if (appModule != null) {
            this.setAppParentId(appModule.getId());
        }
    }

    private void alterPer(ModuleEntity entity, PerColModels perColModel) {
        String moduleMainId = entity.getId();
        PerColModels perColModels = new PerColModels();
        if (perColModel.getListPermission() != null) {
            HashMap<String, String> colMap = new HashMap<String, String>();
            List<ModuleColumnEntity> columnEntities = this.moduleColumnService.getList(moduleMainId);
            columnEntities.stream().forEach(col -> colMap.put(col.getEnCode(), col.getId()));
            ArrayList<AuthFlieds> listPermission = perColModel.getListPermission() != null ? perColModel.getListPermission() : new ArrayList<AuthFlieds>();
            List<AuthFlieds> authColList = this.intersectList1(listPermission, colMap);
            HashMap stateMap = new HashMap();
            authColList.stream().forEach(auth -> stateMap.put(auth.getEncode(), auth.getStatus()));
            for (ModuleColumnEntity columnEntity : columnEntities) {
                if (!Objects.nonNull(stateMap.get(columnEntity.getEnCode()))) continue;
                columnEntity.setEnabledMark((Boolean)stateMap.get(columnEntity.getEnCode()) != false ? 1 : 0);
                this.moduleColumnService.update(columnEntity.getId(), columnEntity);
            }
            List<AuthFlieds> authColCreList = this.intersectList2(listPermission, authColList);
            perColModels.setListPermission(authColCreList);
            Map<String, String> colDataMap = this.intersectList3(colMap, authColList);
            List colEnties = columnEntities.stream().filter(col -> colDataMap.get(col.getEnCode()) != null).collect(Collectors.toList());
            for (ModuleColumnEntity moduleColumnEntity : colEnties) {
                this.moduleColumnService.delete(moduleColumnEntity);
            }
        }
        if (perColModel.getFormPermission() != null) {
            HashMap<String, String> formMap = new HashMap<String, String>();
            List<ModuleFormEntity> formEntities = this.moduleFormService.getList(moduleMainId);
            formEntities.stream().forEach(form -> formMap.put(form.getEnCode(), form.getId()));
            ArrayList<AuthFlieds> formPermission = perColModel.getFormPermission() != null ? perColModel.getFormPermission() : new ArrayList<AuthFlieds>();
            List<AuthFlieds> authFormList = this.intersectList1(formPermission, formMap);
            HashMap stateFMap = new HashMap();
            authFormList.stream().forEach(auth -> stateFMap.put(auth.getEncode(), auth.getStatus()));
            for (ModuleFormEntity formEntity : formEntities) {
                if (!Objects.nonNull(stateFMap.get(formEntity.getEnCode()))) continue;
                formEntity.setEnabledMark((Boolean)stateFMap.get(formEntity.getEnCode()) != false ? 1 : 0);
                this.moduleFormService.update(formEntity.getId(), formEntity);
            }
            List<AuthFlieds> authFormCreList = this.intersectList2(formPermission, authFormList);
            perColModels.setFormPermission(authFormCreList);
            Map<String, String> formDataMap = this.intersectList3(formMap, authFormList);
            List formEnties = formEntities.stream().filter(form -> formDataMap.get(form.getEnCode()) != null).collect(Collectors.toList());
            for (ModuleFormEntity formEntity : formEnties) {
                this.moduleFormService.delete(formEntity);
            }
        }
        if (perColModel.getButtonPermission() != null) {
            HashMap<String, String> btnMap = new HashMap<String, String>();
            List<ModuleButtonEntity> buttonEntities = this.moduleButtonService.getList(moduleMainId);
            buttonEntities.stream().forEach(btn -> btnMap.put(btn.getEnCode(), btn.getId()));
            ArrayList<AuthFlieds> buttonPermission = perColModel.getButtonPermission() != null ? perColModel.getButtonPermission() : new ArrayList<AuthFlieds>();
            List<AuthFlieds> authBtnList = this.intersectList1(buttonPermission, btnMap);
            HashMap stateBMap = new HashMap();
            authBtnList.stream().forEach(auth -> stateBMap.put(auth.getEncode(), auth.getStatus()));
            for (ModuleButtonEntity btnEntity : buttonEntities) {
                if (!Objects.nonNull(stateBMap.get(btnEntity.getEnCode()))) continue;
                btnEntity.setEnabledMark((Boolean)stateBMap.get(btnEntity.getEnCode()) != false ? 1 : 0);
                this.moduleButtonService.update(btnEntity.getId(), btnEntity);
            }
            List<AuthFlieds> authBtnCreList = this.intersectList2(buttonPermission, authBtnList);
            Map<String, String> btnDataMap = this.intersectList3(btnMap, authBtnList);
            List btnEnties = buttonEntities.stream().filter(btn -> btnDataMap.get(btn.getEnCode()) != null).collect(Collectors.toList());
            for (ModuleButtonEntity buttonEntity : btnEnties) {
                this.moduleButtonService.delete(buttonEntity);
            }
            perColModels.setButtonPermission(authBtnCreList);
        }
        if (perColModel.getDataPermission() != null) {
            List<ModuleDataAuthorizeEntity> dataAuthorizeEntityList = this.moduleDataAuthorizeService.getList(moduleMainId);
            ArrayList<AuthFlieds> dataPermission = perColModel.getDataPermission() != null ? perColModel.getDataPermission() : new ArrayList<AuthFlieds>();
            ArrayList<AuthFlieds> authDataList = new ArrayList<AuthFlieds>();
            for (AuthFlieds authFlieds : dataPermission) {
                for (ModuleDataAuthorizeEntity authorizeEntity : dataAuthorizeEntityList) {
                    if (!authorizeEntity.getConditionText().equalsIgnoreCase(authFlieds.getAuthCondition()) || !authorizeEntity.getEnCode().equalsIgnoreCase(authFlieds.getEncode())) continue;
                    authDataList.add(authFlieds);
                }
            }
            List<AuthFlieds> authDataCreList = this.intersectList2(dataPermission, authDataList);
            ArrayList<ModuleDataAuthorizeEntity> dataEntities = new ArrayList<ModuleDataAuthorizeEntity>(dataAuthorizeEntityList);
            if (authDataList.size() > 0) {
                for (AuthFlieds authFlieds : authDataList) {
                    for (ModuleDataAuthorizeEntity moduleDataAuthorizeEntity : dataAuthorizeEntityList) {
                        if (moduleDataAuthorizeEntity.getDeleteMark() == null) {
                            dataEntities.remove(moduleDataAuthorizeEntity);
                            continue;
                        }
                        if (!authFlieds.getEncode().equalsIgnoreCase(moduleDataAuthorizeEntity.getEnCode()) || !authFlieds.getAuthCondition().equals(moduleDataAuthorizeEntity.getConditionText())) continue;
                        dataEntities.remove(moduleDataAuthorizeEntity);
                    }
                }
            }
            for (ModuleDataAuthorizeEntity dataEntity : dataEntities) {
                this.moduleDataAuthorizeService.delete(dataEntity);
            }
            perColModels.setDataPermission(authDataCreList);
        }
        if (perColModel.getDataPermissionScheme() != null) {
            ArrayList<AuthFlieds> togetherList = new ArrayList<AuthFlieds>();
            List<ModuleDataAuthorizeSchemeEntity> dataAuthorizeSchemeList = this.moduleDataAuthorizeSchemeService.getList(moduleMainId);
            List<AuthFlieds> dataPermissionScheme = perColModel.getDataPermissionScheme();
            for (AuthFlieds authFlieds : dataPermissionScheme) {
                for (ModuleDataAuthorizeSchemeEntity schemeEntity : dataAuthorizeSchemeList) {
                    if (schemeEntity.getConditionJson() == null || !schemeEntity.getConditionJson().contains(authFlieds.getEncode()) || !schemeEntity.getConditionJson().contains(authFlieds.getAuthCondition())) continue;
                    togetherList.add(authFlieds);
                }
            }
            List<AuthFlieds> authCreFields = this.intersectList2(dataPermissionScheme, togetherList);
            ArrayList<ModuleDataAuthorizeSchemeEntity> deleteSchemeList = new ArrayList<ModuleDataAuthorizeSchemeEntity>(dataAuthorizeSchemeList);
            if (togetherList.size() > 0) {
                for (AuthFlieds flieds : togetherList) {
                    for (ModuleDataAuthorizeSchemeEntity schemeEntity : dataAuthorizeSchemeList) {
                        if (schemeEntity.getConditionJson() == null || schemeEntity.getDeleteMark() == null) {
                            deleteSchemeList.remove(schemeEntity);
                            continue;
                        }
                        if (!schemeEntity.getConditionJson().contains(flieds.getEncode())) continue;
                        deleteSchemeList.remove(schemeEntity);
                    }
                }
            }
            for (ModuleDataAuthorizeSchemeEntity scheme : deleteSchemeList) {
                this.moduleDataAuthorizeSchemeService.delete(scheme);
            }
            perColModels.setDataPermissionScheme(authCreFields);
        }
        this.batchCreatePermissions(perColModels, moduleMainId);
    }

    private List<AuthFlieds> intersectList1(List<AuthFlieds> authFlieds, Map<String, String> databaseMap) {
        LinkedList<AuthFlieds> lastList = new LinkedList<AuthFlieds>();
        for (AuthFlieds authFlied : authFlieds) {
            if (!databaseMap.containsKey(authFlied.getEncode())) continue;
            lastList.add(authFlied);
        }
        return lastList;
    }

    private List<AuthFlieds> intersectList2(List<AuthFlieds> auth1, List<AuthFlieds> auth2) {
        auth1.removeAll(auth2);
        return auth1;
    }

    private Map<String, String> intersectList3(Map<String, String> databaseMap, List<AuthFlieds> auth2) {
        HashMap<String, String> changeMap = new HashMap<String, String>();
        changeMap.putAll(databaseMap);
        for (AuthFlieds authFlieds : auth2) {
            if (databaseMap.get(authFlieds.getEncode()) == null) continue;
            changeMap.remove(authFlieds.getEncode());
        }
        return changeMap;
    }

    private ModuleDataAuthorizeSchemeEntity getSchemeEntity(ModuleDataAuthorizeEntity authorizeEntity) {
        ModuleDataAuthorizeSchemeEntity schemeEntity = new ModuleDataAuthorizeSchemeEntity();
        schemeEntity.setDeleteMark(authorizeEntity.getDeleteMark());
        schemeEntity.setModuleId(authorizeEntity.getModuleId());
        schemeEntity.setFullName(this.getSchemeNameByCondition(authorizeEntity.getConditionText()));
        String conditionText = "\u3010{" + authorizeEntity.getFullName() + "}{\u7b49\u4e8e}{" + authorizeEntity.getConditionText() + "}\u3011";
        ArrayList<ConditionModel> conditionModels = new ArrayList<ConditionModel>();
        ConditionModel conditionModel = new ConditionModel();
        conditionModel.setLogic("and");
        ConditionModel.ConditionItemModel conditionItemModel = new ConditionModel.ConditionItemModel(conditionModel);
        conditionItemModel.setField(authorizeEntity.getEnCode());
        conditionItemModel.setId(authorizeEntity.getId());
        conditionItemModel.setOp("Equal");
        conditionItemModel.setValue(authorizeEntity.getConditionText());
        conditionItemModel.setType("Varchar");
        ArrayList<ConditionModel.ConditionItemModel> groups = new ArrayList<ConditionModel.ConditionItemModel>();
        groups.add(conditionItemModel);
        conditionModel.setGroups(groups);
        conditionModels.add(conditionModel);
        schemeEntity.setConditionJson(JsonUtil.getObjectToString(conditionModels));
        schemeEntity.setConditionText(conditionText);
        return schemeEntity;
    }

    private String getSchemeNameByCondition(String condition) {
        String name = "default";
        if (AuthorizeConditionEnum.USER.getCondition().equals(condition)) {
            name = "\u5f53\u524d\u7528\u6237";
        } else if (AuthorizeConditionEnum.USERANDUNDER.getCondition().equals(condition)) {
            name = "\u5f53\u524d\u7528\u6237\u53ca\u4e0b\u5c5e";
        } else if (AuthorizeConditionEnum.ORGANIZE.getCondition().equals(condition)) {
            name = "\u5f53\u524d\u7ec4\u7ec7";
        } else if (AuthorizeConditionEnum.ORGANIZEANDUNDER.getCondition().equals(condition)) {
            name = "\u7ec4\u7ec7\u53ca\u5b50\u7ec4\u7ec7";
        }
        return name;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setAppParentId(String appParentId) {
        this.appParentId = appParentId;
    }
}

