/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.config.mutil;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.handler.ContactChangeHandler;
import com.bringspring.system.external.handler.EnterAgentHandler;
import com.bringspring.system.external.handler.LocationHandler;
import com.bringspring.system.external.handler.LogHandler;
import com.bringspring.system.external.handler.MenuHandler;
import com.bringspring.system.external.handler.MsgHandler;
import com.bringspring.system.external.handler.NullHandler;
import com.bringspring.system.external.handler.SubscribeHandler;
import com.bringspring.system.external.handler.UnsubscribeHandler;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.message.WxCpMessageHandler;
import me.chanjar.weixin.cp.message.WxCpMessageRouter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxCpConfiguration {
    @Autowired
    private LogHandler logHandler;
    @Autowired
    private NullHandler nullHandler;
    @Autowired
    private LocationHandler locationHandler;
    @Autowired
    private MenuHandler menuHandler;
    @Autowired
    private MsgHandler msgHandler;
    @Autowired
    private ContactChangeHandler contactChangeHandler;
    @Autowired
    private UnsubscribeHandler unsubscribeHandler;
    @Autowired
    private SubscribeHandler subscribeHandler;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    private Map<String, WxCpMessageRouter> routers = Maps.newHashMap();
    private Map<String, WeComModel> weComModels = Maps.newHashMap();
    private Map<String, WxCpService> corpServices = Maps.newHashMap();
    private Map<String, WxCpService> cpServices = Maps.newHashMap();

    public Map<String, WxCpMessageRouter> getRouters() {
        return this.routers;
    }

    public Map<String, WeComModel> getWeComModels() {
        return this.weComModels;
    }

    public boolean getIsLinkedCorp() {
        Optional<WeComModel> firstValue;
        if (CollectionUtil.isNotEmpty(this.weComModels) && this.weComModels.size() == 1 && (firstValue = this.weComModels.values().stream().findFirst()).isPresent() && firstValue.get().getIsLinkedCorp().booleanValue()) {
            return firstValue.get().getIsLinkedCorp();
        }
        return false;
    }

    public WxCpService getCpService(String corpId, Integer agentId) {
        String key = corpId + agentId;
        WxCpService cpService = this.cpServices.get(key);
        if (ObjectUtil.isEmpty((Object)cpService)) {
            this.initServices();
            cpService = this.cpServices.get(key);
        }
        return cpService;
    }

    public WeComModel getWeComModel(String corpId) {
        WeComModel weComModel = this.weComModels.get(corpId);
        if (ObjectUtil.isEmpty((Object)weComModel)) {
            this.initServices();
            weComModel = this.weComModels.get(corpId);
        }
        return weComModel;
    }

    public WxCpService getCorpService(String corpId) {
        String key = corpId;
        WxCpService corpService = this.corpServices.get(key);
        if (ObjectUtil.isEmpty((Object)corpService)) {
            this.initServices();
            corpService = this.corpServices.get(key);
        }
        return corpService;
    }

    public void initServices() {
        try {
            List<McMsgAccountEntity> account = this.mcMsgAccountService.getAccountByCategory(ChannelTypeEnum.QY_MSG.getCode());
            if (CollectionUtil.isEmpty(account)) {
                throw new WxRuntimeException("\u672a\u6dfb\u52a0\u4f01\u4e1a\u5fae\u4fe1\u76f8\u5173\u5e94\u7528\u914d\u7f6e\uff01");
            }
            ArrayList listModel = new ArrayList();
            account.stream().forEach(a -> {
                WeComModel weComModel = new WeComModel();
                weComModel.setAccountConfigId(a.getId());
                weComModel.setName(a.getFullName());
                weComModel.setQyhCorpId(a.getEnterpriseId());
                weComModel.setQyhCorpSecret(a.getAppKey());
                weComModel.setQyhAgentId(a.getAgentId());
                weComModel.setQyhAgentSecret(a.getBearer());
                weComModel.setToken(a.getAppId());
                weComModel.setEncodingAESKey(a.getAppSecret());
                weComModel.setIsLinkedCorp(Boolean.parseBoolean(a.getProgramState()));
                weComModel.setQyhMobileUrl(a.getAddress());
                listModel.add(weComModel);
            });
            SysConfigEntity weComInfo = this.sysConfigService.getConfigByKeyName("weCom");
            if (ObjectUtil.isNotEmpty((Object)weComInfo) && StringUtils.isNotEmpty((String)weComInfo.getKeyValue())) {
                String keyValue = weComInfo.getKeyValue();
                List sysConfig = JsonUtil.getJsonToList((String)keyValue, WeComModel.class);
                sysConfig.stream().forEach(a -> listModel.stream().forEach(b -> {
                    if (b.getAccountConfigId().equals(a.getAccountConfigId())) {
                        b.setQyhIsSynOrg(a.getQyhIsSynOrg());
                        b.setQyhIsSynUser(a.getQyhIsSynUser());
                        b.setOrgParent(a.getOrgParent());
                    }
                }));
            }
            this.cpServices = listModel.stream().map(a -> {
                String qyhCorpId = a.getQyhCorpId();
                Integer agentId = Integer.valueOf(a.getQyhAgentId());
                WxCpDefaultConfigImpl configStorage = new WxCpDefaultConfigImpl();
                configStorage.setCorpId(qyhCorpId);
                configStorage.setAgentId(agentId);
                configStorage.setCorpSecret(a.getQyhAgentSecret());
                configStorage.setToken(a.getToken());
                configStorage.setAesKey(a.getEncodingAESKey());
                WxCpServiceImpl service = new WxCpServiceImpl();
                service.setWxCpConfigStorage((WxCpConfigStorage)configStorage);
                this.routers.put(qyhCorpId + agentId, this.newRouter((WxCpService)service));
                return service;
            }).collect(Collectors.toMap(service -> service.getWxCpConfigStorage().getCorpId() + service.getWxCpConfigStorage().getAgentId(), a -> a));
            this.corpServices = listModel.stream().map(a -> {
                String qyhCorpId = a.getQyhCorpId();
                Integer agentId = Integer.valueOf(a.getQyhAgentId());
                WxCpDefaultConfigImpl configStorage = new WxCpDefaultConfigImpl();
                configStorage.setCorpId(qyhCorpId);
                configStorage.setCorpSecret(a.getQyhCorpSecret());
                configStorage.setAgentId(agentId);
                configStorage.setToken(a.getToken());
                configStorage.setAesKey(a.getEncodingAESKey());
                WxCpServiceImpl service = new WxCpServiceImpl();
                service.setWxCpConfigStorage((WxCpConfigStorage)configStorage);
                this.routers.put(qyhCorpId, this.newRouter((WxCpService)service));
                this.weComModels.put(qyhCorpId, (WeComModel)a);
                return service;
            }).collect(Collectors.toMap(service -> service.getWxCpConfigStorage().getCorpId(), a -> a));
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }

    private WxCpMessageRouter newRouter(WxCpService wxCpService) {
        WxCpMessageRouter newRouter = new WxCpMessageRouter(wxCpService);
        newRouter.rule().handler((WxCpMessageHandler)this.logHandler).next();
        newRouter.rule().async(false).msgType("event").event("click").handler((WxCpMessageHandler)this.menuHandler).end();
        newRouter.rule().async(false).msgType("event").event("view").handler((WxCpMessageHandler)this.nullHandler).end();
        newRouter.rule().async(false).msgType("event").event("subscribe").handler((WxCpMessageHandler)this.subscribeHandler).end();
        newRouter.rule().async(false).msgType("event").event("unsubscribe").handler((WxCpMessageHandler)this.unsubscribeHandler).end();
        newRouter.rule().async(false).msgType("event").event("LOCATION").handler((WxCpMessageHandler)this.locationHandler).end();
        newRouter.rule().async(false).msgType("location").handler((WxCpMessageHandler)this.locationHandler).end();
        newRouter.rule().async(false).msgType("event").event("SCAN").handler((WxCpMessageHandler)this.nullHandler).end();
        newRouter.rule().async(false).msgType("event").event("change_contact").handler((WxCpMessageHandler)this.contactChangeHandler).end();
        newRouter.rule().async(false).msgType("event").event("enter_agent").handler((WxCpMessageHandler)new EnterAgentHandler()).end();
        newRouter.rule().async(false).handler((WxCpMessageHandler)this.msgHandler).end();
        return newRouter;
    }
}

