/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.util.JSSDKUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jssdk/common"})
public class JSSDKCommonController {
    private static final Logger log = LoggerFactory.getLogger(JSSDKCommonController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    WxCpConfiguration wxCpConfiguration;

    @GetMapping(value={"/getWxConfig"})
    public ActionResult list(String url) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        if (StringUtils.isNotEmpty((String)url)) {
            String currentOrganizeId = userInfo.getOrganizeId();
            SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", currentOrganizeId);
            String corpId = synThirdInfoEntity.getCropId();
            if (StringUtils.isNotEmpty((String)corpId)) {
                WeComModel weComModel = this.wxCpConfiguration.getWeComModel(corpId);
                if (weComModel == null) {
                    return ActionResult.fail((String)String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e", corpId));
                }
                String qyhCorpId = weComModel.getQyhCorpId();
                String qyhAgentSecret = weComModel.getQyhAgentSecret();
                if (StringUtils.isNotEmpty((String)qyhCorpId) && StringUtils.isNotEmpty((String)qyhAgentSecret)) {
                    JSSDKUtil.setCorpId(qyhCorpId);
                    JSSDKUtil.setCorpSecret(qyhAgentSecret);
                }
                JSONObject signAndOtherData = JSSDKUtil.getSignAndOtherData(url);
                return ActionResult.success((String)"\u83b7\u53d6\u6210\u529f", (Object)signAndOtherData);
            }
            return ActionResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u4e3b\u90e8\u95e8ID\u5173\u8054\u4f01\u4e1a\u5fae\u4fe1ID\u5931\u8d25");
        }
        return ActionResult.fail((String)"\u83b7\u53d6\u5931\u8d25,herfUrl\u4e0d\u80fd\u4e3a\u7a7a.");
    }
}

