/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.controller.mutil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.util.JSSDKUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cp/jssdk"})
public class JSSDKController {
    private static final Logger log = LoggerFactory.getLogger(JSSDKController.class);
    @Autowired
    WxCpConfiguration wxCpConfiguration;

    @GetMapping(value={"/getWxconfig"})
    public ActionResult list(String url, String corpId) {
        if (StringUtils.isEmpty((String)url)) {
            return ActionResult.fail((String)"\u53c2\u6570herfUrl\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (StringUtils.isEmpty((String)corpId)) {
            return ActionResult.fail((String)"\u53c2\u6570corpId\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        try {
            url = URLDecoder.decode(url, "utf-8");
            corpId = URLDecoder.decode(corpId, "utf-8");
            WeComModel weComModel = this.wxCpConfiguration.getWeComModel(corpId);
            if (ObjectUtil.isEmpty((Object)weComModel)) {
                return ActionResult.fail((String)String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", corpId));
            }
            JSSDKUtil.setCorpId(weComModel.getQyhCorpId());
            JSSDKUtil.setCorpSecret(weComModel.getQyhAgentSecret());
            JSONObject signAndOtherData = JSSDKUtil.getSignAndOtherData(url);
            return ActionResult.success((String)"\u83b7\u53d6\u6210\u529f", (Object)signAndOtherData);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ActionResult.fail((String)"base64\u53c2\u6570\u89e3\u7801\u5931\u8d25");
        }
    }
}

