/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.message.model.ImReplyListModel;
import com.bringspring.system.message.model.ImReplyListVo;
import com.bringspring.system.message.service.ImContentService;
import com.bringspring.system.message.service.ImReplyService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d88\u606f\u4f1a\u8bdd\u63a5\u53e3"}, value="imreply")
@RestController
@RequestMapping(value={"/api/message/imreply"})
public class ImReplyController {
    @Autowired
    private ImReplyService imReplyService;
    @Autowired
    private ImContentService imContentService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;

    @ApiOperation(value="\u83b7\u53d6\u6d88\u606f\u4f1a\u8bdd\u5217\u8868")
    @GetMapping
    public ActionResult getList() {
        List<ImReplyListModel> imReplyList = this.imReplyService.getImReplyList();
        for (ImReplyListModel vo : imReplyList) {
            vo.setHeadIcon(vo.getHeadIcon());
            vo.setUnreadMessage(this.imContentService.getUnreadCount(vo.getId(), this.userProvider.get().getUserId()));
            UserEntity entity = this.userService.getInfo(vo.getId());
            if (entity == null) continue;
            vo.setRealName(entity.getRealName());
            vo.setAccount(entity.getAccount());
        }
        imReplyList = imReplyList.stream().sorted(Comparator.comparing(ImReplyListModel::getLatestDate).reversed()).collect(Collectors.toList());
        List imReplyListVoList = JsonUtil.getJsonToList(imReplyList, ImReplyListVo.class);
        ListVO listVO = new ListVO();
        listVO.setList(imReplyListVoList);
        return ActionResult.success((Object)listVO);
    }
}

