/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.websocket;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.PageModel;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.model.OnlineUserModel;
import com.bringspring.common.model.OnlineUserProvider;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.entity.ImContentEntity;
import com.bringspring.system.message.entity.MessageEntity;
import com.bringspring.system.message.model.ImUnreadNumModel;
import com.bringspring.system.message.model.message.PaginationMessage;
import com.bringspring.system.message.service.ImContentService;
import com.bringspring.system.message.service.MessageService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/api/message/websocket")
@Scope(value="prototype")
public class WebSocket {
    private static final Logger log = LoggerFactory.getLogger(WebSocket.class);
    private UserProvider userProvider;
    private ImContentService imContentService;
    private MessageService messageService;
    private ConfigValueUtil configValueUtil;
    private UserInfo userInfo;
    private RedisUtil redisUtil;
    private CacheKeyUtil cacheKeyUtil;
    private UserService userService;
    private SysConfigService sysConfigService;

    @OnOpen
    public void onOpen(Session session) {
        log.info("\u8fde\u63a5\u4e0a\u6765:" + session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onClose(Session session) {
        Optional<OnlineUserModel> first = OnlineUserProvider.getOnlineUserList().stream().filter(t -> t.getConnectionId().equals(session.getId())).findFirst();
        OnlineUserModel user = null;
        if (first.isPresent()) {
            user = first.get();
        }
        if (user != null) {
            String userId = user.getUserId();
            OnlineUserProvider.getOnlineUserList().remove(user);
            for (OnlineUserModel item : OnlineUserProvider.getOnlineUserList().stream().filter(t -> !userId.equals(t.getUserId()) && this.userInfo.getTenantId().equals(t.getTenantId())).collect(Collectors.toList())) {
                if (item.getUserId().equals(this.userInfo.getUserId())) continue;
                JSONObject map = new JSONObject();
                map.put("method", (Object)"Offline");
                map.put("userId", (Object)this.userInfo.getUserId());
                Session session2 = session;
                synchronized (session2) {
                    try {
                        item.getWebSocket().getBasicRemote().sendText(map.toJSONString());
                    }
                    catch (Exception e) {
                        log.error("\u901a\u77e5\u7528\u6237\u79bb\u7ebf\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
                    }
                }
            }
            log.info("\u8c03\u7528onclose,\u5173\u95ed\u7684\u79df\u6237\u7528\u6237\u4e3a:" + user.getTenantId() + "." + userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("\u6d88\u606f\u5185\u5bb9:" + message);
        JSONObject receivedMessage = JSONObject.parseObject((String)message);
        String receivedMethod = receivedMessage.getString("method");
        String receivedToken = receivedMessage.getString("token");
        String appid = receivedMessage.getString("appid");
        this.init();
        switch (receivedMethod) {
            case "OnConnection": {
                Boolean isMobileDevice = receivedMessage.getBoolean("mobileDevice");
                String token = receivedMessage.getString("token");
                for (OnlineUserModel onlineUserModel : OnlineUserProvider.getOnlineUserList()) {
                    if (!token.equals(onlineUserModel.getToken()) || onlineUserModel.getWebSocket() == null) continue;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("method", (Object)"closeSocket");
                    onlineUserModel.getWebSocket().getAsyncRemote().sendText(jsonObject.toJSONString());
                }
                this.userInfo = this.userProvider.get(token);
                if (this.userInfo == null) {
                    return;
                }
                if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
                    if (!StringUtils.isNotEmpty((String)this.userInfo.getTenantDbConnectionString())) break;
                    DataSourceContextHolder.setDatasource((String)this.userInfo.getTenantId(), (String)this.userInfo.getTenantDbConnectionString());
                }
                if (this.userInfo == null || this.userInfo.getUserId() == null) break;
                OnlineUserModel model = new OnlineUserModel();
                model.setConnectionId(session.getId());
                model.setUserId(this.userInfo.getUserId());
                model.setTenantId(this.userInfo.getTenantId());
                model.setIsMobileDevice(isMobileDevice);
                model.setWebSocket(session);
                model.setToken(token);
                BaseSystemInfo sysInfo = this.sysConfigService.getSysInfo();
                if ("1".equals(String.valueOf(sysInfo.getSingleLogin()))) {
                    Long userAll = OnlineUserProvider.getOnlineUserList().stream().filter(t -> t.getUserId().equals(this.userInfo.getUserId()) && t.getTenantId().equals(this.userInfo.getTenantId())).count();
                    Long userAllMobile = OnlineUserProvider.getOnlineUserList().stream().filter(t -> t.getUserId().equals(this.userInfo.getUserId()) && t.getTenantId().equals(this.userInfo.getTenantId()) && t.getIsMobileDevice().equals(true)).count();
                    Long userAllWeb = OnlineUserProvider.getOnlineUserList().stream().filter(t -> t.getUserId().equals(this.userInfo.getUserId()) && t.getTenantId().equals(this.userInfo.getTenantId()) && t.getIsMobileDevice().equals(false)).count();
                    if (userAll == 0L) {
                        OnlineUserProvider.addModel((OnlineUserModel)model);
                    } else if (userAllMobile != 0L && userAllWeb == 0L) {
                        if (!model.getIsMobileDevice().booleanValue()) {
                            OnlineUserProvider.addModel((OnlineUserModel)model);
                        }
                    } else if (model.getIsMobileDevice().booleanValue()) {
                        OnlineUserProvider.addModel((OnlineUserModel)model);
                    }
                } else {
                    OnlineUserProvider.addModel((OnlineUserModel)model);
                }
                List onlineUserList = OnlineUserProvider.getOnlineUserList().stream().filter(q -> !q.getUserId().equals(this.userInfo.getUserId()) && q.getTenantId().equals(this.userInfo.getTenantId())).collect(Collectors.toList());
                List onlineUsers = onlineUserList.stream().map(t -> t.getUserId()).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
                List<ImUnreadNumModel> unreadNums = this.imContentService.getUnreadList(this.userInfo.getUserId());
                int unreadNoticeCount = this.messageService.getUnreadNoticeCount(this.userInfo.getUserId());
                int unreadMessageCount = this.messageService.getUnreadMessageCount(this.userInfo.getUserId());
                MessageEntity noticeDefaultText = this.messageService.getInfoDefault(1);
                PaginationMessage pagination = new PaginationMessage();
                pagination.setCurrentPage(1L);
                pagination.setPageSize(1L);
                pagination.setType("2");
                List<MessageEntity> list = this.messageService.getMessageList(pagination, pagination.getType(), this.userInfo.getUserId(), appid, "0");
                MessageEntity messageDefaultText = new MessageEntity();
                if (list.size() > 0) {
                    messageDefaultText = list.get(0);
                }
                String noticeText = noticeDefaultText.getTitle() != null ? noticeDefaultText.getTitle() : "";
                String messageText = messageDefaultText.getTitle() != null ? messageDefaultText.getTitle() : "";
                Long noticeTime = noticeDefaultText.getCreatorTime() != null ? noticeDefaultText.getCreatorTime().getTime() : 0L;
                Long messageTime = messageDefaultText.getCreatorTime() != null ? messageDefaultText.getCreatorTime().getTime() : 0L;
                JSONObject object = new JSONObject();
                object.put("method", (Object)"initMessage");
                object.put("onlineUsers", onlineUsers);
                object.put("unreadNums", (Object)JsonUtil.listToJsonField(unreadNums));
                object.put("unreadNoticeCount", (Object)unreadNoticeCount);
                object.put("noticeDefaultText", (Object)noticeText);
                object.put("noticeDefaultTime", (Object)noticeTime);
                object.put("unreadMessageCount", (Object)unreadMessageCount);
                object.put("messageDefaultText", (Object)messageText);
                object.put("messageDefaultTime", (Object)messageTime);
                session.getAsyncRemote().sendText(object.toJSONString());
                for (OnlineUserModel item : onlineUserList) {
                    if (item.getUserId().equals(this.userInfo.getUserId())) continue;
                    JSONObject map = new JSONObject();
                    map.put("method", (Object)"Online");
                    map.put("userId", (Object)this.userInfo.getUserId());
                    item.getWebSocket().getAsyncRemote().sendText(map.toJSONString());
                }
                break;
            }
            case "SendMessage": {
                Session voice;
                UserEntity entity;
                List user;
                String toUserId = receivedMessage.getString("toUserId");
                String messageType = receivedMessage.getString("messageType");
                String messageContent = receivedMessage.getString("messageContent");
                String tenantId = this.userProvider.get(receivedMessage.getString("token")).getTenantId();
                if (this.userInfo == null) {
                    return;
                }
                if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
                    DataSourceContextHolder.setDatasource((String)this.userInfo.getTenantId(), (String)this.userInfo.getTenantDbConnectionString());
                }
                String fileName = "";
                if (!"text".equals(messageType)) {
                    JSONObject object = JSONObject.parseObject((String)messageContent);
                    fileName = object.getString("name");
                }
                OnlineUserModel onlineUser = (user = OnlineUserProvider.getOnlineUserList().stream().filter(q -> String.valueOf(q.getUserId()).equals(String.valueOf(this.userInfo.getUserId())) && String.valueOf(q.getTenantId()).equals(tenantId)).collect(Collectors.toList())).size() > 0 ? (OnlineUserModel)user.get(0) : null;
                List toUser = OnlineUserProvider.getOnlineUserList().stream().filter(q -> String.valueOf(q.getTenantId()).equals(String.valueOf(onlineUser.getTenantId())) && String.valueOf(q.getUserId()).equals(String.valueOf(toUserId))).collect(Collectors.toList());
                if (user.size() != 0) {
                    if ("text".equals(messageType)) {
                        if (onlineUser != null) {
                            this.imContentService.sendMessage(onlineUser.getUserId(), toUserId, messageContent, messageType);
                        }
                    } else if ("image".equals(messageType)) {
                        JSONObject image = new JSONObject();
                        image.put("path", (Object)UploaderUtil.uploaderImg((String)"/api/file/Image/IM/", (String)fileName));
                        image.put("width", (Object)JSONObject.parseObject((String)messageContent).getString("width"));
                        image.put("height", (Object)JSONObject.parseObject((String)messageContent).getString("height"));
                        if (onlineUser != null) {
                            this.imContentService.sendMessage(onlineUser.getUserId(), toUserId, image.toJSONString(), messageType);
                        }
                    } else if ("voice".equals(messageType)) {
                        JSONObject voice2 = new JSONObject();
                        voice2.put("path", (Object)UploaderUtil.uploaderImg((String)"/api/file/Image/IM/", (String)fileName));
                        voice2.put("length", (Object)JSONObject.parseObject((String)messageContent).getString("length"));
                        if (onlineUser != null) {
                            this.imContentService.sendMessage(onlineUser.getUserId(), toUserId, voice2.toJSONString(), messageType);
                        }
                    }
                    for (int i = 0; i < user.size(); ++i) {
                        OnlineUserModel model = (OnlineUserModel)user.get(i);
                        JSONObject object = new JSONObject();
                        object.put("method", (Object)"sendMessage");
                        object.put("UserId", (Object)model.getUserId());
                        object.put("toUserId", (Object)toUserId);
                        object.put("dateTime", (Object)DateUtil.getNowDate().getTime());
                        object.put("headIcon", (Object)this.userInfo.getUserIcon());
                        object.put("latestDate", (Object)DateUtil.getNowDate().getTime());
                        object.put("realName", (Object)this.userInfo.getRealName());
                        object.put("account", (Object)this.userInfo.getUserAccount());
                        entity = this.userService.getInfo(toUserId);
                        object.put("toAccount", (Object)entity.getAccount());
                        object.put("toRealName", (Object)entity.getRealName());
                        object.put("toHeadIcon", (Object)entity.getHeadIcon());
                        if ("text".equals(messageType)) {
                            object.put("messageType", (Object)messageType);
                            object.put("toMessage", (Object)messageContent);
                            model.getWebSocket().getAsyncRemote().sendText(object.toJSONString());
                            continue;
                        }
                        if ("image".equals(messageType)) {
                            JSONObject image = new JSONObject();
                            image.put("path", (Object)UploaderUtil.uploaderImg((String)"/api/file/Image/IM/", (String)fileName));
                            image.put("width", (Object)JSONObject.parseObject((String)messageContent).getString("width"));
                            image.put("height", (Object)JSONObject.parseObject((String)messageContent).getString("height"));
                            object.put("messageType", (Object)messageType);
                            object.put("toMessage", (Object)image);
                            model.getWebSocket().getAsyncRemote().sendText(object.toJSONString());
                            continue;
                        }
                        if (!"voice".equals(messageType)) continue;
                        voice = new JSONObject();
                        voice.put("path", (Object)UploaderUtil.uploaderImg((String)"/api/file/Image/IM/", (String)fileName));
                        voice.put("length", (Object)JSONObject.parseObject((String)messageContent).getString("length"));
                        object.put("messageType", (Object)messageType);
                        object.put("toMessage", (Object)voice);
                        model.getWebSocket().getAsyncRemote().sendText(object.toJSONString());
                    }
                }
                JSONObject receive = new JSONObject();
                receive.put("method", (Object)"receiveMessage");
                if (onlineUser != null) {
                    receive.put("formUserId", (Object)onlineUser.getUserId());
                }
                if (toUser.size() == 0) break;
                for (int i = 0; i < toUser.size(); ++i) {
                    OnlineUserModel onlineToUser = (OnlineUserModel)toUser.get(i);
                    if ("text".equals(messageType)) {
                        receive.put("messageType", (Object)messageType);
                        receive.put("formMessage", (Object)messageContent);
                        receive.put("dateTime", (Object)DateUtil.getNowDate().getTime());
                        receive.put("headIcon", (Object)this.userInfo.getUserIcon());
                        receive.put("latestDate", (Object)DateUtil.getNowDate().getTime());
                        receive.put("realName", (Object)this.userInfo.getRealName());
                        receive.put("account", (Object)this.userInfo.getUserAccount());
                        entity = session;
                        synchronized (entity) {
                            onlineToUser.getWebSocket().getAsyncRemote().sendText(receive.toJSONString());
                            continue;
                        }
                    }
                    if ("image".equals(messageType)) {
                        JSONObject image = new JSONObject();
                        image.put("path", (Object)UploaderUtil.uploaderImg((String)"/api/file/Image/IM/", (String)fileName));
                        image.put("width", (Object)JSONObject.parseObject((String)messageContent).getString("width"));
                        image.put("height", (Object)JSONObject.parseObject((String)messageContent).getString("height"));
                        receive.put("messageType", (Object)messageType);
                        receive.put("formMessage", (Object)image);
                        receive.put("dateTime", (Object)DateUtil.getNowDate().getTime());
                        receive.put("headIcon", (Object)this.userInfo.getUserIcon());
                        receive.put("latestDate", (Object)DateUtil.getNowDate().getTime());
                        receive.put("realName", (Object)this.userInfo.getRealName());
                        receive.put("account", (Object)this.userInfo.getUserAccount());
                        voice = session;
                        synchronized (voice) {
                            onlineToUser.getWebSocket().getAsyncRemote().sendText(receive.toJSONString());
                            continue;
                        }
                    }
                    if (!"voice".equals(messageType)) continue;
                    JSONObject voice3 = new JSONObject();
                    voice3.put("path", (Object)UploaderUtil.uploaderImg((String)"/api/file/Image/IM/", (String)fileName));
                    voice3.put("length", (Object)JSONObject.parseObject((String)messageContent).getString("length"));
                    receive.put("messageType", (Object)messageType);
                    receive.put("formMessage", (Object)voice3);
                    receive.put("dateTime", (Object)DateUtil.getNowDate().getTime());
                    receive.put("headIcon", (Object)this.userInfo.getUserIcon());
                    receive.put("latestDate", (Object)DateUtil.getNowDate().getTime());
                    receive.put("realName", (Object)this.userInfo.getRealName());
                    receive.put("account", (Object)this.userInfo.getUserAccount());
                    voice = session;
                    synchronized (voice) {
                        onlineToUser.getWebSocket().getAsyncRemote().sendText(receive.toJSONString());
                        continue;
                    }
                }
                break;
            }
            case "UpdateReadMessage": {
                OnlineUserModel onlineUser;
                String formUserId = receivedMessage.getString("formUserId");
                String tenantId = this.userProvider.get(receivedMessage.getString("token")).getTenantId();
                if (this.userInfo == null) {
                    return;
                }
                if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
                    if (StringUtils.isEmpty((String)this.userInfo.getTenantId()) || StringUtils.isEmpty((String)this.userInfo.getTenantDbConnectionString())) {
                        return;
                    }
                    DataSourceContextHolder.setDatasource((String)this.userInfo.getTenantId(), (String)this.userInfo.getTenantDbConnectionString());
                }
                if ((onlineUser = OnlineUserProvider.getOnlineUserList().stream().filter(q -> String.valueOf(q.getConnectionId()).equals(String.valueOf(session.getId()))).findFirst().orElse(new OnlineUserModel())) == null) break;
                this.imContentService.readMessage(formUserId, onlineUser.getUserId());
                break;
            }
            case "MessageList": {
                String sendUserId = receivedMessage.getString("toUserId");
                String receiveUserId = receivedMessage.getString("formUserId");
                String tenantId = this.userProvider.get(receivedMessage.getString("token")).getTenantId();
                if (this.userInfo == null) {
                    return;
                }
                if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
                    DataSourceContextHolder.setDatasource((String)this.userInfo.getTenantId(), (String)this.userInfo.getTenantDbConnectionString());
                }
                PageModel pageModel = new PageModel();
                pageModel.setPage(receivedMessage.getInteger("currentPage").intValue());
                pageModel.setRows(receivedMessage.getInteger("pageSize").intValue());
                pageModel.setSord(receivedMessage.getString("sord"));
                pageModel.setKeyword(receivedMessage.getString("keyword"));
                List data = this.imContentService.getMessageList(sendUserId, receiveUserId, pageModel).stream().sorted(Comparator.comparing(ImContentEntity::getSendTime)).collect(Collectors.toList());
                JSONObject object = new JSONObject();
                object.put("method", (Object)"messageList");
                object.put("list", (Object)JsonUtil.getListToJsonArray(data));
                JSONObject pagination = new JSONObject();
                pagination.put("total", (Object)pageModel.getRecords());
                pagination.put("currentPage", (Object)pageModel.getPage());
                pagination.put("pageSize", (Object)receivedMessage.getInteger("pageSize"));
                object.put("pagination", (Object)pagination);
                session.getAsyncRemote().sendText(object.toJSONString());
                break;
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        Optional<OnlineUserModel> first = OnlineUserProvider.getOnlineUserList().stream().filter(t -> t.getConnectionId().equals(session.getId())).findFirst();
        OnlineUserModel user = null;
        if (first.isPresent()) {
            user = first.get();
        }
        if (user != null) {
            log.error("\u8c03\u7528onError,\u79df\u6237\uff1a" + user.getTenantId() + ",\u7528\u6237\uff1a" + user.getUserId());
        }
        try {
            this.onClose(session);
        }
        catch (Exception e) {
            log.error("\u53d1\u751ferror,\u8c03\u7528onclose\u5931\u8d25\uff0csession\u4e3a\uff1a" + session);
        }
        if (error.getMessage() != null) {
            error.printStackTrace();
        }
    }

    private void init() {
        this.messageService = (MessageService)SpringContext.getBean(MessageService.class);
        this.imContentService = (ImContentService)SpringContext.getBean(ImContentService.class);
        this.configValueUtil = (ConfigValueUtil)SpringContext.getBean(ConfigValueUtil.class);
        this.userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        this.redisUtil = (RedisUtil)SpringContext.getBean(RedisUtil.class);
        this.cacheKeyUtil = (CacheKeyUtil)SpringContext.getBean(CacheKeyUtil.class);
        this.userService = (UserService)SpringContext.getBean(UserService.class);
        this.sysConfigService = (SysConfigService)SpringContext.getBean(SysConfigService.class);
    }

    private static void makeThumbnail(String imgPathOld, String imgPathNew, int width, int height) {
        try {
            if (FileUtil.fileIsFile((String)imgPathOld)) {
                Thumbnails.of((String[])new String[]{imgPathOld}).size(width, height).toFile(imgPathNew);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

