/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.constant.CommonConsts;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessInfoVO;
import com.bringspring.system.msgcenter.service.McBusinessService;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.MessageChannelStrategy;
import com.bringspring.system.msgcenter.util.SensitiveWordUtil;
import com.bringspring.system.msgcenter.util.UrlUtils;
import com.bringspring.system.permission.entity.UserEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMessageChannelStrategy
implements MessageChannelStrategy {
    @Autowired
    protected McBusinessService mcBusinessService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    protected McMsgAccountService mcMsgAccountService;
    @Autowired
    protected SynThirdInfoService synThirdInfoService;

    public abstract ChannelTypeEnum getChannelType();

    protected McTaskMsgContentEntity getTaskMsgContent(String templateId, String channelType, McTaskMsgEntity taskMsg, McMsgTemplateEntity msgTemplate, McMsgAccountEntity account) {
        String taskMsgId = taskMsg.getId();
        McBusinessInfoVO businessInfoVO = this.mcBusinessService.getInfoByEnCode(msgTemplate.getMessageSource());
        String businessKey = taskMsg.getBusinessKey();
        Map businessKeyMap = JsonUtil.stringToMap((String)businessKey);
        String title = msgTemplate.getTitle();
        String content = msgTemplate.getContent();
        String description = null;
        String linkUrl = null;
        String picUrl = null;
        if (StringUtils.isNotEmpty((Map)businessKeyMap)) {
            StringSubstitutor strSubstitutor;
            if (StringUtils.isNotEmpty((String)title)) {
                strSubstitutor = new StringSubstitutor(businessKeyMap, "{", "}");
                title = strSubstitutor.replace(title);
            } else {
                title = String.valueOf(businessKeyMap.get("title"));
            }
            if (StringUtils.isNotEmpty((String)content)) {
                strSubstitutor = new StringSubstitutor(businessKeyMap, "{", "}");
                content = strSubstitutor.replace(content);
            } else {
                content = String.valueOf(businessKeyMap.get("content"));
            }
            description = businessKeyMap.containsKey("desc") && StringUtils.isNotEmpty((String)businessKeyMap.get("desc").toString()) ? businessKeyMap.get("desc").toString() : (StringUtils.isEmpty((String)content) ? null : StringUtils.substring((String)content, (int)0, (int)200));
            linkUrl = this.packLinkUrl(channelType, businessKeyMap, account, taskMsgId);
            if (businessKeyMap.containsKey("picUrl") && ObjectUtil.isNotEmpty(businessKeyMap.get("picUrl"))) {
                picUrl = String.valueOf(businessKeyMap.get("picUrl"));
            }
        }
        McTaskMsgContentEntity taskMsgContentEntity = new McTaskMsgContentEntity();
        if (StringUtils.isNotEmpty((String)title)) {
            title = SensitiveWordUtil.sensitiveFilter(title, true);
            title = StringUtils.substring((String)title, (int)0, (int)50);
            taskMsgContentEntity.setTitle(title);
        }
        if (StringUtils.isNotEmpty((String)content)) {
            content = SensitiveWordUtil.sensitiveFilter(content, true);
            taskMsgContentEntity.setContent(content);
        }
        if (StringUtils.isNotEmpty(description)) {
            description = SensitiveWordUtil.sensitiveFilter(description, true);
            taskMsgContentEntity.setDescription(description);
        }
        taskMsgContentEntity.setLinkUrl(linkUrl);
        if (StringUtils.isNotEmpty(picUrl)) {
            taskMsgContentEntity.setPicUrl(picUrl);
        }
        taskMsgContentEntity.setId(RandomUtil.uuId());
        taskMsgContentEntity.setMsgId(taskMsgId);
        taskMsgContentEntity.setChannelType(channelType);
        taskMsgContentEntity.setTemplateId(templateId);
        taskMsgContentEntity.setMsgTemplateId(msgTemplate.getId());
        taskMsgContentEntity.setMsgAccountId(ObjectUtil.isEmpty((Object)account) ? null : account.getId());
        taskMsgContentEntity.setContentType(businessInfoVO.getCategory());
        return taskMsgContentEntity;
    }

    protected McTaskMsgContentEntity getTaskMsgContentKey(String templateId, String channelType, McTaskMsgEntity taskMsg, McMsgTemplateEntity msgTemplate, McMsgAccountEntity account) {
        String taskMsgId = taskMsg.getId();
        McBusinessInfoVO businessInfoVO = this.mcBusinessService.getInfoByEnCode(msgTemplate.getMessageSource());
        String businessKey = taskMsg.getBusinessKey();
        Map businessKeyMap = JsonUtil.stringToMap((String)businessKey);
        McTaskMsgContentEntity taskMsgContentEntity = new McTaskMsgContentEntity();
        List<McMsgTemplateFieldEntity> fieldList = this.mcMsgTemplateService.getMcMsgTemplateFieldList(msgTemplate.getId());
        if (CollectionUtil.isNotEmpty(fieldList) && StringUtils.isNotEmpty((Map)businessKeyMap)) {
            HashMap fieldMap = new HashMap();
            for (McMsgTemplateFieldEntity field : fieldList) {
                fieldMap.put(field.getThirdField(), businessKeyMap.get(field.getKeywordCode()));
                if (Integer.valueOf(field.getIsTitle()) != 1) continue;
                taskMsgContentEntity.setTitle(businessKeyMap.get(field.getKeywordCode()).toString());
            }
            String content = JSONObject.toJSONString(fieldMap);
            if (StringUtils.isNotEmpty((String)content)) {
                content = SensitiveWordUtil.sensitiveFilter(content, true);
                taskMsgContentEntity.setContent(content);
            }
            taskMsgContentEntity.setLinkUrl(this.packLinkUrl(channelType, businessKeyMap, account, taskMsgId));
            if (businessKeyMap.containsKey("picUrl") && ObjectUtil.isNotEmpty(businessKeyMap.get("picUrl"))) {
                taskMsgContentEntity.setLinkUrl(String.valueOf(businessKeyMap.get("picUrl")));
            }
        }
        taskMsgContentEntity.setId(RandomUtil.uuId());
        taskMsgContentEntity.setMsgId(taskMsgId);
        taskMsgContentEntity.setChannelType(channelType);
        taskMsgContentEntity.setTemplateId(templateId);
        taskMsgContentEntity.setMsgTemplateId(msgTemplate.getId());
        taskMsgContentEntity.setMsgAccountId(ObjectUtil.isEmpty((Object)account) ? null : account.getId());
        taskMsgContentEntity.setContentType(businessInfoVO.getCategory());
        return taskMsgContentEntity;
    }

    protected List<McTaskMsgReceiveEntity> packThirdReceive(List<UserEntity> sysList, List<SynThirdInfoEntity> thirdList, String taskMsgId, String templateId, String channelType, String msgTemplateId, String msgAccountId, String contentId, List<McTaskMsgReceiveEntity> receiveList) {
        if (CollectionUtil.isEmpty(receiveList)) {
            ArrayList<McTaskMsgReceiveEntity> receiveEntities = new ArrayList<McTaskMsgReceiveEntity>();
            for (UserEntity user : sysList) {
                McTaskMsgReceiveEntity thirdReceive = new McTaskMsgReceiveEntity();
                thirdReceive.setMsgId(taskMsgId);
                thirdReceive.setTemplateId(templateId);
                thirdReceive.setMsgTemplateId(msgTemplateId);
                thirdReceive.setMsgAccountId(msgAccountId);
                thirdReceive.setContentId(contentId);
                thirdReceive.setChannelType(channelType);
                thirdReceive.setSysUserId(user.getId());
                thirdReceive.setIsRead(CommonConsts.NOT_READ);
                List tempList = thirdList.stream().filter(s -> user.getId().equals(s.getSystemObjectId())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(tempList)) {
                    tempList.stream().forEach(s -> {
                        McTaskMsgReceiveEntity thirdReceiveNew = new McTaskMsgReceiveEntity();
                        BeanUtils.copyProperties((Object)thirdReceive, (Object)thirdReceiveNew);
                        thirdReceiveNew.setReceiveUserId(s.getId());
                        thirdReceiveNew.setEnabledMark(0);
                        thirdReceiveNew.setDescription("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019");
                        thirdReceiveNew.setId(RandomUtil.uuId());
                        receiveEntities.add(thirdReceiveNew);
                    });
                    continue;
                }
                thirdReceive.setEnabledMark(0);
                thirdReceive.setDescription("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019");
                thirdReceive.setId(RandomUtil.uuId());
                receiveEntities.add(thirdReceive);
            }
            return receiveEntities;
        }
        for (SynThirdInfoEntity thirdInfo : thirdList) {
            List rTempList = receiveList.stream().filter(r -> thirdInfo.getSystemObjectId().equals(r.getSysUserId())).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(rTempList)) continue;
            McTaskMsgReceiveEntity mcTaskMsgReceiveEntity = (McTaskMsgReceiveEntity)rTempList.get(0);
            if (StringUtils.isEmpty((String)mcTaskMsgReceiveEntity.getReceiveUserId())) {
                mcTaskMsgReceiveEntity.setReceiveUserId(thirdInfo.getId());
                mcTaskMsgReceiveEntity.setTemplateId(templateId);
                mcTaskMsgReceiveEntity.setMsgTemplateId(msgTemplateId);
                mcTaskMsgReceiveEntity.setMsgAccountId(msgAccountId);
                mcTaskMsgReceiveEntity.setContentId(contentId);
                continue;
            }
            McTaskMsgReceiveEntity thirdReceiveNew = new McTaskMsgReceiveEntity();
            BeanUtils.copyProperties((Object)mcTaskMsgReceiveEntity, (Object)thirdReceiveNew);
            thirdReceiveNew.setId(RandomUtil.uuId());
            thirdReceiveNew.setReceiveUserId(thirdInfo.getId());
            thirdReceiveNew.setTemplateId(templateId);
            thirdReceiveNew.setMsgTemplateId(msgTemplateId);
            thirdReceiveNew.setMsgAccountId(msgAccountId);
            thirdReceiveNew.setContentId(contentId);
            receiveList.add(thirdReceiveNew);
        }
        return receiveList;
    }

    protected List<McTaskMsgReceiveEntity> packNonSystemReceive(Set<String> userSet, String taskMsgId, String templateId, String channelType, String msgTemplateId, String msgAccountId, String contentId) {
        ArrayList<McTaskMsgReceiveEntity> receiveEntities = new ArrayList<McTaskMsgReceiveEntity>();
        for (String openid : userSet) {
            McTaskMsgReceiveEntity thirdReceive = new McTaskMsgReceiveEntity();
            thirdReceive.setId(RandomUtil.uuId());
            thirdReceive.setMsgId(taskMsgId);
            thirdReceive.setTemplateId(templateId);
            thirdReceive.setMsgTemplateId(msgTemplateId);
            thirdReceive.setMsgAccountId(msgAccountId);
            thirdReceive.setContentId(contentId);
            thirdReceive.setChannelType(channelType);
            thirdReceive.setSysUserId(null);
            thirdReceive.setReceiveUserId(openid);
            thirdReceive.setEnabledMark(0);
            thirdReceive.setIsRead(CommonConsts.NOT_READ);
            thirdReceive.setDescription("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019");
            receiveEntities.add(thirdReceive);
        }
        return receiveEntities;
    }

    protected String packLinkUrl(String channelType, Map<String, Object> businessKeyMap, McMsgAccountEntity account, String taskMsgId) {
        ChannelTypeEnum typeEnum = ChannelTypeEnum.getByCode(channelType);
        Object linkUrl = null;
        switch (typeEnum) {
            case SYS_MSG: {
                if (businessKeyMap.containsKey("linkUrl")) {
                    linkUrl = businessKeyMap.get("linkUrl");
                }
            }
            case MAIL_MSG: {
                if (businessKeyMap.containsKey("linkUrl2")) {
                    linkUrl = businessKeyMap.get("linkUrl2");
                }
            }
            case SMS_MSG: {
                if (!businessKeyMap.containsKey("linkUrl3")) break;
                linkUrl = businessKeyMap.get("linkUrl3");
                break;
            }
            case DING_MSG: {
                if (!businessKeyMap.containsKey("linkUrl4")) break;
                linkUrl = businessKeyMap.get("linkUrl4");
                break;
            }
            case QY_MSG: {
                if (!businessKeyMap.containsKey("linkUrl5")) break;
                linkUrl = businessKeyMap.get("linkUrl5");
                break;
            }
            case WX_MINIAPP: {
                if (!businessKeyMap.containsKey("linkUrl6")) break;
                linkUrl = businessKeyMap.get("linkUrl6");
                break;
            }
            case WX_MP: {
                if (!businessKeyMap.containsKey("linkUrl7")) break;
                linkUrl = businessKeyMap.get("linkUrl7");
                break;
            }
            case WEBHOOK: {
                if (!businessKeyMap.containsKey("linkUrl8")) break;
                linkUrl = businessKeyMap.get("linkUrl8");
                break;
            }
        }
        if (ObjectUtil.isEmpty(linkUrl) && ObjectUtil.isNotEmpty((Object)account)) {
            linkUrl = account.getAddress();
        }
        if (ObjectUtil.isNotEmpty(linkUrl)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("msg_id", taskMsgId);
            return UrlUtils.addParameter(String.valueOf(linkUrl), map);
        }
        return null;
    }
}

