/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.factory;

import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageChannelStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(MessageChannelStrategyFactory.class);
    private Map<String, AbstractMessageChannelStrategy> strategies;

    @Autowired
    public MessageChannelStrategyFactory(List<AbstractMessageChannelStrategy> strategyList) {
        this.strategies = strategyList.stream().collect(Collectors.toMap(s -> s.getChannelType().getCode(), Function.identity(), (existing, replacement) -> {
            log.warn("\u91cd\u590d\u7684\u6e20\u9053\u7c7b\u578b: {}", (Object)existing.getChannelType());
            return existing;
        }));
    }

    public AbstractMessageChannelStrategy getStrategy(String channelType) {
        return this.strategies.get(channelType);
    }
}

