/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.OnlineUserModel;
import com.bringspring.common.model.OnlineUserProvider;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageSender;
import com.bringspring.system.msgcenter.util.BlacklistUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MsgToSystemService
extends AbstractMessageSender {
    private static final Logger log = LoggerFactory.getLogger(MsgToSystemService.class);
    private final McTaskMsgReceiveService mcTaskMsgReceiveService;

    public MsgToSystemService(McTaskMsgReceiveService mcTaskMsgReceiveService) {
        this.mcTaskMsgReceiveService = mcTaskMsgReceiveService;
    }

    @Override
    protected int getBatchSize() {
        return 1000;
    }

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.SYS_MSG;
    }

    @Override
    protected void sendBatchNonSystemUser(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u7ad9\u5185\u4fe1\u6d88\u606f\u3010\u975e\u7cfb\u7edf\u7528\u6237\u3011\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        this.sendBatch(isAgain, sendTemplate, taskMsgContent, receiveListS, currentUserInfo);
    }

    @Override
    protected void sendBatch(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        List<McTaskMsgReceiveEntity> filtered;
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u7ad9\u5185\u4fe1\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        if (!(filtered = BlacklistUtil.receiveListFilter(receiveListS)).isEmpty()) {
            this.mcTaskMsgReceiveService.updateBlacklist(filtered, currentUserInfo);
        }
        receiveListS.forEach(entity -> {
            entity.setEnabledMark(1);
            entity.setSendTime(new Date());
            entity.setSendUserId(currentUserInfo.getUserId());
        });
        this.mcTaskMsgReceiveService.updateBatchById(receiveListS);
        this.sendWebSocketNotification(receiveListS, taskMsgContent, currentUserInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWebSocketNotification(List<McTaskMsgReceiveEntity> receiveListS, McTaskMsgContentEntity taskMsgContent, UserInfo currentUserInfo) {
        List toUserIds = receiveListS.stream().map(i -> i.getSysUserId()).collect(Collectors.toList());
        for (int i2 = 0; i2 < toUserIds.size(); ++i2) {
            CopyOnWriteArraySet onlineUserList = OnlineUserProvider.getOnlineUserList();
            for (OnlineUserModel item : onlineUserList) {
                if (!((String)toUserIds.get(i2)).equals(item.getUserId()) || !currentUserInfo.getTenantId().equals(item.getTenantId())) continue;
                JSONObject map = new JSONObject();
                map.put("method", (Object)"messagePush");
                map.put("unreadNoticeCount", (Object)1);
                map.put("messageType", (Object)2);
                map.put("userId", (Object)currentUserInfo.getTenantId());
                map.put("toUserId", toUserIds);
                map.put("title", (Object)taskMsgContent.getTitle());
                JSONObject jSONObject = map;
                synchronized (jSONObject) {
                    item.getWebSocket().getAsyncRemote().sendText(map.toJSONString());
                }
            }
        }
    }
}

