/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.aop;

import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.aop.PermissionAdminBase;
import com.bringspring.system.permission.model.position.PositionCrForm;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.util.PermissionAspectUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionPositionAspect
implements PermissionAdminBase {
    private static final Logger log = LoggerFactory.getLogger(PermissionPositionAspect.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;

    @Pointcut(value="@annotation(com.bringspring.common.annotation.PositionPermission)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return PermissionAdminBase.permissionCommon(pjp, this.userProvider, this);
    }

    @Override
    public Boolean detailPermission(ProceedingJoinPoint pjp, String operatorUserId, String methodName) {
        switch (methodName) {
            case "create": 
            case "update": {
                return PermissionAspectUtil.getPermitByOrgIds(((PositionCrForm)pjp.getArgs()[0]).getOrganizeId(), operatorUserId, methodName);
            }
            case "delete": {
                String positionId = String.valueOf(pjp.getArgs()[0]);
                String orgIds = this.organizeService.getInfo(this.positionService.getInfo(positionId).getOrganizeId()).getId();
                return PermissionAspectUtil.getPermitByOrgIds(orgIds, operatorUserId, "delete");
            }
        }
        return false;
    }
}

