/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.aop;

import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.aop.PermissionAdminBase;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.model.role.RoleCrForm;
import com.bringspring.system.permission.model.role.RoleUpForm;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.util.PermissionAspectUtil;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionRoleAspect
implements PermissionAdminBase {
    private static final Logger log = LoggerFactory.getLogger(PermissionRoleAspect.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizeRelationService organizeRelationService;

    @Pointcut(value="@annotation(com.bringspring.common.annotation.RolePermission)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return PermissionAdminBase.permissionCommon(pjp, this.userProvider, this);
    }

    @Override
    public Boolean detailPermission(ProceedingJoinPoint pjp, String operatorUserId, String methodName) {
        boolean flag = false;
        switch (methodName) {
            case "create": {
                RoleCrForm roleCrForm = (RoleCrForm)pjp.getArgs()[0];
                if (!this.checkAdminGlobal(roleCrForm.getGlobalMark(), this.userProvider).booleanValue()) {
                    return PermissionAspectUtil.getPermitByOrgIds(this.getOrganize(roleCrForm.getOrganizeIdsTree()), operatorUserId, "create");
                }
                return true;
            }
            case "update": {
                RoleUpForm roleUpForm = (RoleUpForm)pjp.getArgs()[0];
                if (!this.checkAdminGlobal(roleUpForm.getGlobalMark(), this.userProvider).booleanValue()) {
                    return PermissionAspectUtil.getPermitByOrgIds(this.getOrganize(roleUpForm.getOrganizeIdsTree()), operatorUserId, "update");
                }
                return true;
            }
            case "delete": {
                String roleId = pjp.getArgs()[0].toString();
                RoleEntity roleEntity = this.roleService.getInfo(roleId);
                List<OrganizeRelationEntity> relationListByRoleId = this.organizeRelationService.getRelationListByRoleId(roleId);
                StringBuilder orgId = new StringBuilder();
                relationListByRoleId.stream().forEach(t -> orgId.append(t.getOrganizeId() + ","));
                if (roleEntity != null && !this.checkAdminGlobal(roleEntity.getGlobalMark(), this.userProvider).booleanValue()) {
                    return PermissionAspectUtil.getPermitByOrgIds(orgId.toString(), operatorUserId, "delete");
                }
                return true;
            }
        }
        return true;
    }

    private String getOrganize(List<List<String>> orgIdsTree) {
        StringBuilder orgIds = new StringBuilder();
        for (List<String> list : orgIdsTree) {
            if (list.size() <= 0) continue;
            String orgId = list.get(list.size() - 1);
            orgIds.append(orgId + ",");
        }
        return orgIds.toString();
    }

    private Boolean checkAdminGlobal(Integer globalMark, UserProvider userProvider) {
        if (globalMark != null && globalMark == 1) {
            return userProvider.get().getIsAdministrator();
        }
        return false;
    }
}

