/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.OrganizeAdministratorEntity;
import com.bringspring.system.permission.model.organizeadministrator.OrganizeAdminIsTratorCrForm;
import com.bringspring.system.permission.model.organizeadministrator.OrganizeAdminIsTratorInfoVo;
import com.bringspring.system.permission.service.OrganizeAdministratorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u673a\u6784\u5206\u7ea7\u7ba1\u7406\u5458"}, value="organizeAdminIsTrator")
@RestController
@RequestMapping(value={"/api/permission/organizeAdminIsTrator"})
public class OrganizeAdministratorController {
    private static final Logger log = LoggerFactory.getLogger(OrganizeAdministratorController.class);
    @Autowired
    private OrganizeAdministratorService organizeAdminIsTratorService;

    @ApiOperation(value="\u62c9\u53d6\u673a\u6784\u5206\u7ea7\u7ba1\u7406")
    @GetMapping(value={"/{organizeId}"})
    public ActionResult info(@PathVariable(value="organizeId") String organizeId) throws DataException {
        OrganizeAdministratorEntity entity = this.organizeAdminIsTratorService.getInfoByOrganizeId(organizeId);
        if (entity != null) {
            OrganizeAdminIsTratorInfoVo vo = JsonUtilEx.getJsonToBeanEx(entity, OrganizeAdminIsTratorInfoVo.class);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.success((Object)entity);
    }

    @ApiOperation(value="\u65b0\u5efa\u673a\u6784\u5206\u7ea7\u7ba1\u7406\u5458")
    @PostMapping
    public ActionResult create(@RequestBody @Valid OrganizeAdminIsTratorCrForm organizeAdminIsTratorCrForm) {
        OrganizeAdministratorEntity entity = (OrganizeAdministratorEntity)JsonUtil.getJsonToBean((Object)organizeAdminIsTratorCrForm, OrganizeAdministratorEntity.class);
        entity.setId(RandomUtil.uuId());
        this.organizeAdminIsTratorService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u673a\u6784\u5206\u7ea7\u7ba1\u7406")
    @PutMapping(value={"/{organizeId}"})
    public ActionResult update(@PathVariable(value="organizeId") String organizeId, @RequestBody @Valid OrganizeAdminIsTratorCrForm organizeAdminIsTratorCrForm) {
        OrganizeAdministratorEntity entity = (OrganizeAdministratorEntity)JsonUtil.getJsonToBean((Object)organizeAdminIsTratorCrForm, OrganizeAdministratorEntity.class);
        OrganizeAdministratorEntity getEntity = this.organizeAdminIsTratorService.getInfoByOrganizeId(organizeId);
        if (getEntity == null) {
            entity.setId(RandomUtil.uuId());
            this.organizeAdminIsTratorService.create(entity);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        boolean flag = this.organizeAdminIsTratorService.update(organizeId, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u673a\u6784\u5206\u7ea7\u7ba1\u7406")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OrganizeAdministratorEntity organizeAdminIsTratorEntity = this.organizeAdminIsTratorService.getInfoByOrganizeId(id);
        if (organizeAdminIsTratorEntity != null) {
            this.organizeAdminIsTratorService.delete(organizeAdminIsTratorEntity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)"\u67e5\u65e0\u6b64\u8bb0\u5f55");
    }
}

