/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.external.service.SynPushToThirdQyService;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.organize.OrganizeCrForm;
import com.bringspring.system.permission.model.organize.OrganizeDepartCrForm;
import com.bringspring.system.permission.model.organize.OrganizeDepartInfoVO;
import com.bringspring.system.permission.model.organize.OrganizeDepartListVO;
import com.bringspring.system.permission.model.organize.OrganizeDepartSelectorListVO;
import com.bringspring.system.permission.model.organize.OrganizeDepartUpForm;
import com.bringspring.system.permission.model.organize.OrganizeInfoVO;
import com.bringspring.system.permission.model.organize.OrganizeListVO;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.model.organize.OrganizePagination;
import com.bringspring.system.permission.model.organize.OrganizeSelectorVO;
import com.bringspring.system.permission.model.organize.OrganizeTreeVO;
import com.bringspring.system.permission.model.organize.OrganizeUpForm;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u7ba1\u7406"}, value="Organize")
@RestController
@RequestMapping(value={"/api/permission/Organize"})
public class OrganizeController {
    private static final Logger log = LoggerFactory.getLogger(OrganizeController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserService userService;
    @Autowired
    private SynThirdDingTalkService synThirdDingTalkService;
    @Autowired
    private SynPushToThirdQyService synPushToThirdQyService;
    @Autowired
    private Executor threadPoolExecutor;

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    @GetMapping
    public ActionResult<ListVO<OrganizeListVO>> getList(Pagination pagination) {
        List organizeList = JsonUtil.getJsonToList(this.organizeService.getAllCompanyList(pagination.getKeyword()), OrganizeModel.class);
        List trees = TreeDotUtils.convertListToTreeDot((List)organizeList);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u667a\u884c\u5e73\u53f0\u6839\u636e\u6743\u9650\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    @GetMapping(value={"/Company"})
    public ActionResult<ListVO<OrganizeListVO>> getCompanyDataPermission(OrganizePagination organizePagination) {
        List organizeList = JsonUtil.getJsonToList(this.organizeService.getAllCompanyDataPermission(organizePagination), OrganizeModel.class);
        List trees = TreeDotUtils.convertListToTreeDot((List)organizeList);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector/{id}"})
    public ActionResult<ListVO<OrganizeSelectorVO>> getSelector(Pagination pagination, @PathVariable(value="id") String id) {
        List<OrganizeEntity> allList = this.organizeService.getList();
        if (!"0".equals(id)) {
            allList.remove(this.organizeService.getInfo(id));
        }
        allList = allList.stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List<OrganizeEntity> dataAll = allList;
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            allList = allList.stream().filter(t -> t.getFullName().contains(pagination.getKeyword()) || t.getEnCode().contains(pagination.getKeyword())).collect(Collectors.toList());
        }
        List list = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(allList, dataAll), OrganizeEntity.class);
        list = list.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
        List models = JsonUtil.getJsonToList(list, OrganizeModel.class);
        for (OrganizeModel model : models) {
            model.setIcon("icon-ym icon-ym-tree-organization3");
        }
        ArrayList modelAll = new ArrayList();
        modelAll.addAll(models);
        List trees = TreeDotUtils.convertListToTreeDotFilter(modelAll);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeSelectorVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/UserDepartment/Selector/{menuId}"})
    public ActionResult<ListVO<OrganizeDepartSelectorListVO>> getListUserDepartment(@PathVariable(value="menuId") String menuId) {
        List<OrganizeEntity> list = this.organizeService.getOrganizeListDataPermission(menuId);
        List models = JsonUtil.getJsonToList(list, OrganizeModel.class);
        for (OrganizeModel model : models) {
            if ("department".equals(model.getType())) {
                model.setIcon("icon-ym icon-ym-tree-department1");
                continue;
            }
            if (!"company".equals(model.getType())) continue;
            model.setIcon("icon-ym icon-ym-tree-organization3");
        }
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeDepartSelectorListVO.class);
        if (!CollectionUtil.isEmpty((Collection)listVO)) {
            Collections.sort(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren());
            if (!CollectionUtil.isEmpty(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren().get(0).getChildren())) {
                Collections.sort(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren().get(0).getChildren());
            }
        }
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7/\u516c\u53f8\u6811\u5f62")
    @GetMapping(value={"/Tree"})
    public ActionResult<ListVO<OrganizeTreeVO>> tree() {
        List<OrganizeEntity> allList = this.organizeService.getList();
        List list = allList.stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        list = list.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
        List models = JsonUtil.getJsonToList(list, OrganizeModel.class);
        for (OrganizeModel model : models) {
            model.setIcon("icon-ym icon-ym-tree-organization3");
        }
        List trees = TreeDotUtils.convertListToTreeDot((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeTreeVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<OrganizeInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        OrganizeEntity entity = this.organizeService.getInfo(id);
        OrganizeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, OrganizeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u7ec4\u7ec7")
    @PostMapping
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u65b0\u5efa\u7ec4\u7ec7")
    public ActionResult create(@RequestBody @Valid OrganizeCrForm organizeCrForm) throws PermissionException {
        OrganizeEntity entity = (OrganizeEntity)JsonUtil.getJsonToBean((Object)organizeCrForm, OrganizeEntity.class);
        entity.setCategory("company");
        this.organizeService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec4\u7ec7")
    @PutMapping(value={"/{id}"})
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u66f4\u65b0\u7ec4\u7ec7")
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OrganizeUpForm organizeUpForm) {
        OrganizeEntity entity = (OrganizeEntity)JsonUtil.getJsonToBean((Object)organizeUpForm, OrganizeEntity.class);
        if (id.equals(entity.getParentId())) {
            return ActionResult.fail((String)"\u4e0a\u7ea7\u516c\u53f8\u548c\u516c\u53f8\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a");
        }
        if (this.organizeService.isExistByFullName(entity, false, true)) {
            return ActionResult.fail((String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.organizeService.isExistByEnCode(entity.getEnCode(), id)) {
            return ActionResult.fail((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.organizeService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7")
    @DeleteMapping(value={"/{id}"})
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u5220\u9664\u7ec4\u7ec7")
    public ActionResult<String> delete(@PathVariable(value="id") String orgId) {
        return this.organizeService.delete(orgId);
    }

    @ApiOperation(value="\u5220\u9664\u90e8\u95e8")
    @DeleteMapping(value={"/Department/{id}"})
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u5220\u9664\u90e8\u95e8")
    public ActionResult<String> deleteDepartment(@PathVariable(value="id") String orgId) {
        return this.organizeService.delete(orgId);
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u90e8\u95e8")
    @DeleteMapping(value={"/deleteOrganizeByLogical/{id}"})
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u903b\u8f91\u5220\u9664\u7ec4\u7ec7")
    public ActionResult<String> deleteDepartmentByLogical(@PathVariable(value="id") String orgId) throws PermissionException {
        this.organizeService.deleteDepartmentByLogical(orgId);
        return ActionResult.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec4\u7ec7\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u66f4\u65b0\u7ec4\u7ec7\u72b6\u6001")
    public ActionResult update(@PathVariable(value="id") String id) {
        OrganizeEntity organizeEntity = this.organizeService.getInfo(id);
        if (organizeEntity != null) {
            if ("1".equals(String.valueOf(organizeEntity.getEnabledMark()))) {
                organizeEntity.setEnabledMark(0);
            } else {
                organizeEntity.setEnabledMark(1);
            }
            this.organizeService.update(organizeEntity.getId(), organizeEntity);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.success((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u5217\u8868")
    @GetMapping(value={"/{companyId}/Department"})
    public ActionResult<ListVO<OrganizeDepartListVO>> getListDepartment(@PathVariable(value="companyId") String companyId, Pagination pagination) {
        List<OrganizeEntity> dataAll = this.organizeService.getParentIdList(companyId);
        List<String> childId = dataAll.stream().map(t -> t.getId()).collect(Collectors.toList());
        List<OrganizeEntity> data = this.organizeService.getListAll(childId, pagination.getKeyword());
        List models = JsonUtil.getJsonToList(data, OrganizeModel.class);
        for (OrganizeModel model : models) {
            if (StringUtils.isEmpty((String)model.getManagerId())) continue;
            UserEntity entity = (UserEntity)this.userService.getById((Serializable)((Object)model.getManagerId()));
            model.setManagerId(entity != null ? entity.getRealName() : null);
        }
        List listvo = JsonUtil.getJsonToList((Object)models, OrganizeDepartListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listvo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u667a\u884c\u5e73\u53f0\u6839\u636e\u6570\u636e\u6743\u9650\u83b7\u53d6\u90e8\u95e8\u5217\u8868")
    @GetMapping(value={"/{companyId}/Department/{menuId}"})
    public ActionResult<PageListVO<OrganizeDepartListVO>> getListDepartmentDataPermission(@PathVariable(value="companyId") String companyId, @PathVariable(value="menuId") String menuId, Pagination pagination) {
        List<OrganizeEntity> dataAll = this.organizeService.getListDepartmentDataPermission(companyId, menuId);
        List<String> childId = dataAll.stream().map(t -> t.getId()).collect(Collectors.toList());
        List<OrganizeEntity> data = this.organizeService.getListAllJurisdiction(childId, pagination);
        List models = JsonUtil.getJsonToList(data, OrganizeModel.class);
        for (OrganizeModel model : models) {
            if (StringUtils.isEmpty((String)model.getManagerId())) continue;
            UserEntity entity = (UserEntity)this.userService.getById((Serializable)((Object)model.getManagerId()));
            model.setManagerId(entity != null ? entity.getRealName() : null);
        }
        List listvo = JsonUtil.getJsonToList((Object)models, OrganizeDepartListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listvo);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)listvo, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Department/Selector/{id}"})
    public ActionResult<ListVO<OrganizeDepartSelectorListVO>> getListDepartment(@PathVariable(value="id") String id) {
        List<OrganizeEntity> allList = this.organizeService.getList();
        if (!"0".equals(id)) {
            allList.remove(this.organizeService.getInfo(id));
        }
        List data = allList.stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List models = JsonUtil.getJsonToList(data, OrganizeModel.class);
        for (OrganizeModel model : models) {
            if ("department".equals(model.getType())) {
                model.setIcon("icon-ym icon-ym-tree-department1");
                continue;
            }
            if (!"company".equals(model.getType())) continue;
            model.setIcon("icon-ym icon-ym-tree-organization3");
        }
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeDepartSelectorListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u90e8\u95e8")
    @PostMapping(value={"/Department"})
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u65b0\u5efa\u90e8\u95e8")
    public ActionResult createDepartment(@RequestBody @Valid OrganizeDepartCrForm organizeDepartCrForm) throws PermissionException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u5efa\u5931\u8d25");
        }
        OrganizeEntity entity = (OrganizeEntity)JsonUtil.getJsonToBean((Object)organizeDepartCrForm, OrganizeEntity.class);
        if (!this.organizeService.checkCodeUnique(entity.getEnCode(), null)) {
            return ActionResult.fail((String)"\u90e8\u95e8\u7f16\u7801\u51b2\u7a81\uff0c\u65b0\u5efa\u5931\u8d25");
        }
        this.organizeService.createDepartment(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u90e8\u95e8")
    @PutMapping(value={"/Department/{id}"})
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u66f4\u65b0\u90e8\u95e8")
    public ActionResult updateDepartment(@PathVariable(value="id") String id, @RequestBody @Valid OrganizeDepartUpForm oraganizeDepartUpForm) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u5efa\u5931\u8d25");
        }
        OrganizeEntity entity = (OrganizeEntity)JsonUtil.getJsonToBean((Object)oraganizeDepartUpForm, OrganizeEntity.class);
        if (!this.organizeService.checkCodeUnique(entity.getEnCode(), id)) {
            return ActionResult.fail((String)"\u90e8\u95e8\u7f16\u7801\u51b2\u7a81\uff0c\u65b0\u5efa\u5931\u8d25");
        }
        if (id.equals(entity.getParentId())) {
            return ActionResult.fail((String)"\u4e0a\u7ea7\u90e8\u95e8\u548c\u90e8\u95e8\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a");
        }
        if (this.organizeService.isExistByFullName(entity, false, true)) {
            return ActionResult.fail((String)"\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.organizeService.isExistByEnCode(entity.getEnCode(), id)) {
            return ActionResult.fail((String)"\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.organizeService.updateDepartment(id, entity);
        if (oraganizeDepartUpForm.isCoverUserManagerId() && StringUtils.isNotEmpty((String)entity.getManagerId())) {
            this.userService.updateMangerIdByOrganizeId(id, entity.getManagerId());
        }
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u90e8\u95e8\u72b6\u6001")
    @PutMapping(value={"/Department/{id}/Actions/State"})
    @HandleLog(moduleName="\u7ec4\u7ec7\u7ba1\u7406", requestMethod="\u66f4\u65b0\u7ec4\u7ec7\u72b6\u6001")
    public ActionResult updateDepartment(@PathVariable(value="id") String id) {
        OrganizeEntity organizeEntity = this.organizeService.getInfo(id);
        if (organizeEntity != null) {
            if ("1".equals(String.valueOf(organizeEntity.getEnabledMark()))) {
                organizeEntity.setEnabledMark(0);
            } else {
                organizeEntity.setEnabledMark(1);
            }
            this.organizeService.updateDepartment(organizeEntity.getId(), organizeEntity);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f")
    @GetMapping(value={"/Department/{id}"})
    public ActionResult<OrganizeDepartInfoVO> infoDepartment(@PathVariable(value="id") String id) throws DataException {
        OrganizeEntity entity = this.organizeService.getInfo(id);
        OrganizeDepartInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, OrganizeDepartInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u5217\u8868")
    @GetMapping(value={"/getCompanyList/{modelId}"})
    public ActionResult<List<OrganizeEntity>> getCompanyList(@PathVariable(value="modelId") String modelId) throws DataException {
        List<OrganizeEntity> companyList = this.organizeService.getCompanyList(modelId);
        return ActionResult.success(companyList);
    }
}

