/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.permission.PermissionModel;
import com.bringspring.system.permission.model.position.PaginationPosition;
import com.bringspring.system.permission.model.position.PosOrgModel;
import com.bringspring.system.permission.model.position.PositionCrForm;
import com.bringspring.system.permission.model.position.PositionInfoVO;
import com.bringspring.system.permission.model.position.PositionListAllVO;
import com.bringspring.system.permission.model.position.PositionListVO;
import com.bringspring.system.permission.model.position.PositionSelectorVO;
import com.bringspring.system.permission.model.position.PositionUpForm;
import com.bringspring.system.permission.model.position.PositionVo;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c97\u4f4d\u7ba1\u7406"}, value="Position")
@RestController
@RequestMapping(value={"/api/permission/Position"})
public class PositionController {
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OrganizeRelationService organizeRelationService;

    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u5217\u8868\uff08\u5206\u9875\uff09")
    @GetMapping
    public ActionResult<PageListVO<PositionListVO>> list(PaginationPosition paginationPosition) {
        List list = this.organizeService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List<PositionEntity> data = this.positionService.getList(paginationPosition);
        List voList = JsonUtil.getJsonToList(data, PositionListVO.class);
        for (Object entity1 : voList) {
            OrganizeEntity entity = list.stream().filter(arg_0 -> PositionController.lambda$list$1((PositionListVO)entity1, arg_0)).findFirst().orElse(new OrganizeEntity());
            if (((PositionListVO)entity1).getOrganizeId().equals(entity.getId())) {
                ((PositionListVO)entity1).setDepartment(entity.getFullName());
            }
            ((PositionListVO)entity1).setDepartment(PermissionUtil.getLinkInfoByOrgId(((PositionListVO)entity1).getOrganizeId(), this.organizeService, false));
        }
        List<DictionaryDataEntity> dictionaryDataEntities = this.dictionaryDataService.getList("dae93f2fd7cd4df999d32f8750fa6a1e", false);
        for (PositionListVO entity1 : voList) {
            DictionaryDataEntity entity = dictionaryDataEntities.stream().filter(t -> t.getEnCode().equals(entity1.getType())).findFirst().orElse(null);
            if (entity == null) continue;
            entity1.setType(entity.getFullName());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationPosition), PaginationVO.class);
        return ActionResult.page((List)voList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u5217\u8868\uff08\u5206\u9875\uff09")
    @GetMapping(value={"/positionDataPermission"})
    public ActionResult<PageListVO<PositionListVO>> listDataPermission(PaginationPosition paginationPosition) {
        List list = this.organizeService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List<PositionEntity> data = this.positionService.getListPositionDataPermission(paginationPosition);
        List voList = JsonUtil.getJsonToList(data, PositionListVO.class);
        for (Object entity1 : voList) {
            OrganizeEntity entity = list.stream().filter(arg_0 -> PositionController.lambda$listDataPermission$4((PositionListVO)entity1, arg_0)).findFirst().orElse(new OrganizeEntity());
            if (((PositionListVO)entity1).getOrganizeId().equals(entity.getId())) {
                ((PositionListVO)entity1).setDepartment(entity.getFullName());
            }
            ((PositionListVO)entity1).setDepartment(PermissionUtil.getLinkInfoByOrgId(((PositionListVO)entity1).getOrganizeId(), this.organizeService, false));
        }
        List<DictionaryDataEntity> dictionaryDataEntities = this.dictionaryDataService.getList("dae93f2fd7cd4df999d32f8750fa6a1e", false);
        for (PositionListVO entity1 : voList) {
            DictionaryDataEntity entity = dictionaryDataEntities.stream().filter(t -> t.getEnCode().equals(entity1.getType())).findFirst().orElse(null);
            if (entity == null) continue;
            entity1.setType(entity.getFullName());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationPosition), PaginationVO.class);
        return ActionResult.page((List)voList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u5c97\u4f4d\u7c7b\u578b\u548c\u5c97\u4f4d\u6811\u72b6\u56fe")
    @GetMapping(value={"/positionTree"})
    public ActionResult<ListVO<PositionSelectorVO>> positionTree() {
        List list = this.positionService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List positionList = new ArrayList();
        positionList = JsonUtil.getJsonToList(list, PosOrgModel.class);
        List<DictionaryDataEntity> positionType = this.dictionaryDataService.getList("dae93f2fd7cd4df999d32f8750fa6a1e");
        List positionParentList = JsonUtil.getJsonToList(positionType, PosOrgModel.class);
        positionList.stream().forEach(v -> {
            List collectParent = positionType.stream().filter(j -> j.getEnCode().equals(v.getType())).collect(Collectors.toList());
            v.setType("position");
            if (!ObjectUtil.isEmpty(collectParent)) {
                v.setParentId(((DictionaryDataEntity)collectParent.get(0)).getId());
            }
        });
        positionList.addAll(positionParentList);
        List trees = TreeDotUtils.convertListToTreeDot(positionList);
        List jsonToList1 = JsonUtil.getJsonToList((Object)trees, PositionSelectorVO.class);
        ListVO vo = new ListVO();
        vo.setList(jsonToList1);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/All"})
    public ActionResult<ListVO<PositionListAllVO>> listAll() {
        List list = this.positionService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List vos = JsonUtil.getJsonToList(list, PositionListAllVO.class);
        ListVO vo = new ListVO();
        vo.setList(vos);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u4e0b\u62c9\u5217\u8868\uff08\u516c\u53f8+\u90e8\u95e8+\u5c97\u4f4d\uff09")
    @GetMapping(value={"/Selector"})
    public ActionResult selector() {
        List<PositionEntity> list1 = this.positionService.getList();
        List<OrganizeEntity> list2 = this.organizeService.getList();
        ArrayList<PosOrgModel> posList = new ArrayList<PosOrgModel>();
        for (PositionEntity positionEntity : list1) {
            PosOrgModel posOrgModel = (PosOrgModel)((Object)JsonUtil.getJsonToBean((Object)positionEntity, PosOrgModel.class));
            posOrgModel.setParentId(positionEntity.getOrganizeId());
            posOrgModel.setType("position");
            posOrgModel.setIcon("icon-ym icon-ym-tree-position1");
            posList.add(posOrgModel);
        }
        List orgList = JsonUtil.getJsonToList(list2, PosOrgModel.class);
        for (PosOrgModel entity1 : orgList) {
            if ("department".equals(entity1.getType())) {
                entity1.setIcon("icon-ym icon-ym-tree-department1");
                continue;
            }
            if (!"company".equals(entity1.getType())) continue;
            entity1.setIcon("icon-ym icon-ym-tree-organization3");
        }
        JSONArray jSONArray = ListToTreeUtil.treeWhere(posList, (List)orgList);
        List jsonToList = JsonUtil.getJsonToList((Object)jSONArray, PosOrgModel.class);
        ArrayList list = new ArrayList(16);
        List collect = jsonToList.stream().filter(t -> "position".equals(t.getType())).sorted(Comparator.comparing(PosOrgModel::getSortCode)).collect(Collectors.toList());
        list.addAll(collect);
        jsonToList.removeAll(collect);
        List collect1 = jsonToList.stream().sorted(Comparator.comparing(PosOrgModel::getSortCode).thenComparing(PosOrgModel::getCreatorTime, Comparator.reverseOrder())).collect(Collectors.toList());
        list.addAll(collect1);
        List trees = TreeDotUtils.convertListToTreeDot(list);
        List jsonToList1 = JsonUtil.getJsonToList((Object)trees, PositionSelectorVO.class);
        ListVO vo = new ListVO();
        vo.setList(jsonToList1);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u901a\u8fc7\u7ec4\u7ec7id\u83b7\u53d6\u5c97\u4f4d\u5217\u8868")
    @GetMapping(value={"/getList/{organizeId}"})
    public ActionResult<List<PositionVo>> getListByOrganizeId(@PathVariable(value="organizeId") String organizeId) {
        List<PositionEntity> list = this.positionService.getListByOrganizeId(organizeId);
        List jsonToList = JsonUtil.getJsonToList(list, PositionVo.class);
        return ActionResult.success((Object)jsonToList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u7ba1\u7406\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<PositionInfoVO> getInfo(@PathVariable(value="id") String id) throws DataException {
        PositionEntity entity = this.positionService.getInfo(id);
        PositionInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, PositionInfoVO.class);
        if (!ObjectUtil.isEmpty((Object)vo.getOrganizeId())) {
            vo.setOrganizeName(this.organizeService.getInfo(vo.getOrganizeId()).getFullName());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u5c97\u4f4d\u7ba1\u7406")
    @PostMapping
    public ActionResult create(@RequestBody @Valid PositionCrForm positionCrForm) {
        PositionEntity entity = (PositionEntity)JsonUtil.getJsonToBean((Object)positionCrForm, PositionEntity.class);
        if (this.positionService.isExistByFullName(entity, false)) {
            return ActionResult.fail((String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.positionService.isExistByEnCode(entity, false)) {
            return ActionResult.fail((String)"\u5c97\u4f4d\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        entity.setId(RandomUtil.uuId());
        this.createOrganizeRoleRelation(entity.getOrganizeId(), entity.getId());
        this.positionService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u5c97\u4f4d\u7ba1\u7406")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid PositionUpForm positionUpForm) {
        if (this.userRelationService.existByObjectId(id, "Position").booleanValue() && !this.positionService.getInfo(id).getOrganizeId().equals(positionUpForm.getOrganizeId())) {
            return ActionResult.fail((String)MsgCode.FA023.get());
        }
        PositionEntity entity = (PositionEntity)JsonUtil.getJsonToBean((Object)positionUpForm, PositionEntity.class);
        entity.setId(id);
        if (this.positionService.isExistByFullName(entity, true)) {
            return ActionResult.fail((String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.positionService.isExistByEnCode(entity, true)) {
            return ActionResult.fail((String)"\u5c97\u4f4d\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.createOrganizeRoleRelation(entity.getOrganizeId(), id);
        boolean flag = this.positionService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u5c97\u4f4d\u7ba1\u7406")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        if (this.userRelationService.existByObjectId(id, "Position").booleanValue()) {
            return ActionResult.fail((String)MsgCode.FA024.get());
        }
        PositionEntity entity = this.positionService.getInfo(id);
        if (entity != null) {
            List<UserRelationEntity> userRelList = this.userRelationService.getListByObjectId(id);
            if (userRelList.size() > 0) {
                return ActionResult.fail((String)"\u8be5\u5c97\u4f4d\u4e0b\u6709\u7528\u6237");
            }
            for (UserRelationEntity entity1 : userRelList) {
                UserEntity entity2 = (UserEntity)this.userService.getById((Serializable)((Object)entity1.getUserId()));
                if (entity2 == null) continue;
                String newPositionId = entity2.getPositionId().replace(id, "");
                if (!entity2.getPositionId().contains(id)) continue;
                if (newPositionId.length() != 0 && newPositionId.substring(0, 1) == ",") {
                    entity2.setPositionId(newPositionId.substring(1));
                    continue;
                }
                if (newPositionId.length() == 0) continue;
                entity2.setPositionId(newPositionId.replace(",,", ","));
            }
            this.userRelationService.deleteAllByObjId(id);
            QueryWrapper query = new QueryWrapper();
            query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Position");
            query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)id);
            this.organizeRelationService.remove((Wrapper)query);
            this.positionService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u83dc\u5355\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult upState(@PathVariable(value="id") String id) {
        PositionEntity entity = this.positionService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == null || "1".equals(String.valueOf(entity.getEnabledMark()))) {
                entity.setEnabledMark(0);
            } else {
                entity.setEnabledMark(1);
            }
            this.positionService.update(id, entity);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)"MsgCode.UPDATE_FAIL_NOT_EXISTS");
    }

    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u5217\u8868\u901a\u8fc7\u7ec4\u7ec7id\u6570\u7ec4")
    @PostMapping(value={"/getListByOrgIds"})
    public ActionResult<ListVO<PermissionModel>> getListByOrganizeIds(@RequestBody @Valid Map<String, List<String>> organizeIds) {
        LinkedList<PermissionModel> PositionModelAll = new LinkedList<PermissionModel>();
        for (String organizeId : organizeIds.get("organizeIds")) {
            OrganizeEntity info = this.organizeService.getInfo(organizeId);
            if (info == null) continue;
            PermissionModel parentModel = new PermissionModel();
            List<PositionEntity> list = this.positionService.getListByOrganizeId(organizeId);
            List positionModels = JsonUtil.getJsonToList(list, PermissionModel.class);
            parentModel.setHasChildren(true);
            parentModel.setFullName(info.getFullName());
            parentModel.setId(info.getId());
            parentModel.setChildren(positionModels);
            PositionModelAll.add(parentModel);
        }
        ListVO vo = new ListVO();
        vo.setList(PositionModelAll);
        return ActionResult.success((Object)vo);
    }

    private void createOrganizeRoleRelation(String organizeId, String positionId) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Position");
        query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)positionId);
        this.organizeRelationService.remove((Wrapper)query);
        OrganizeRelationEntity organizeRelationEntity = new OrganizeRelationEntity();
        organizeRelationEntity.setId(RandomUtil.uuId());
        organizeRelationEntity.setOrganizeId(organizeId);
        organizeRelationEntity.setObjectType("Position");
        organizeRelationEntity.setObjectId(positionId);
        this.organizeRelationService.save(organizeRelationEntity);
    }

    private static /* synthetic */ boolean lambda$listDataPermission$4(PositionListVO entity1, OrganizeEntity t) {
        return t.getId().equals(entity1.getOrganizeId());
    }

    private static /* synthetic */ boolean lambda$list$1(PositionListVO entity1, OrganizeEntity t) {
        return t.getId().equals(entity1.getOrganizeId());
    }
}

