/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.mapper.OrganizeRelationMapper;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrganizeRelationServiceImpl
extends ServiceImpl<OrganizeRelationMapper, OrganizeRelationEntity>
implements OrganizeRelationService {
    @Autowired
    RoleService roleService;
    @Autowired
    PositionService positionService;
    @Autowired
    UserRelationService userRelationService;
    @Autowired
    UserService userService;
    @Autowired
    AuthorizeService authorizeService;

    @Override
    public List<OrganizeRelationEntity> getRelationListByOrganizeId(List<String> OrganizeIds) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Role");
        if (OrganizeIds.size() > 0) {
            query.lambda().in(OrganizeRelationEntity::getOrganizeId, OrganizeIds);
        }
        query.lambda().orderByDesc(OrganizeRelationEntity::getCreatorTime);
        return this.list((Wrapper)query);
    }

    @Override
    public List<OrganizeRelationEntity> getRelationListByRoleId(String roleId) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Role");
        query.lambda().in(OrganizeRelationEntity::getObjectId, new Object[]{roleId});
        query.lambda().orderByDesc(OrganizeRelationEntity::getCreatorTime);
        return this.list((Wrapper)query);
    }

    @Override
    public List<OrganizeRelationEntity> getRelationListByRoleIdList(List<String> roleId) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)"Role");
        query.lambda().in(OrganizeRelationEntity::getObjectId, roleId);
        query.lambda().orderByDesc(OrganizeRelationEntity::getCreatorTime);
        return this.list((Wrapper)query);
    }

    @Override
    public List<OrganizeRelationEntity> getRelationListByObjectIdAndType(String objectType, String objectId) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)objectId);
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)objectType);
        return this.list((Wrapper)query);
    }

    @Override
    public Boolean existByObjTypeAndOrgId(String objectType, String organizeId) {
        return this.existByObejctIdAndOrgIdAndObjectType(organizeId, null, objectType);
    }

    @Override
    public Boolean existByObejctIdAndOrgIdAndObjectType(String organizeId, String objectId, String objectType) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)objectType);
        if (StringUtils.isNotEmpty((String)objectId)) {
            query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)objectId);
        }
        query.lambda().in(OrganizeRelationEntity::getOrganizeId, new Object[]{organizeId});
        return this.count((Wrapper)query) > 0L;
    }

    @Override
    public List<OrganizeRelationEntity> getListByTypeAndOrgId(String objectType, String orgId) {
        QueryWrapper query = new QueryWrapper();
        ((LambdaQueryWrapper)query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)objectType)).eq(OrganizeRelationEntity::getOrganizeId, (Object)orgId);
        query.lambda().orderByDesc(OrganizeRelationEntity::getCreatorTime);
        return this.list((Wrapper)query);
    }

    @Override
    public Boolean deleteAllByObjectId(String objectId, String objectType) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)objectId);
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)objectType);
        return this.remove((Wrapper)query);
    }

    @Override
    public String autoGetMajorPositionId(String userId, String currentMajorOrgId, String currentMajorPosId) {
        List<PositionEntity> positionList = this.positionService.getListByOrgIdAndUserId(currentMajorOrgId, userId);
        if (positionList.size() > 0) {
            if (positionList.stream().anyMatch(p -> p.getId().equals(currentMajorPosId))) {
                return currentMajorPosId;
            }
            return positionList.get(0).getId();
        }
        return "0";
    }

    @Override
    public String autoGetMajorOrganizeId(String userId, List<String> userAllOrgIds, String currentMajorOrgId) {
        if (userAllOrgIds.size() > 0) {
            if (userAllOrgIds.contains(currentMajorOrgId) && this.checkBasePermission(userId, currentMajorOrgId).booleanValue()) {
                return currentMajorOrgId;
            }
            List selectOrgIds = userAllOrgIds.stream().filter(usi -> !usi.equals(currentMajorOrgId)).collect(Collectors.toList());
            for (String orgId : selectOrgIds) {
                if (!this.checkBasePermission(userId, orgId).booleanValue()) continue;
                return orgId;
            }
            return userAllOrgIds.get(0);
        }
        return "";
    }

    @Override
    public void autoSetOrganize(List<String> allUpdateUserIds) {
        if (allUpdateUserIds.size() > 0) {
            for (UserEntity userEntity : this.userService.listByIds(allUpdateUserIds)) {
                String useId = userEntity.getId();
                String majorOrgId = userEntity.getOrganizeId();
                List<String> orgList = this.userRelationService.getListByObjectType(useId, "Organize").stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
                String changeOrgId = this.autoGetMajorOrganizeId(useId, orgList, majorOrgId);
                if (changeOrgId.equals(majorOrgId)) continue;
                UserEntity updateUserEntity = new UserEntity();
                updateUserEntity.setId(useId);
                updateUserEntity.setOrganizeId(changeOrgId);
                this.userService.update(updateUserEntity);
            }
        }
    }

    @Override
    public void autoSetPosition(List<String> allUpdateUserIds) {
        if (allUpdateUserIds.size() > 0) {
            for (UserEntity user : this.userService.listByIds(allUpdateUserIds)) {
                String majorPosId = user.getPositionId();
                String changePositionId = this.autoGetMajorPositionId(user.getId(), user.getOrganizeId(), majorPosId);
                if (changePositionId.equals(majorPosId)) continue;
                UserEntity updateUser = new UserEntity();
                updateUser.setId(user.getId());
                updateUser.setPositionId(changePositionId);
                this.userService.update(updateUser);
            }
        }
    }

    @Override
    public Boolean checkBasePermission(String userId, String orgId) {
        List<String> roles = this.roleService.getAllRoleIdsByUserIdAndOrgId(userId, orgId);
        for (String roleId : roles) {
            if (!this.authorizeService.existByObjId(roleId).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createOraganizeRelation(String organizeId, String objectId, String objectType) throws PermissionException {
        if (StringUtils.isEmpty((String)organizeId)) {
            throw new PermissionException("\u521b\u5efa\u7ec4\u7ec7\u5173\u8054\u5173\u7cfb\u7f3a\u5c11\u7ec4\u7ec7ID");
        }
        if (StringUtils.isEmpty((String)objectId)) {
            throw new PermissionException("\u521b\u5efa\u7ec4\u7ec7\u5173\u8054\u5173\u7cfb\u7f3a\u5c11\u5bf9\u8c61ID");
        }
        if (StringUtils.isEmpty((String)objectType)) {
            throw new PermissionException("\u521b\u5efa\u7ec4\u7ec7\u5173\u8054\u5173\u7cfb\u7f3a\u5c11\u5bf9\u8c61\u7c7b\u578b");
        }
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, (Object)objectType);
        query.lambda().eq(OrganizeRelationEntity::getObjectId, (Object)objectId);
        this.remove((Wrapper)query);
        OrganizeRelationEntity organizeRelationEntity = new OrganizeRelationEntity();
        organizeRelationEntity.setId(RandomUtil.uuId());
        organizeRelationEntity.setOrganizeId(organizeId);
        organizeRelationEntity.setObjectType(objectType);
        organizeRelationEntity.setObjectId(objectId);
        this.save(organizeRelationEntity);
    }
}

