/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.util;

import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.permission.entity.OrganizeAdministratorEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeAdministratorService;
import com.bringspring.system.permission.service.OrganizeService;

public class PermissionAspectUtil {
    private static final OrganizeService organizeService = (OrganizeService)SpringContext.getBean(OrganizeService.class);
    private static final OrganizeAdministratorService organizeAdministratorService = (OrganizeAdministratorService)SpringContext.getBean(OrganizeAdministratorService.class);

    public static Boolean getPermitByUserId(String targetUserId, String operatorUsrId, String methodName) {
        for (OrganizeEntity organizeEntity : organizeService.getAllOrgByUserId(targetUserId)) {
            if (!PermissionAspectUtil.containPermission(organizeEntity.getId(), operatorUsrId, methodName)) continue;
            return true;
        }
        return false;
    }

    public static boolean containPermission(String organizeId, String operatorUserId, String methodName) {
        OrganizeEntity organizeEntity = organizeService.getInfo(organizeId);
        if (organizeEntity != null) {
            OrganizeAdministratorEntity adminEntity = organizeAdministratorService.getOne(operatorUserId, organizeId);
            if (PermissionAspectUtil.permissionFlag(adminEntity, methodName, true)) {
                return true;
            }
            return PermissionAspectUtil.parentPermission(organizeEntity.getParentId(), methodName, operatorUserId);
        }
        return false;
    }

    public static Boolean getPermitByOrgIds(String organizeIds, String operatorUsrId, String methodName) {
        for (String organizeId : organizeIds.split(",")) {
            if (!PermissionAspectUtil.containPermission(organizeId, operatorUsrId, methodName)) continue;
            return true;
        }
        return false;
    }

    private static boolean parentPermission(String organizeParentId, String methodName, String userId) {
        OrganizeEntity parentOrganizeEntity = organizeService.getInfo(organizeParentId);
        if (parentOrganizeEntity != null) {
            if (PermissionAspectUtil.permissionFlag(organizeAdministratorService.getOne(userId, parentOrganizeEntity.getId()), methodName, false)) {
                return true;
            }
            if (!"-1".equals(parentOrganizeEntity.getParentId())) {
                return PermissionAspectUtil.parentPermission(parentOrganizeEntity.getParentId(), methodName, userId);
            }
        }
        return false;
    }

    private static boolean permissionFlag(OrganizeAdministratorEntity adminEntity, String methodName, Boolean thisFlag) {
        if (adminEntity != null) {
            String methodType = "";
            try {
                switch (methodName) {
                    case "create": {
                        methodType = "Add";
                        break;
                    }
                    case "update": {
                        methodType = "Edit";
                        break;
                    }
                    case "delete": {
                        methodType = "Delete";
                        break;
                    }
                }
                String method = (thisFlag != false ? "getThisLayer" : "getSubLayer") + methodType;
                if ((Integer)OrganizeAdministratorEntity.class.getMethod(method, new Class[0]).invoke((Object)adminEntity, new Object[0]) == 1) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

