/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.util;

import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PermissionUtil {
    private static LinkedList<String> getOrganizeInfos(LinkedList<String> organizeInfo, String organizeId, Integer infoType, OrganizeService organizeService) {
        OrganizeEntity infoEntity = organizeService.getInfo(organizeId);
        if (infoEntity != null) {
            organizeInfo.add(infoType.equals(1) ? organizeId : infoEntity.getFullName());
            if (infoEntity != null && !"-1".equals(infoEntity.getParentId())) {
                PermissionUtil.getOrganizeInfos(organizeInfo, infoEntity.getParentId(), infoType, organizeService);
            } else {
                Collections.reverse(organizeInfo);
            }
        }
        return organizeInfo;
    }

    public static List<LinkedList<String>> getOrgIdsTree(List<String> organizeIds, Integer infoType, OrganizeService organizeService) {
        ArrayList<LinkedList<String>> organizeIdsTree = new ArrayList<LinkedList<String>>();
        organizeIds.forEach(id -> {
            LinkedList<String> organizeInfos = PermissionUtil.getOrganizeInfos(new LinkedList<String>(), id, infoType, organizeService);
            organizeIdsTree.add(organizeInfos);
        });
        return organizeIdsTree;
    }

    public static String getLinkInfoByOrgId(List<String> organizeIds, OrganizeService organizeService) {
        StringBuilder organizeInfoVo = new StringBuilder();
        for (String id : organizeIds) {
            if (id == null) continue;
            StringBuilder organizeInfo = new StringBuilder();
            for (String name : PermissionUtil.getOrganizeInfos(new LinkedList<String>(), id, 2, organizeService)) {
                organizeInfo.append(name).append("/");
            }
            if (organizeInfo.length() > 0) {
                organizeInfo = new StringBuilder(organizeInfo.substring(0, organizeInfo.length() - 1));
            }
            organizeInfo.append(",");
            organizeInfoVo.append((CharSequence)organizeInfo);
        }
        List<String> strings = Arrays.asList(organizeInfoVo.toString().split("/"));
        return String.join((CharSequence)"/", strings);
    }

    public static String getLinkInfoByOrgId(String organizeId, OrganizeService organizeService) {
        return PermissionUtil.getLinkInfoByOrgId(Collections.singletonList(organizeId), organizeService);
    }

    public static String getLinkInfoByOrgId(String organizeId, OrganizeService organizeService, Boolean separateFlag) {
        String linkInfo = PermissionUtil.getLinkInfoByOrgId(organizeId, organizeService);
        if (!separateFlag.booleanValue()) {
            linkInfo = linkInfo.substring(0, linkInfo.length() - 1);
        }
        return linkInfo;
    }

    public static List<String> getOrgIdsByFormTree(OrganizeService organizeService, List<List<String>> organizeIdsTree) throws DataException {
        ArrayList<String> orgIds = new ArrayList<String>();
        for (List<String> organizeIds : organizeIdsTree) {
            String organizeId = organizeIds.get(organizeIds.size() - 1);
            orgIds.add(organizeId);
        }
        int count = organizeService.listByIds(orgIds).size();
        if (count != orgIds.size()) {
            throw new DataException(MsgCode.FA026.get());
        }
        return orgIds;
    }
}

