/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.print.util;

import com.bringspring.system.print.enums.ResultColumnKeysEnum;
import com.bringspring.system.print.model.PrintFieldModel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PrintDevUtil {
    public static List<PrintFieldModel> getColumnInfo(Connection conn, String table) {
        ArrayList<PrintFieldModel> printFieldModelList = new ArrayList<PrintFieldModel>();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            ResultSet rs = metaData.getColumns(conn.getCatalog(), "%", table, "%");
            while (rs.next()) {
                PrintFieldModel printFieldModel = new PrintFieldModel();
                printFieldModel.setColumnName(rs.getString(ResultColumnKeysEnum.COLUMN_NAME.name()));
                printFieldModel.setDataType(rs.getString(ResultColumnKeysEnum.DATA_TYPE.name()));
                printFieldModel.setTypeName(rs.getString(ResultColumnKeysEnum.TYPE_NAME.name()));
                printFieldModel.setColumnSize(rs.getString(ResultColumnKeysEnum.COLUMN_SIZE.name()));
                printFieldModel.setDecimalDigits(rs.getString(ResultColumnKeysEnum.DECIMAL_DIGITS.name()));
                printFieldModel.setNumPrecRadix(rs.getString(ResultColumnKeysEnum.NUM_PREC_RADIX.name()));
                printFieldModel.setReMarks(rs.getString(ResultColumnKeysEnum.REMARKS.name()));
                printFieldModel.setColumnDef(rs.getString(ResultColumnKeysEnum.COLUMN_DEF.name()));
                printFieldModel.setCharOctetLength(rs.getString(ResultColumnKeysEnum.CHAR_OCTET_LENGTH.name()));
                printFieldModel.setOrdinalPosition(rs.getString(ResultColumnKeysEnum.ORDINAL_POSITION.name()));
                printFieldModel.setIsNullAble(rs.getString(ResultColumnKeysEnum.IS_NULLABLE.name()));
                printFieldModel.setIsAutoIncrement(rs.getString(ResultColumnKeysEnum.IS_AUTOINCREMENT.name()));
                printFieldModelList.add(printFieldModel);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8868\u4fe1\u606f\u62bd\u53d6\u5f02\u5e38\uff01", e);
        }
        return printFieldModelList;
    }

    public static String compareGetColumnComment(Connection conn, String table, String columnName) {
        List<PrintFieldModel> columnList = PrintDevUtil.getColumnInfo(conn, table);
        for (PrintFieldModel printFieldModel : columnList) {
            if (!printFieldModel.getColumnName().equalsIgnoreCase(columnName)) continue;
            return printFieldModel.getReMarks();
        }
        return null;
    }
}

