/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.scheduletask.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.task.LocalTaskModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.entity.TimeTaskLogEntity;
import com.bringspring.system.scheduletask.model.TaskCrForm;
import com.bringspring.system.scheduletask.model.TaskInfoVO;
import com.bringspring.system.scheduletask.model.TaskLogVO;
import com.bringspring.system.scheduletask.model.TaskMethodsVO;
import com.bringspring.system.scheduletask.model.TaskPage;
import com.bringspring.system.scheduletask.model.TaskUpForm;
import com.bringspring.system.scheduletask.model.TaskVO;
import com.bringspring.system.scheduletask.service.TimetaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u8c03\u5ea6"}, value="TimeTask")
@RestController
@RequestMapping(value={"/api/scheduletask"})
public class TimeTaskController {
    @Autowired
    private TimetaskService timetaskService;
    @Autowired
    private ConcurrentHashMap<String, LocalTaskModel> concurrentHashMap;

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8c03\u5ea6\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<TaskVO>> list(Pagination pagination) {
        List<TimeTaskEntity> data = this.timetaskService.getList(pagination);
        List list = JsonUtil.getJsonToList(data, TaskVO.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8c03\u5ea6\u5217\u8868")
    @GetMapping(value={"/TaskMethods"})
    public ActionResult<List<TaskMethodsVO>> taskMethods() {
        ArrayList<TaskMethodsVO> list = new ArrayList<TaskMethodsVO>(16);
        for (String id : this.concurrentHashMap.keySet()) {
            LocalTaskModel model = this.concurrentHashMap.get(id);
            TaskMethodsVO taskMethodsVO = new TaskMethodsVO();
            taskMethodsVO.setId(model.getId());
            taskMethodsVO.setFullName(model.getFullName());
            taskMethodsVO.setDescription(model.getDescription());
            list.add(taskMethodsVO);
        }
        return ActionResult.success(list);
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8c03\u5ea6\u65e5\u5fd7\u5217\u8868")
    @GetMapping(value={"/{id}/TaskLog"})
    public ActionResult<PageListVO<TaskLogVO>> list(@PathVariable(value="id") String taskId, TaskPage pagination) {
        List<TimeTaskLogEntity> data = this.timetaskService.getTaskLogList(taskId, pagination);
        List list = JsonUtil.getJsonToList(data, TaskLogVO.class);
        PaginationVO pageModel = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)pageModel);
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8c03\u5ea6\u4fe1\u606f")
    @GetMapping(value={"/Info/{id}"})
    public ActionResult<TaskInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        TimeTaskEntity entity = this.timetaskService.getInfo(id);
        TaskInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, TaskInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8c03\u5ea6\u4fe1\u606f")
    @GetMapping(value={"/getListByEncode/{encode}"})
    public ActionResult<List<TaskVO>> getListByEncode(@PathVariable(value="encode") String encode) throws DataException {
        List<TimeTaskEntity> listByEncode = this.timetaskService.getListByEncode(encode);
        List list = JsonUtil.getJsonToList(listByEncode, TaskVO.class);
        return ActionResult.success((Object)list);
    }

    @ApiOperation(value="\u65b0\u5efa\u4efb\u52a1\u8c03\u5ea6")
    @PostMapping
    public ActionResult create(@RequestBody @Valid TaskCrForm taskCrForm) {
        TimeTaskEntity entity = (TimeTaskEntity)JsonUtil.getJsonToBean((Object)taskCrForm, TimeTaskEntity.class);
        if (this.timetaskService.isExistByFullName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        this.timetaskService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u8c03\u5ea6")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid TaskUpForm taskUpForm) {
        TimeTaskEntity entity = (TimeTaskEntity)JsonUtil.getJsonToBean((Object)taskUpForm, TimeTaskEntity.class);
        if (this.timetaskService.isExistByFullName(entity.getFullName(), id)) {
            return ActionResult.fail((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        TimeTaskEntity taskEntity = this.timetaskService.getInfo(id);
        if (taskEntity == null) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        entity.setEnabledMark(taskEntity.getEnabledMark());
        entity.setRunCount(taskEntity.getRunCount());
        boolean flag = this.timetaskService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u4efb\u52a1")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        TimeTaskEntity entity = this.timetaskService.getInfo(id);
        if (entity != null) {
            this.timetaskService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u7acb\u5373\u6267\u884c\u4efb\u52a1")
    @PutMapping(value={"/{id}/Actions/startNow"})
    public ActionResult jobStartNow(@PathVariable(value="id") String id) {
        TimeTaskEntity entity = this.timetaskService.getInfo(id);
        if (entity != null) {
            this.timetaskService.jobStartNow(id, entity);
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4efb\u52a1\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u505c\u6b62\u4efb\u52a1\u8c03\u5ea6")
    @PutMapping(value={"/{id}/Actions/Stop"})
    public ActionResult stop(@PathVariable(value="id") String id) {
        TimeTaskEntity entity = this.timetaskService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(0);
            this.timetaskService.update(id, entity);
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4efb\u52a1\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u542f\u52a8\u4efb\u52a1\u8c03\u5ea6")
    @PutMapping(value={"/{id}/Actions/Enable"})
    public ActionResult enable(@PathVariable(value="id") String id) {
        TimeTaskEntity entity = this.timetaskService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(1);
            this.timetaskService.update(id, entity);
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4efb\u52a1\u4e0d\u5b58\u5728");
    }
}

