/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.scheduletask.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.model.task.LocalTaskModel;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.system.base.entity.DataInterfaceEntity;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.entity.TimeTaskLogEntity;
import com.bringspring.system.scheduletask.model.ContentModel;
import com.bringspring.system.scheduletask.model.TaskParameterModel;
import com.bringspring.system.scheduletask.service.TimeService;
import com.bringspring.system.scheduletask.service.TimeTaskLogService;
import com.bringspring.system.scheduletask.service.TimetaskService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class TimeServiceImpl
implements TimeService {
    private static final Logger log = LoggerFactory.getLogger(TimeServiceImpl.class);
    @Autowired
    private TimeTaskLogService taskLogService;
    @Autowired
    private TimetaskService taskService;
    @Autowired
    private DataInterfaceService dataInterfaceService;
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private DataSourceModel dataSourceUtils;
    @Autowired
    private ConcurrentHashMap<String, LocalTaskModel> concurrentHashMap;
    @Autowired
    private UserProvider userProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void storage(ContentModel model, String id, String tenantId, String tenantDbConnectionString, String token) {
        if (StringUtils.isNotEmpty((String)tenantId)) {
            DataSourceContextHolder.setDatasource((String)tenantId, (String)tenantDbConnectionString);
        }
        Date startDate = new Date();
        StringBuffer history = new StringBuffer();
        history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011\u3010\u6267\u884c\u5f00\u59cb\u3011 ");
        boolean falg = true;
        String msg = "";
        try {
            DataInterfaceEntity entity = this.dataInterfaceService.getInfo(model.getInterfaceId());
            String sql = entity.getQuery();
            sql = this.systemParameter(sql, this.userProvider.get(token));
            for (TaskParameterModel parameterModel : model.getParameter()) {
                if (StringUtils.isNotEmpty((String)parameterModel.getValue())) {
                    sql = sql.replaceAll("\\{" + parameterModel.getField() + "}", parameterModel.getValue());
                    continue;
                }
                sql = sql.replaceAll("\\{" + parameterModel.getField() + "}", parameterModel.getValue());
            }
            DbLinkEntity linkEntity = this.dblinkService.getInfo(entity.getId());
            Connection conn = null;
            try {
                conn = linkEntity != null ? ConnUtil.getConn((DataSourceMod)linkEntity) : ConnUtil.getConn((DataSourceMod)this.dataSourceUtils);
                CallableStatement callStmt = null;
                try {
                    if (conn != null) {
                        callStmt = conn.prepareCall(sql.toString());
                        callStmt.execute();
                    }
                }
                finally {
                    if (Collections.singletonList(callStmt).get(0) != null) {
                        callStmt.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            falg = false;
            msg = e.getMessage();
        }
        history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011");
        history.append(falg ? "\u3010\u6267\u884c\u6210\u529f:\u5b58\u50a8\u8fc7\u7a0b\u8c03\u7528\u6210\u529f\u3011 " : "\u3010\u6267\u884c\u5931\u8d25:" + msg + "\u3011");
        history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011\u3010\u6267\u884c\u7ed3\u675f\u3011");
        TimeTaskLogEntity baskLog = new TimeTaskLogEntity();
        baskLog.setId(RandomUtil.uuId());
        baskLog.setTaskId(id);
        baskLog.setRunTime(startDate);
        baskLog.setDescription(history.toString());
        baskLog.setRunResult(falg ? 0 : 1);
        this.taskLogService.save(baskLog);
        TimeTaskEntity entity = this.taskService.getInfo(id);
        int count = (int)this.taskLogService.getTaskLogCount(id);
        entity.setRunCount(count);
        entity.setLastModifyTime(startDate);
        entity.setLastRunTime(startDate);
        Date nextTime = DateUtil.getNextCronDate((String)entity.getExecuteCronExpression(), null);
        entity.setNextRunTime(nextTime);
        this.taskService.updateById(entity);
    }

    @Override
    @Async
    public void connector(ContentModel model, String id, String token, String tenantId, String tenantDbConnectionString) {
        if (StringUtils.isNotEmpty((String)tenantId)) {
            DataSourceContextHolder.setDatasource((String)tenantId, (String)tenantDbConnectionString);
        }
        Date startDate = new Date();
        StringBuffer history = new StringBuffer();
        history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011\u3010\u6267\u884c\u5f00\u59cb\u3011 ");
        DataInterfaceEntity dataInterfaceEntity = this.dataInterfaceService.getInfo(model.getInterfaceId());
        if (dataInterfaceEntity != null) {
            boolean flag = this.callHTTP(dataInterfaceEntity, TimeServiceImpl.getUrl(model.getParameter()), token);
            history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011");
            history.append(flag ? "\u3010\u6267\u884c\u6210\u529f\u3011 " : "\u3010\u6267\u884c\u5931\u8d25:\u65e0\u63a5\u53e3\u3011");
            history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011\u3010\u6267\u884c\u7ed3\u675f\u3011");
            TimeTaskLogEntity baskLog = new TimeTaskLogEntity();
            baskLog.setId(RandomUtil.uuId());
            baskLog.setTaskId(id);
            baskLog.setRunTime(startDate);
            baskLog.setDescription(history.toString());
            baskLog.setRunResult(flag ? 0 : 1);
            this.taskLogService.save(baskLog);
            TimeTaskEntity entity = this.taskService.getInfo(id);
            int count = (int)this.taskLogService.getTaskLogCount(id);
            entity.setRunCount(count);
            entity.setLastModifyTime(startDate);
            entity.setLastRunTime(startDate);
            Date nextTime = DateUtil.getNextCronDate((String)entity.getExecuteCronExpression(), null);
            entity.setNextRunTime(nextTime);
            this.taskService.updateById(entity);
        }
    }

    @Override
    @Async
    public void localTask(ContentModel model, String id, String token, String tenantId, String tenantDbConnectionString, Map<String, Object> stringObjectMap) {
        Date startDate = new Date();
        StringBuffer history = new StringBuffer();
        history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011\u3010\u6267\u884c\u5f00\u59cb\u3011 ");
        if (this.concurrentHashMap.containsKey(model.getLocalHostTaskId())) {
            LocalTaskModel taskModel = this.concurrentHashMap.get(model.getLocalHostTaskId());
            boolean flag = ReflectionUtil.invokeMethodByTask((Object)taskModel.getClz(), (String)taskModel.getMethodName(), (Class[])taskModel.getParameterType(), ObjectUtil.isEmpty((Object)taskModel.getParameterType()) ? null : stringObjectMap);
            history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011");
            history.append(flag ? "\u3010\u6267\u884c\u6210\u529f\u3011 " : "\u3010\u6267\u884c\u5931\u8d25:\u65e0\u63a5\u53e3\u3011");
            history.append("\u3010" + DateUtil.getNow((String)"+8") + "\u3011\u3010\u6267\u884c\u7ed3\u675f\u3011");
            TimeTaskLogEntity baskLog = new TimeTaskLogEntity();
            baskLog.setId(RandomUtil.uuId());
            baskLog.setTaskId(id);
            baskLog.setRunTime(startDate);
            baskLog.setDescription(history.toString());
            baskLog.setRunResult(flag ? 0 : 1);
            this.taskLogService.save(baskLog);
            TimeTaskEntity entity = this.taskService.getInfo(id);
            int count = (int)this.taskLogService.getTaskLogCount(id);
            entity.setRunCount(count);
            entity.setLastModifyTime(startDate);
            entity.setLastRunTime(startDate);
            Date nextTime = DateUtil.getNextCronDate((String)entity.getExecuteCronExpression(), null);
            entity.setNextRunTime(nextTime);
            this.taskService.updateById(entity);
        }
    }

    public Boolean callHTTP(DataInterfaceEntity entity, Map<String, String> map, String token) {
        JSONObject jsonObject = new JSONObject();
        String path = entity.getPath();
        String requestMethod = entity.getRequestMethod();
        if (map != null) {
            if ("6".equals(requestMethod)) {
                path = !path.contains("?") ? (path = path + "?") : path + "&";
                path = this.parameterHandler(path, map);
                requestMethod = "GET";
            } else {
                for (String field : map.keySet()) {
                    jsonObject.put(field, (Object)map.get(field));
                }
                requestMethod = "POST";
            }
        }
        String jsonObjects = jsonObject != null ? jsonObject.toJSONString() : null;
        boolean flag = HttpUtil.httpCronRequest((String)path, (String)requestMethod, (String)jsonObjects, (String)token);
        return flag;
    }

    private String parameterHandler(String path, Map<String, String> map) {
        for (String field : map.keySet()) {
            try {
                String value = URLEncoder.encode(map.get(field), "UTF-8");
                path = path + field + "=" + value + "&";
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
        }
        return path;
    }

    private static Map<String, String> getUrl(List<TaskParameterModel> params) {
        HashedMap map = new HashedMap(16);
        try {
            for (TaskParameterModel model : params) {
                if (StringUtils.isNotEmpty((String)model.getValue())) {
                    map.put(model.getField(), model.getValue());
                    continue;
                }
                map.put(model.getField(), model.getDefaultValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("url\u9519\u8bef{}", (Object)e.getMessage());
        }
        return map;
    }

    private String systemParameter(String sql, UserInfo userInfo) {
        if (sql.contains("@user") && StringUtils.isNotEmpty((String)userInfo.getUserId())) {
            String userId = userInfo.getUserId();
            sql = sql.replaceAll("@user", "'" + userId + "'");
        }
        if (sql.contains("@department") && StringUtils.isNotEmpty((String)userInfo.getDepartmentId())) {
            String departmentId = userInfo.getDepartmentId();
            sql = sql.replaceAll("@department", "'" + departmentId + "'");
        }
        if (sql.contains("@organize") && StringUtils.isNotEmpty((String)userInfo.getOrganizeId())) {
            String organizeId = userInfo.getOrganizeId();
            sql = sql.replaceAll("@organize", "'" + organizeId + "'");
        }
        if (sql.contains("@postion") && StringUtils.isNotEmpty((Object[])userInfo.getPositionIds())) {
            String positionId = userInfo.getPositionIds() != null ? userInfo.getPositionIds()[0] : null;
            sql = sql.replaceAll("@postion", "'" + positionId + "'");
        }
        return sql;
    }
}

