/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasDeviceEntity;
import com.bringspring.logistics.model.basdevice.BasDeviceCrForm;
import com.bringspring.logistics.model.basdevice.BasDeviceInfoVO;
import com.bringspring.logistics.model.basdevice.BasDevicePagination;
import com.bringspring.logistics.model.basdevice.BasDeviceUpForm;
import com.bringspring.logistics.plugin.BasDevicePlugin;
import com.bringspring.logistics.plugin.BasDevicePluginServiceLocator;
import com.bringspring.logistics.service.BasDeviceSensorService;
import com.bringspring.logistics.service.BasDeviceService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u673a\u7535\u8bbe\u5907"}, value="example")
@RequestMapping(value={"/api/logistics/BasDevice"})
public class BasDeviceController {
    private static final Logger log = LoggerFactory.getLogger(BasDeviceController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BasDeviceService basDeviceService;
    @Autowired
    private BasDeviceSensorService basDeviceSensorService;
    @Autowired
    private BasDevicePluginServiceLocator basDevicePluginServiceLocator;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BasDevicePagination basDevicePagination) throws IOException {
        List<BasDeviceEntity> list = this.basDeviceService.getList(basDevicePagination);
        List listVO = JsonUtil.getJsonToList(list, BasDeviceCrForm.class);
        this.basDeviceService.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)basDevicePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid BasDeviceCrForm basDeviceCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        BasDeviceEntity entity = (BasDeviceEntity)JsonUtil.getJsonToBean((Object)basDeviceCrForm, BasDeviceEntity.class);
        BasDeviceEntity infoByCode = this.basDeviceService.getInfoByCode(entity.getDeviceCode());
        if (ObjectUtil.isEmpty((Object)infoByCode)) {
            entity.setId(mainId);
            entity.setDeleteMark(1);
            entity.setEnabledMark(1);
            this.basDeviceService.save(entity);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
        return ActionResult.success((String)"\u7f16\u7801\u91cd\u590d\uff0c\u521b\u5efa\u5931\u8d25\uff01");
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @Transactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BasDeviceInfoVO> info(@PathVariable(value="id") String id) {
        BasDeviceEntity entity = this.basDeviceService.getInfo(id);
        BasDeviceInfoVO vo = (BasDeviceInfoVO)JsonUtil.getJsonToBean((Object)entity, BasDeviceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getInfoByCode/{deviceCode}"})
    public ActionResult<BasDeviceInfoVO> getInfoByCode(@PathVariable(value="deviceCode") String deviceCode) {
        BasDeviceEntity entity = this.basDeviceService.getInfoByCode(deviceCode);
        BasDeviceInfoVO vo = (BasDeviceInfoVO)JsonUtil.getJsonToBean((Object)entity, BasDeviceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BasDeviceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BasDeviceEntity entity = this.basDeviceService.getInfo(id);
        BasDeviceInfoVO vo = (BasDeviceInfoVO)JsonUtil.getJsonToBean((Object)entity, BasDeviceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BasDeviceUpForm basDeviceUpForm) throws DataException {
        BasDeviceEntity entity = this.basDeviceService.getInfo(id);
        if (entity != null) {
            BasDeviceEntity subentity = (BasDeviceEntity)JsonUtil.getJsonToBean((Object)basDeviceUpForm, BasDeviceEntity.class);
            this.basDeviceService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        if (!ObjectUtil.isEmpty(this.basDeviceSensorService.getByDeviceId(id))) {
            return ActionResult.success((String)"\u6709\u4f20\u611f\u5668\u5173\u8054\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664");
        }
        String checkResultStr = "";
        Map<String, BasDevicePlugin> serviceLocatorAll = this.basDevicePluginServiceLocator.getAll();
        Set<Map.Entry<String, BasDevicePlugin>> entries = serviceLocatorAll.entrySet();
        for (Map.Entry<String, BasDevicePlugin> entry : entries) {
            String tempStr = entry.getValue().checkDeviceExistData(id);
            if (!StringUtils.isNotEmpty((CharSequence)tempStr)) continue;
            checkResultStr = checkResultStr + tempStr + "\uff0c";
        }
        if (StringUtils.isNotEmpty((CharSequence)checkResultStr)) {
            return ActionResult.fail((String)(checkResultStr + "\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        BasDeviceEntity entity = this.basDeviceService.getInfo(id);
        if (entity != null) {
            BasDeviceEntity subentity = new BasDeviceEntity();
            subentity.setDeleteMark(0);
            subentity.setEnabledMark(0);
            this.basDeviceService.update(id, subentity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

