/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasDeviceSensorEntity;
import com.bringspring.logistics.model.basdevicesensor.BasDeviceSensorCrForm;
import com.bringspring.logistics.model.basdevicesensor.BasDeviceSensorInfoVO;
import com.bringspring.logistics.model.basdevicesensor.BasDeviceSensorPagination;
import com.bringspring.logistics.model.basdevicesensor.BasDeviceSensorUpForm;
import com.bringspring.logistics.plugin.BasDeviceSensorPlugin;
import com.bringspring.logistics.plugin.BasDeviceSensorPluginServiceLocator;
import com.bringspring.logistics.service.BasDeviceSensorService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u673a\u7535\u8bbe\u5907\u4f20\u611f\u5668\u5bf9\u7167\u8868"}, value="logistics")
@RequestMapping(value={"/api/logistics/BasDeviceSensor"})
public class BasDeviceSensorController {
    private static final Logger log = LoggerFactory.getLogger(BasDeviceSensorController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BasDeviceSensorService basDeviceSensorService;
    @Autowired
    private BasDeviceSensorPluginServiceLocator basDeviceSensorPluginServiceLocator;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BasDeviceSensorPagination basDeviceSensorPagination) throws IOException {
        List<BasDeviceSensorEntity> list = this.basDeviceSensorService.getList(basDeviceSensorPagination);
        List listVO = JsonUtil.getJsonToList(list, BasDeviceSensorCrForm.class);
        this.basDeviceSensorService.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)basDeviceSensorPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid BasDeviceSensorUpForm basDeviceSensorCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        BasDeviceSensorEntity entity = (BasDeviceSensorEntity)JsonUtil.getJsonToBean((Object)basDeviceSensorCrForm, BasDeviceSensorEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(1);
        entity.setDeleteMark(1);
        this.basDeviceSensorService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BasDeviceSensorInfoVO> info(@PathVariable(value="id") String id) {
        BasDeviceSensorEntity entity = this.basDeviceSensorService.getInfo(id);
        BasDeviceSensorInfoVO vo = (BasDeviceSensorInfoVO)JsonUtil.getJsonToBean((Object)entity, BasDeviceSensorInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BasDeviceSensorInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BasDeviceSensorEntity entity = this.basDeviceSensorService.getInfo(id);
        BasDeviceSensorInfoVO vo = (BasDeviceSensorInfoVO)JsonUtil.getJsonToBean((Object)entity, BasDeviceSensorInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BasDeviceSensorUpForm basDeviceSensorUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        BasDeviceSensorEntity entity = this.basDeviceSensorService.getInfo(id);
        if (entity != null) {
            BasDeviceSensorEntity subentity = (BasDeviceSensorEntity)JsonUtil.getJsonToBean((Object)basDeviceSensorUpForm, BasDeviceSensorEntity.class);
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setLastModifyTime(new Date());
            this.basDeviceSensorService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        String checkResultStr = "";
        Map<String, BasDeviceSensorPlugin> serviceLocatorAll = this.basDeviceSensorPluginServiceLocator.getAll();
        Set<Map.Entry<String, BasDeviceSensorPlugin>> entries = serviceLocatorAll.entrySet();
        for (Map.Entry<String, BasDeviceSensorPlugin> entry : entries) {
            String tempStr = entry.getValue().checkDeviceSensorExistData(id);
            if (!StringUtils.isNotEmpty((CharSequence)tempStr)) continue;
            checkResultStr = checkResultStr + tempStr + "\uff0c";
        }
        if (StringUtils.isNotEmpty((CharSequence)checkResultStr)) {
            return ActionResult.fail((String)(checkResultStr + "\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        BasDeviceSensorEntity entity = this.basDeviceSensorService.getInfo(id);
        if (entity != null) {
            UserInfo userInfo = this.userProvider.get();
            entity.setDeleteUserId(userInfo.getUserId());
            entity.setDeleteTime(new Date());
            entity.setDeleteMark(0);
            this.basDeviceSensorService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

