/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasDeviceTypeEntity;
import com.bringspring.logistics.model.basdevicetype.BasDeviceTypeCrForm;
import com.bringspring.logistics.model.basdevicetype.BasDeviceTypeInfoVO;
import com.bringspring.logistics.model.basdevicetype.BasDeviceTypeListVO;
import com.bringspring.logistics.model.basdevicetype.BasDeviceTypePagination;
import com.bringspring.logistics.service.BasDeviceTypeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u673a\u7535\u8bbe\u5907\u7c7b\u578b"}, value="logistics")
@RequestMapping(value={"/api/logistics/BasDeviceType"})
public class BasDeviceTypeController {
    private static final Logger log = LoggerFactory.getLogger(BasDeviceTypeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BasDeviceTypeService basDeviceTypeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BasDeviceTypePagination basDeviceTypePagination) throws IOException {
        List<BasDeviceTypeEntity> list = this.basDeviceTypeService.getList(basDeviceTypePagination);
        List listVO = JsonUtil.getJsonToList(list, BasDeviceTypeListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)basDeviceTypePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getListTree"})
    public ActionResult getListTree(@RequestParam String parentId) {
        List<BasDeviceTypeCrForm> listVO = this.basDeviceTypeService.getListTree(parentId);
        return ActionResult.success(listVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid BasDeviceTypeCrForm basDeviceTypeCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        BasDeviceTypeEntity entity = (BasDeviceTypeEntity)JsonUtil.getJsonToBean((Object)basDeviceTypeCrForm, BasDeviceTypeEntity.class);
        entity.setId(mainId);
        entity.setDeleteMark(1);
        entity.setEnabledMark(1);
        this.basDeviceTypeService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BasDeviceTypeCrForm> info(@PathVariable(value="id") String id) {
        BasDeviceTypeEntity entity = this.basDeviceTypeService.getInfo(id);
        BasDeviceTypeCrForm vo = (BasDeviceTypeCrForm)JsonUtil.getJsonToBean((Object)entity, BasDeviceTypeCrForm.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BasDeviceTypeInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BasDeviceTypeEntity entity = this.basDeviceTypeService.getInfo(id);
        BasDeviceTypeInfoVO vo = (BasDeviceTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, BasDeviceTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BasDeviceTypeCrForm basDeviceTypeUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        BasDeviceTypeEntity entity = this.basDeviceTypeService.getInfo(id);
        if (entity != null) {
            BasDeviceTypeEntity subentity = (BasDeviceTypeEntity)JsonUtil.getJsonToBean((Object)basDeviceTypeUpForm, BasDeviceTypeEntity.class);
            this.basDeviceTypeService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        BasDeviceTypeEntity entity = this.basDeviceTypeService.getInfo(id);
        if (entity != null) {
            BasDeviceTypeEntity subentity = new BasDeviceTypeEntity();
            subentity.setDeleteMark(0);
            subentity.setEnabledMark(0);
            this.basDeviceTypeService.update(id, subentity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

