/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasSensorEntity;
import com.bringspring.logistics.model.bassensor.BasSensorCrForm;
import com.bringspring.logistics.model.bassensor.BasSensorInfoVO;
import com.bringspring.logistics.model.bassensor.BasSensorPagination;
import com.bringspring.logistics.model.bassensor.BasSensorUpForm;
import com.bringspring.logistics.service.BasDeviceSensorService;
import com.bringspring.logistics.service.BasSensorService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f20\u611f\u5668"}, value="logistics")
@RequestMapping(value={"/api/logistics/BasSensor"})
public class BasSensorController {
    private static final Logger log = LoggerFactory.getLogger(BasSensorController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BasSensorService basSensorService;
    @Autowired
    private BasDeviceSensorService basDeviceSensorService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BasSensorPagination basSensorPagination) throws IOException {
        List<BasSensorEntity> list = this.basSensorService.getList(basSensorPagination);
        List listVO = JsonUtil.getJsonToList(list, BasSensorCrForm.class);
        this.basSensorService.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)basSensorPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid BasSensorUpForm basSensorCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        BasSensorEntity entity = (BasSensorEntity)JsonUtil.getJsonToBean((Object)basSensorCrForm, BasSensorEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(1);
        entity.setDeleteMark(1);
        this.basSensorService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BasSensorInfoVO> info(@PathVariable(value="id") String id) {
        BasSensorEntity entity = this.basSensorService.getInfo(id);
        BasSensorInfoVO vo = (BasSensorInfoVO)JsonUtil.getJsonToBean((Object)entity, BasSensorInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BasSensorInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BasSensorEntity entity = this.basSensorService.getInfo(id);
        BasSensorInfoVO vo = (BasSensorInfoVO)JsonUtil.getJsonToBean((Object)entity, BasSensorInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BasSensorUpForm basSensorUpForm) throws DataException {
        BasSensorEntity entity = this.basSensorService.getInfo(id);
        if (entity != null) {
            BasSensorEntity subentity = (BasSensorEntity)JsonUtil.getJsonToBean((Object)basSensorUpForm, BasSensorEntity.class);
            this.basSensorService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        if (!ObjectUtil.isEmpty(this.basDeviceSensorService.getBySensorId(id))) {
            return ActionResult.success((String)"\u6709\u8bbe\u5907\u5173\u8054\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664");
        }
        BasSensorEntity entity = this.basSensorService.getInfo(id);
        if (entity != null) {
            entity.setDeleteMark(0);
            this.basSensorService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

