/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasSensorTypeEntity;
import com.bringspring.logistics.model.bassensortype.BasSensorTypeCrForm;
import com.bringspring.logistics.model.bassensortype.BasSensorTypeInfoVO;
import com.bringspring.logistics.model.bassensortype.BasSensorTypeListVO;
import com.bringspring.logistics.model.bassensortype.BasSensorTypePagination;
import com.bringspring.logistics.model.bassensortype.BasSensorTypeUpForm;
import com.bringspring.logistics.service.BasSensorTypeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f20\u611f\u5668\u7c7b\u578b"}, value="logistics")
@RequestMapping(value={"/api/logistics/BasSensorType"})
public class BasSensorTypeController {
    private static final Logger log = LoggerFactory.getLogger(BasSensorTypeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BasSensorTypeService basSensorTypeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BasSensorTypePagination basSensorTypePagination) throws IOException {
        List<BasSensorTypeEntity> list = this.basSensorTypeService.getList(basSensorTypePagination);
        for (BasSensorTypeEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, BasSensorTypeListVO.class);
        for (BasSensorTypeListVO basSensorTypeListVO : listVO) {
        }
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid BasSensorTypeCrForm basSensorTypeCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        BasSensorTypeEntity entity = (BasSensorTypeEntity)JsonUtil.getJsonToBean((Object)basSensorTypeCrForm, BasSensorTypeEntity.class);
        entity.setId(mainId);
        entity.setDeleteMark(1);
        entity.setEnabledMark(1);
        this.basSensorTypeService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BasSensorTypeInfoVO> info(@PathVariable(value="id") String id) {
        BasSensorTypeEntity entity = this.basSensorTypeService.getInfo(id);
        BasSensorTypeInfoVO vo = (BasSensorTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, BasSensorTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BasSensorTypeInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BasSensorTypeEntity entity = this.basSensorTypeService.getInfo(id);
        BasSensorTypeInfoVO vo = (BasSensorTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, BasSensorTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BasSensorTypeUpForm basSensorTypeUpForm) throws DataException {
        BasSensorTypeEntity entity = this.basSensorTypeService.getInfo(id);
        if (entity != null) {
            BasSensorTypeEntity subentity = (BasSensorTypeEntity)JsonUtil.getJsonToBean((Object)basSensorTypeUpForm, BasSensorTypeEntity.class);
            this.basSensorTypeService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        BasSensorTypeEntity entity = this.basSensorTypeService.getInfo(id);
        if (entity != null) {
            entity.setDeleteMark(0);
            this.basSensorTypeService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

