/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.logistics.entity.BasSpaceEntity;
import com.bringspring.logistics.model.basspace.BasSpaceCrForm;
import com.bringspring.logistics.model.basspace.BasSpaceInfoVO;
import com.bringspring.logistics.model.basspace.BasSpaceListVO;
import com.bringspring.logistics.model.basspace.BasSpacePagination;
import com.bringspring.logistics.model.basspace.BasSpaceUpForm;
import com.bringspring.logistics.model.basspace.BaseSpaceModel;
import com.bringspring.logistics.model.basspace.BaseSpaceSelector;
import com.bringspring.logistics.plugin.BasSpacePlugin;
import com.bringspring.logistics.plugin.BasSpacePluginServiceLocator;
import com.bringspring.logistics.service.BasDeviceService;
import com.bringspring.logistics.service.BasSpaceService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7a7a\u95f4\u4fe1\u606f"}, value="logistics")
@RequestMapping(value={"/api/logistics/BasSpace"})
public class BasSpaceController {
    private static final Logger log = LoggerFactory.getLogger(BasSpaceController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BasSpaceService basSpaceService;
    @Autowired
    private BasDeviceService basDeviceService;
    @Autowired
    private BasSpacePluginServiceLocator basSpacePluginServiceLocator;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BasSpacePagination basSpacePagination) throws IOException {
        List<BasSpaceEntity> list = this.basSpaceService.getList(basSpacePagination);
        List listVO = JsonUtil.getJsonToList(list, BasSpaceListVO.class);
        for (BasSpaceListVO vo : listVO) {
            BasSpaceEntity info = this.basSpaceService.getInfo(vo.getParentId());
            if (StringUtils.isNotEmpty((String)vo.getParentId()) && ObjectUtil.isNotEmpty((Object)info)) {
                vo.setParentId(info.getSpaceName());
            }
            vo.setSpaceType(this.baseDataUtil.getDictName(vo.getSpaceType(), "SpaceType"));
            vo.setCompanyId(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            vo.setOrgId(this.baseDataUtil.comSelectValues(vo.getOrgId()));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
            vo.setDeleteMark(this.baseDataUtil.switchSelectValue(vo.getDeleteMark(), "\u6b63\u5e38", "\u5220\u9664"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)basSpacePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getListAll"})
    public ActionResult getListAll() {
        List<BasSpaceEntity> listVO = this.basSpaceService.getListAll();
        return ActionResult.success(listVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u4ea7\u5206\u7c7b\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<BaseSpaceSelector>> getSelector(BasSpacePagination query) {
        List<BasSpaceEntity> allList = this.basSpaceService.getListAll(query);
        List data = allList.stream().filter(t -> EnabledMarkEnum.ENABLE.getCode() == t.getEnabledMark()).collect(Collectors.toList());
        List models = JsonUtil.getJsonToList(data, BaseSpaceModel.class);
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, BaseSpaceSelector.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getListTree"})
    public ActionResult getListTree(@RequestParam String parentId, @RequestParam String menuId) {
        if (StringUtils.isEmpty((String)menuId)) {
            return ActionResult.success(new ArrayList());
        }
        List<BasSpaceInfoVO> listVO = this.basSpaceService.getListTree(parentId, menuId);
        return ActionResult.success(listVO);
    }

    @GetMapping(value={"/getChildListTree"})
    public ActionResult getChildListTree(@RequestParam String parentId) {
        List<BasSpaceInfoVO> listVO = this.basSpaceService.getChildListTree(parentId);
        return ActionResult.success(listVO);
    }

    @GetMapping(value={"/getSpaceAndParentListByOrg"})
    public ActionResult getSpaceAndParentListByOrg(@RequestParam String orgId) {
        List<BasSpaceInfoVO> listVO = this.basSpaceService.getSpaceAndParentListByOrg(orgId);
        return ActionResult.success(listVO);
    }

    @GetMapping(value={"/getSpaceAndParentListByIds/{ids}"})
    public ActionResult getSpaceAndParentListByIds(@PathVariable String[] ids) {
        List<BasSpaceInfoVO> listVO = this.basSpaceService.getSpaceAndParentListByIds(ids);
        return ActionResult.success(listVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid BasSpaceCrForm basSpaceCrForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u5efa\u5931\u8d25");
        }
        this.basSpaceService.create(basSpaceCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BasSpaceInfoVO> info(@PathVariable(value="id") String id) {
        BasSpaceEntity entity = this.basSpaceService.getInfo(id);
        BasSpaceInfoVO vo = (BasSpaceInfoVO)JsonUtil.getJsonToBean((Object)entity, BasSpaceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BasSpaceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BasSpaceEntity entity = this.basSpaceService.getInfo(id);
        BasSpaceInfoVO vo = (BasSpaceInfoVO)JsonUtil.getJsonToBean((Object)entity, BasSpaceInfoVO.class);
        vo.setSpaceType(this.baseDataUtil.getDictName(vo.getSpaceType(), "SpaceType"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BasSpaceUpForm basSpaceUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        BasSpaceEntity entity = this.basSpaceService.getInfo(id);
        if (entity != null) {
            this.basSpaceService.update(id, basSpaceUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25");
        }
        if (this.basSpaceService.selectSpaceCount(id) > 0L) {
            return ActionResult.fail((String)"\u5b58\u5728\u4e0b\u7ea7\u7a7a\u95f4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (this.basDeviceService.selectDeviceBySpaceIdCount(id) > 0L) {
            return ActionResult.fail((String)"\u5b58\u5728\u5173\u8054\u8bbe\u5907\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        String checkResultStr = "";
        Map<String, BasSpacePlugin> serviceLocatorAll = this.basSpacePluginServiceLocator.getAll();
        Set<Map.Entry<String, BasSpacePlugin>> entries = serviceLocatorAll.entrySet();
        for (Map.Entry<String, BasSpacePlugin> entry : entries) {
            String tempStr = entry.getValue().checkSpaceExistData(id);
            if (!StringUtils.isNotEmpty((String)tempStr)) continue;
            checkResultStr = checkResultStr + tempStr + "\uff0c";
        }
        if (StringUtils.isNotEmpty((String)checkResultStr)) {
            return ActionResult.fail((String)(checkResultStr + "\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        BasSpaceEntity entity = this.basSpaceService.getInfo(id);
        if (ObjectUtil.isNotEmpty((Object)entity)) {
            this.basSpaceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getUserSpace"})
    public ActionResult<String> getUserSpace() {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        String departmentId = userInfo.getDepartmentId();
        List<BasSpaceEntity> listByOrg = this.basSpaceService.getListByOrg(departmentId);
        String orgName = listByOrg.stream().map(item -> item.getSpaceName()).collect(Collectors.joining("/"));
        return ActionResult.success((String)orgName);
    }
}

