/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.logistics.entity.DatDeviceDatasEntity;
import com.bringspring.logistics.model.datdevicedatas.DatDeviceDatasCrForm;
import com.bringspring.logistics.model.datdevicedatas.DatDeviceDatasInfoVO;
import com.bringspring.logistics.model.datdevicedatas.DatDeviceDatasListVO;
import com.bringspring.logistics.model.datdevicedatas.DatDeviceDatasPagination;
import com.bringspring.logistics.model.datdevicedatas.DatDeviceDatasPaginationExportModel;
import com.bringspring.logistics.model.datdevicedatas.DatDeviceDatasUpForm;
import com.bringspring.logistics.service.DatDeviceDatasService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u5907\u4f20\u611f\u5668\u6570\u636e\uff08\u65e5\u6570\u636e\uff09"}, value="logistics")
@RequestMapping(value={"/api/logistics/DatDeviceDatas"})
public class DatDeviceDatasController {
    private static final Logger log = LoggerFactory.getLogger(DatDeviceDatasController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DatDeviceDatasService datDeviceDatasService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DatDeviceDatasPagination datDeviceDatasPagination) throws IOException {
        List<DatDeviceDatasEntity> list = this.datDeviceDatasService.getList(datDeviceDatasPagination);
        for (DatDeviceDatasEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, DatDeviceDatasListVO.class);
        for (DatDeviceDatasListVO datDeviceDatasListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)datDeviceDatasPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid DatDeviceDatasCrForm datDeviceDatasCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        DatDeviceDatasEntity entity = (DatDeviceDatasEntity)JsonUtil.getJsonToBean((Object)datDeviceDatasCrForm, DatDeviceDatasEntity.class);
        entity.setId(mainId);
        this.datDeviceDatasService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(DatDeviceDatasPaginationExportModel datDeviceDatasPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)datDeviceDatasPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DatDeviceDatasPagination datDeviceDatasPagination = (DatDeviceDatasPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)datDeviceDatasPaginationExportModel), DatDeviceDatasPagination.class));
        List<DatDeviceDatasEntity> list = this.datDeviceDatasService.getTypeList(datDeviceDatasPagination, datDeviceDatasPaginationExportModel.getDataType());
        for (DatDeviceDatasEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, DatDeviceDatasListVO.class);
        for (DatDeviceDatasListVO datDeviceDatasListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)datDeviceDatasPaginationExportModel.getSelectKey()) ? datDeviceDatasPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block28: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "sysId": {
                        entitys.add(new ExcelExportEntity("\u7cfb\u7edfID", (Object)"sysId"));
                        continue block28;
                    }
                    case "deviceId": {
                        entitys.add(new ExcelExportEntity("\u673a\u7535\u8bbe\u5907ID", (Object)"deviceId"));
                        continue block28;
                    }
                    case "sensorId": {
                        entitys.add(new ExcelExportEntity("\u4f20\u611f\u5668ID", (Object)"sensorId"));
                        continue block28;
                    }
                    case "datasTime": {
                        entitys.add(new ExcelExportEntity("\u6570\u636e\u751f\u6210\u65f6\u95f4", (Object)"datasTime"));
                        continue block28;
                    }
                    case "datasCheckCode": {
                        entitys.add(new ExcelExportEntity("\u6821\u9a8c\u7801", (Object)"datasCheckCode"));
                        continue block28;
                    }
                    case "DatasJson": {
                        entitys.add(new ExcelExportEntity("\u91c7\u96c6\u6570\u636e\u96c6", (Object)"DatasJson"));
                        continue block28;
                    }
                    case "datasFrom": {
                        entitys.add(new ExcelExportEntity("\u6570\u636e\u6765\u6e90", (Object)"datasFrom"));
                        continue block28;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block28;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @Transactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DatDeviceDatasInfoVO> info(@PathVariable(value="id") String id) {
        DatDeviceDatasEntity entity = this.datDeviceDatasService.getInfo(id);
        DatDeviceDatasInfoVO vo = (DatDeviceDatasInfoVO)JsonUtil.getJsonToBean((Object)entity, DatDeviceDatasInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DatDeviceDatasInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DatDeviceDatasEntity entity = this.datDeviceDatasService.getInfo(id);
        DatDeviceDatasInfoVO vo = (DatDeviceDatasInfoVO)JsonUtil.getJsonToBean((Object)entity, DatDeviceDatasInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DatDeviceDatasUpForm datDeviceDatasUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DatDeviceDatasEntity entity = this.datDeviceDatasService.getInfo(id);
        if (entity != null) {
            DatDeviceDatasEntity subentity = (DatDeviceDatasEntity)JsonUtil.getJsonToBean((Object)datDeviceDatasUpForm, DatDeviceDatasEntity.class);
            this.datDeviceDatasService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DatDeviceDatasEntity entity = this.datDeviceDatasService.getInfo(id);
        if (entity != null) {
            this.datDeviceDatasService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

