/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasDeviceEntity;
import com.bringspring.logistics.entity.BasDeviceSensorEntity;
import com.bringspring.logistics.entity.BasSensorEntity;
import com.bringspring.logistics.mapper.BasDeviceSensorMapper;
import com.bringspring.logistics.model.basdevicesensor.BasDeviceSensorCrForm;
import com.bringspring.logistics.model.basdevicesensor.BasDeviceSensorPagination;
import com.bringspring.logistics.service.BasDeviceSensorService;
import com.bringspring.logistics.service.BasDeviceService;
import com.bringspring.logistics.service.BasSensorService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasDeviceSensorServiceImpl
extends ServiceImpl<BasDeviceSensorMapper, BasDeviceSensorEntity>
implements BasDeviceSensorService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BasDeviceService basDeviceService;
    @Autowired
    private BasSensorService basSensorService;
    @Autowired
    private UserService userService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<BasDeviceSensorEntity> getList(BasDeviceSensorPagination basDeviceSensorPagination) {
        Object basDeviceSensorObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int basDeviceSensorNum = 0;
        QueryWrapper basDeviceSensorQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basDeviceSensorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceSensorQueryWrapper, basDeviceSensorPagination.getMenuId(), "basDeviceSensor"));
            if (ObjectUtil.isEmpty((Object)basDeviceSensorObj)) {
                return new ArrayList<BasDeviceSensorEntity>();
            }
            basDeviceSensorQueryWrapper = (QueryWrapper)basDeviceSensorObj;
            ++basDeviceSensorNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basDeviceSensorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceSensorQueryWrapper, basDeviceSensorPagination.getMenuId(), "basDeviceSensor"));
            if (ObjectUtil.isEmpty((Object)basDeviceSensorObj)) {
                return new ArrayList<BasDeviceSensorEntity>();
            }
            basDeviceSensorQueryWrapper = (QueryWrapper)basDeviceSensorObj;
            ++basDeviceSensorNum;
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getDeviceId())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getDeviceId, (Object)basDeviceSensorPagination.getDeviceId());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getSensorId())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getSensorId, (Object)basDeviceSensorPagination.getSensorId());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getDeviceSensorState())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getDeviceSensorState, (Object)basDeviceSensorPagination.getDeviceSensorState());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getDescription())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getDescription, (Object)basDeviceSensorPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getCreatorUserId())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getCreatorUserId, (Object)basDeviceSensorPagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getCreatorTime())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getCreatorTime, (Object)basDeviceSensorPagination.getCreatorTime());
        }
        ((LambdaQueryWrapper)basDeviceSensorQueryWrapper.lambda().eq(BasDeviceSensorEntity::getDeleteMark, (Object)1)).eq(BasDeviceSensorEntity::getEnabledMark, (Object)1);
        if (AllIdList.size() > 0) {
            basDeviceSensorQueryWrapper.lambda().in(BasDeviceSensorEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)basDeviceSensorPagination.getSidx())) {
            basDeviceSensorQueryWrapper.lambda().orderByDesc(BasDeviceSensorEntity::getCreatorTime);
        } else {
            try {
                String sidx = basDeviceSensorPagination.getSidx();
                BasDeviceSensorEntity basDeviceSensorEntity = new BasDeviceSensorEntity();
                Field declaredField = basDeviceSensorEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                basDeviceSensorQueryWrapper = "asc".equals(basDeviceSensorPagination.getSort().toLowerCase()) ? (QueryWrapper)basDeviceSensorQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)basDeviceSensorQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(basDeviceSensorPagination.getCurrentPage(), basDeviceSensorPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)basDeviceSensorQueryWrapper);
            return basDeviceSensorPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return basDeviceSensorPagination.setData(list, list.size());
    }

    @Override
    public void selectValues(List<BasDeviceSensorCrForm> outputVo) {
        if (ObjectUtil.isNull(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            BasSensorEntity infoSensor;
            BasDeviceEntity info = this.basDeviceService.getInfo(item.getDeviceId());
            if (!ObjectUtil.isEmpty((Object)info)) {
                item.setDeviceName(info.getDeviceName());
            }
            if (!ObjectUtil.isEmpty((Object)(infoSensor = this.basSensorService.getInfo(item.getSensorId())))) {
                item.setSensorName(infoSensor.getSensorName());
            }
            item.setDeviceSensorStateName(this.baseDataUtil.getDictName(item.getDeviceSensorState(), "420510226672788549"));
            UserEntity infoUser = this.userService.getInfo(item.getCreatorUserId());
            if (!ObjectUtil.isEmpty((Object)infoUser)) {
                item.setCreatorUserName(infoUser.getRealName());
            }
            item.setCreatorTimeFormat(ObjectUtil.isNull((Object)item.getCreatorTime()) ? null : DateUtil.daFormat((Long)item.getCreatorTime()));
            item.setLastModifyTimeFormat(ObjectUtil.isNull((Object)item.getLastModifyTime()) ? null : DateUtil.daFormat((Long)item.getLastModifyTime()));
        });
    }

    @Override
    public List<BasDeviceSensorEntity> getTypeList(BasDeviceSensorPagination basDeviceSensorPagination, String dataType) {
        Object basDeviceSensorObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int basDeviceSensorNum = 0;
        QueryWrapper basDeviceSensorQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basDeviceSensorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceSensorQueryWrapper, basDeviceSensorPagination.getMenuId(), "basDeviceSensor"));
            if (ObjectUtil.isEmpty((Object)basDeviceSensorObj)) {
                return new ArrayList<BasDeviceSensorEntity>();
            }
            basDeviceSensorQueryWrapper = (QueryWrapper)basDeviceSensorObj;
            ++basDeviceSensorNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basDeviceSensorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceSensorQueryWrapper, basDeviceSensorPagination.getMenuId(), "basDeviceSensor"));
            if (ObjectUtil.isEmpty((Object)basDeviceSensorObj)) {
                return new ArrayList<BasDeviceSensorEntity>();
            }
            basDeviceSensorQueryWrapper = (QueryWrapper)basDeviceSensorObj;
            ++basDeviceSensorNum;
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getDeviceId())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getDeviceId, (Object)basDeviceSensorPagination.getDeviceId());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getSensorId())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getSensorId, (Object)basDeviceSensorPagination.getSensorId());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getDeviceSensorState())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getDeviceSensorState, (Object)basDeviceSensorPagination.getDeviceSensorState());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getDescription())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getDescription, (Object)basDeviceSensorPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getCreatorUserId())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getCreatorUserId, (Object)basDeviceSensorPagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty((String)basDeviceSensorPagination.getCreatorTime())) {
            ++basDeviceSensorNum;
            basDeviceSensorQueryWrapper.lambda().like(BasDeviceSensorEntity::getCreatorTime, (Object)basDeviceSensorPagination.getCreatorTime());
        }
        if (AllIdList.size() > 0) {
            basDeviceSensorQueryWrapper.lambda().in(BasDeviceSensorEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)basDeviceSensorPagination.getSidx())) {
            basDeviceSensorQueryWrapper.lambda().orderByDesc(BasDeviceSensorEntity::getCreatorTime);
        } else {
            try {
                String sidx = basDeviceSensorPagination.getSidx();
                BasDeviceSensorEntity basDeviceSensorEntity = new BasDeviceSensorEntity();
                Field declaredField = basDeviceSensorEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                basDeviceSensorQueryWrapper = "asc".equals(basDeviceSensorPagination.getSort().toLowerCase()) ? (QueryWrapper)basDeviceSensorQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)basDeviceSensorQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(basDeviceSensorPagination.getCurrentPage(), basDeviceSensorPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)basDeviceSensorQueryWrapper);
                return basDeviceSensorPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return basDeviceSensorPagination.setData(list, list.size());
        }
        return this.list((Wrapper)basDeviceSensorQueryWrapper);
    }

    @Override
    public BasDeviceSensorEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasDeviceSensorEntity::getId, (Object)id);
        return (BasDeviceSensorEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<BasDeviceSensorEntity> getByDeviceId(String deviceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasDeviceSensorEntity::getDeviceId, (Object)deviceId);
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BasDeviceSensorEntity::getDeleteMark, (Object)1)).eq(BasDeviceSensorEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<BasDeviceSensorEntity> getBySensorId(String sensorId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasDeviceSensorEntity::getSensorId, (Object)sensorId);
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BasDeviceSensorEntity::getDeleteMark, (Object)1)).eq(BasDeviceSensorEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(BasDeviceSensorEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, BasDeviceSensorEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(BasDeviceSensorEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

