/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasDeviceEntity;
import com.bringspring.logistics.entity.BasDeviceTypeEntity;
import com.bringspring.logistics.entity.BasSpaceEntity;
import com.bringspring.logistics.mapper.BasDeviceMapper;
import com.bringspring.logistics.model.basdevice.BasDeviceCrForm;
import com.bringspring.logistics.model.basdevice.BasDevicePagination;
import com.bringspring.logistics.service.BasDeviceService;
import com.bringspring.logistics.service.BasDeviceTypeService;
import com.bringspring.logistics.service.BasSpaceService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasDeviceServiceImpl
extends ServiceImpl<BasDeviceMapper, BasDeviceEntity>
implements BasDeviceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BasDeviceTypeService basDeviceTypeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private BasSpaceService basSpaceService;
    @Autowired
    private UserService userService;

    @Override
    public List<BasDeviceEntity> getList(BasDevicePagination basDevicePagination) {
        Object basDeviceTypeObj;
        Object basDeviceAlertObj;
        Object basDeviceObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int basDeviceNum = 0;
        QueryWrapper basDeviceQueryWrapper = new QueryWrapper();
        int basDeviceAlertNum = 0;
        QueryWrapper basDeviceAlertQueryWrapper = new QueryWrapper();
        int basDeviceTypeNum = 0;
        QueryWrapper basDeviceTypeQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basDeviceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceQueryWrapper, basDevicePagination.getMenuId(), "basDevice"));
            if (ObjectUtil.isEmpty((Object)basDeviceObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceQueryWrapper = (QueryWrapper)basDeviceObj;
            ++basDeviceNum;
            basDeviceAlertObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceAlertQueryWrapper, basDevicePagination.getMenuId(), "basDeviceAlert"));
            if (ObjectUtil.isEmpty((Object)basDeviceAlertObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceAlertQueryWrapper = (QueryWrapper)basDeviceAlertObj;
            ++basDeviceAlertNum;
            basDeviceTypeObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceTypeQueryWrapper, basDevicePagination.getMenuId(), "basDeviceType"));
            if (ObjectUtil.isEmpty((Object)basDeviceTypeObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceTypeQueryWrapper = (QueryWrapper)basDeviceTypeObj;
            ++basDeviceTypeNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basDeviceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceQueryWrapper, basDevicePagination.getMenuId(), "basDevice"));
            if (ObjectUtil.isEmpty((Object)basDeviceObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceQueryWrapper = (QueryWrapper)basDeviceObj;
            ++basDeviceNum;
            basDeviceAlertObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceAlertQueryWrapper, basDevicePagination.getMenuId(), "basDeviceAlert"));
            if (ObjectUtil.isEmpty((Object)basDeviceAlertObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceAlertQueryWrapper = (QueryWrapper)basDeviceAlertObj;
            ++basDeviceAlertNum;
            basDeviceTypeObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceTypeQueryWrapper, basDevicePagination.getMenuId(), "basDeviceType"));
            if (ObjectUtil.isEmpty((Object)basDeviceTypeObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceTypeQueryWrapper = (QueryWrapper)basDeviceTypeObj;
            ++basDeviceTypeNum;
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getDeviceTypeId())) {
            ArrayList<String> listTreeId = new ArrayList<String>();
            listTreeId.add(basDevicePagination.getDeviceTypeId());
            listTreeId.addAll(this.basDeviceTypeService.getListTreeId(basDevicePagination.getDeviceTypeId()));
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().in(BasDeviceEntity::getDeviceTypeId, listTreeId);
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getDeviceCode())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().eq(BasDeviceEntity::getDeviceCode, (Object)basDevicePagination.getDeviceCode());
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getSpaceId())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().like(BasDeviceEntity::getSpaceId, (Object)basDevicePagination.getSpaceId());
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getDeviceName())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().like(BasDeviceEntity::getDeviceName, (Object)basDevicePagination.getDeviceName());
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getDeviceLocation())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().like(BasDeviceEntity::getDeviceLocation, (Object)basDevicePagination.getDeviceLocation());
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getDescription())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().like(BasDeviceEntity::getDescription, (Object)basDevicePagination.getDescription());
        }
        ((LambdaQueryWrapper)basDeviceQueryWrapper.lambda().eq(BasDeviceEntity::getEnabledMark, (Object)1)).eq(BasDeviceEntity::getDeleteMark, (Object)1);
        if (AllIdList.size() > 0) {
            basDeviceQueryWrapper.lambda().in(BasDeviceEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)basDevicePagination.getSidx())) {
            basDeviceQueryWrapper.lambda().orderByDesc(BasDeviceEntity::getCreatorTime);
        } else {
            try {
                String sidx = basDevicePagination.getSidx();
                BasDeviceEntity basDeviceEntity = new BasDeviceEntity();
                Field declaredField = basDeviceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                basDeviceQueryWrapper = "asc".equals(basDevicePagination.getSort().toLowerCase()) ? (QueryWrapper)basDeviceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)basDeviceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(basDevicePagination.getCurrentPage(), basDevicePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)basDeviceQueryWrapper);
            return basDevicePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return basDevicePagination.setData(list, list.size());
    }

    @Override
    public void selectValues(List<BasDeviceCrForm> outputVo) {
        if (ObjectUtil.isNull(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            UserEntity infoUser;
            BasSpaceEntity infoSpace;
            BasDeviceTypeEntity info = this.basDeviceTypeService.getInfo(item.getDeviceTypeId());
            if (!ObjectUtil.isEmpty((Object)info)) {
                item.setDeviceTypeName(info.getDeviceTypeName());
            }
            if (!ObjectUtil.isEmpty((Object)(infoSpace = this.basSpaceService.getInfo(item.getSpaceId())))) {
                item.setSpaceName(infoSpace.getSpaceName());
            }
            if (!ObjectUtil.isEmpty((Object)(infoUser = this.userService.getInfo(item.getCreatorUserId())))) {
                item.setCreatorUserName(infoUser.getRealName());
            }
            item.setCreatorTimeFormat(ObjectUtil.isNull((Object)item.getCreatorTime()) ? null : DateUtil.daFormat((Long)item.getCreatorTime()));
            item.setLastModifyTimeFormat(ObjectUtil.isNull((Object)item.getLastModifyTime()) ? null : DateUtil.daFormat((Long)item.getLastModifyTime()));
        });
    }

    @Override
    public List<BasDeviceEntity> getTypeList(BasDevicePagination basDevicePagination, String dataType) {
        Object basDeviceTypeObj;
        Object basDeviceAlertObj;
        Object basDeviceObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int basDeviceNum = 0;
        QueryWrapper basDeviceQueryWrapper = new QueryWrapper();
        int basDeviceAlertNum = 0;
        QueryWrapper basDeviceAlertQueryWrapper = new QueryWrapper();
        int basDeviceTypeNum = 0;
        QueryWrapper basDeviceTypeQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basDeviceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceQueryWrapper, basDevicePagination.getMenuId(), "basDevice"));
            if (ObjectUtil.isEmpty((Object)basDeviceObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceQueryWrapper = (QueryWrapper)basDeviceObj;
            ++basDeviceNum;
            basDeviceAlertObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceAlertQueryWrapper, basDevicePagination.getMenuId(), "basDeviceAlert"));
            if (ObjectUtil.isEmpty((Object)basDeviceAlertObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceAlertQueryWrapper = (QueryWrapper)basDeviceAlertObj;
            ++basDeviceAlertNum;
            basDeviceTypeObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceTypeQueryWrapper, basDevicePagination.getMenuId(), "basDeviceType"));
            if (ObjectUtil.isEmpty((Object)basDeviceTypeObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceTypeQueryWrapper = (QueryWrapper)basDeviceTypeObj;
            ++basDeviceTypeNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basDeviceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceQueryWrapper, basDevicePagination.getMenuId(), "basDevice"));
            if (ObjectUtil.isEmpty((Object)basDeviceObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceQueryWrapper = (QueryWrapper)basDeviceObj;
            ++basDeviceNum;
            basDeviceAlertObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceAlertQueryWrapper, basDevicePagination.getMenuId(), "basDeviceAlert"));
            if (ObjectUtil.isEmpty((Object)basDeviceAlertObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceAlertQueryWrapper = (QueryWrapper)basDeviceAlertObj;
            ++basDeviceAlertNum;
            basDeviceTypeObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basDeviceTypeQueryWrapper, basDevicePagination.getMenuId(), "basDeviceType"));
            if (ObjectUtil.isEmpty((Object)basDeviceTypeObj)) {
                return new ArrayList<BasDeviceEntity>();
            }
            basDeviceTypeQueryWrapper = (QueryWrapper)basDeviceTypeObj;
            ++basDeviceTypeNum;
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getDeviceTypeId())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().like(BasDeviceEntity::getDeviceTypeId, (Object)basDevicePagination.getDeviceTypeId());
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getSpaceId())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().like(BasDeviceEntity::getSpaceId, (Object)basDevicePagination.getSpaceId());
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getDeviceName())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().like(BasDeviceEntity::getDeviceName, (Object)basDevicePagination.getDeviceName());
        }
        if (StringUtils.isNotEmpty((String)basDevicePagination.getDeviceLocation())) {
            ++basDeviceNum;
            basDeviceQueryWrapper.lambda().like(BasDeviceEntity::getDeviceLocation, (Object)basDevicePagination.getDeviceLocation());
        }
        if (AllIdList.size() > 0) {
            basDeviceQueryWrapper.lambda().in(BasDeviceEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)basDevicePagination.getSidx())) {
            basDeviceQueryWrapper.lambda().orderByDesc(BasDeviceEntity::getCreatorTime);
        } else {
            try {
                String sidx = basDevicePagination.getSidx();
                BasDeviceEntity basDeviceEntity = new BasDeviceEntity();
                Field declaredField = basDeviceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                basDeviceQueryWrapper = "asc".equals(basDevicePagination.getSort().toLowerCase()) ? (QueryWrapper)basDeviceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)basDeviceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(basDevicePagination.getCurrentPage(), basDevicePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)basDeviceQueryWrapper);
                return basDevicePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return basDevicePagination.setData(list, list.size());
        }
        return this.list((Wrapper)basDeviceQueryWrapper);
    }

    @Override
    public long selectDeviceBySpaceIdCount(String spaceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BasDeviceEntity::getEnabledMark, (Object)1)).eq(BasDeviceEntity::getDeleteMark, (Object)1);
        queryWrapper.lambda().eq(BasDeviceEntity::getSpaceId, (Object)spaceId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public BasDeviceEntity getInfo(String device_id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasDeviceEntity::getId, (Object)device_id);
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BasDeviceEntity::getEnabledMark, (Object)1)).eq(BasDeviceEntity::getDeleteMark, (Object)1);
        return (BasDeviceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(BasDeviceEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String device_id, BasDeviceEntity entity) {
        entity.setId(device_id);
        return this.updateById(entity);
    }

    @Override
    public BasDeviceEntity getInfoByCode(String deviceCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasDeviceEntity::getDeviceCode, (Object)deviceCode);
        return (BasDeviceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(BasDeviceEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

