/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasSensorEntity;
import com.bringspring.logistics.entity.BasSensorTypeEntity;
import com.bringspring.logistics.mapper.BasSensorMapper;
import com.bringspring.logistics.model.bassensor.BasSensorCrForm;
import com.bringspring.logistics.model.bassensor.BasSensorPagination;
import com.bringspring.logistics.service.BasSensorService;
import com.bringspring.logistics.service.BasSensorTypeService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasSensorServiceImpl
extends ServiceImpl<BasSensorMapper, BasSensorEntity>
implements BasSensorService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BasSensorTypeService basSensorTypeService;
    @Autowired
    private UserService userService;

    @Override
    public List<BasSensorEntity> getList(BasSensorPagination basSensorPagination) {
        Object basSensorObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int basSensorNum = 0;
        QueryWrapper basSensorQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basSensorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basSensorQueryWrapper, basSensorPagination.getMenuId(), "basSensor"));
            if (ObjectUtil.isEmpty((Object)basSensorObj)) {
                return new ArrayList<BasSensorEntity>();
            }
            basSensorQueryWrapper = (QueryWrapper)basSensorObj;
            ++basSensorNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basSensorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basSensorQueryWrapper, basSensorPagination.getMenuId(), "basSensor"));
            if (ObjectUtil.isEmpty((Object)basSensorObj)) {
                return new ArrayList<BasSensorEntity>();
            }
            basSensorQueryWrapper = (QueryWrapper)basSensorObj;
            ++basSensorNum;
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getSensorTypeId())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getSensorTypeId, (Object)basSensorPagination.getSensorTypeId());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getSensorCode())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getSensorCode, (Object)basSensorPagination.getSensorCode());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getSensorName())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getSensorName, (Object)basSensorPagination.getSensorName());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getSensorCrc())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getSensorCrc, (Object)basSensorPagination.getSensorCrc());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getDescription())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getDescription, (Object)basSensorPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getCreatorUserId())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getCreatorUserId, (Object)basSensorPagination.getCreatorUserId());
        }
        ((LambdaQueryWrapper)basSensorQueryWrapper.lambda().eq(BasSensorEntity::getEnabledMark, (Object)1)).eq(BasSensorEntity::getDeleteMark, (Object)1);
        if (AllIdList.size() > 0) {
            basSensorQueryWrapper.lambda().in(BasSensorEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)basSensorPagination.getSidx())) {
            basSensorQueryWrapper.lambda().orderByDesc(BasSensorEntity::getId);
        } else {
            try {
                String sidx = basSensorPagination.getSidx();
                BasSensorEntity basSensorEntity = new BasSensorEntity();
                Field declaredField = basSensorEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                basSensorQueryWrapper = "asc".equals(basSensorPagination.getSort().toLowerCase()) ? (QueryWrapper)basSensorQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)basSensorQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(basSensorPagination.getCurrentPage(), basSensorPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)basSensorQueryWrapper);
            return basSensorPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return basSensorPagination.setData(list, list.size());
    }

    @Override
    public List<BasSensorEntity> getTypeList(BasSensorPagination basSensorPagination, String dataType) {
        Object basSensorObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int basSensorNum = 0;
        QueryWrapper basSensorQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basSensorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basSensorQueryWrapper, basSensorPagination.getMenuId(), "basSensor"));
            if (ObjectUtil.isEmpty((Object)basSensorObj)) {
                return new ArrayList<BasSensorEntity>();
            }
            basSensorQueryWrapper = (QueryWrapper)basSensorObj;
            ++basSensorNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basSensorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(basSensorQueryWrapper, basSensorPagination.getMenuId(), "basSensor"));
            if (ObjectUtil.isEmpty((Object)basSensorObj)) {
                return new ArrayList<BasSensorEntity>();
            }
            basSensorQueryWrapper = (QueryWrapper)basSensorObj;
            ++basSensorNum;
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getSensorTypeId())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getSensorTypeId, (Object)basSensorPagination.getSensorTypeId());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getSensorCode())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getSensorCode, (Object)basSensorPagination.getSensorCode());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getSensorName())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getSensorName, (Object)basSensorPagination.getSensorName());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getSensorCrc())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getSensorCrc, (Object)basSensorPagination.getSensorCrc());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getDescription())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getDescription, (Object)basSensorPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)basSensorPagination.getCreatorUserId())) {
            ++basSensorNum;
            basSensorQueryWrapper.lambda().like(BasSensorEntity::getCreatorUserId, (Object)basSensorPagination.getCreatorUserId());
        }
        ((LambdaQueryWrapper)basSensorQueryWrapper.lambda().eq(BasSensorEntity::getEnabledMark, (Object)1)).eq(BasSensorEntity::getDeleteMark, (Object)1);
        if (AllIdList.size() > 0) {
            basSensorQueryWrapper.lambda().in(BasSensorEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)basSensorPagination.getSidx())) {
            basSensorQueryWrapper.lambda().orderByDesc(BasSensorEntity::getId);
        } else {
            try {
                String sidx = basSensorPagination.getSidx();
                BasSensorEntity basSensorEntity = new BasSensorEntity();
                Field declaredField = basSensorEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                basSensorQueryWrapper = "asc".equals(basSensorPagination.getSort().toLowerCase()) ? (QueryWrapper)basSensorQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)basSensorQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(basSensorPagination.getCurrentPage(), basSensorPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)basSensorQueryWrapper);
                return basSensorPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return basSensorPagination.setData(list, list.size());
        }
        return this.list((Wrapper)basSensorQueryWrapper);
    }

    @Override
    public BasSensorEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasSensorEntity::getId, (Object)id);
        queryWrapper.lambda().eq(BasSensorEntity::getId, (Object)id);
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BasSensorEntity::getEnabledMark, (Object)1)).eq(BasSensorEntity::getDeleteMark, (Object)1);
        return (BasSensorEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(BasSensorEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, BasSensorEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(BasSensorEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void selectValues(List<BasSensorCrForm> outputVo) {
        if (ObjectUtil.isNull(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            UserEntity infoUser;
            BasSensorTypeEntity info = this.basSensorTypeService.getInfo(item.getSensorTypeId());
            if (!ObjectUtil.isEmpty((Object)info)) {
                item.setSensorTypeName(info.getSensorTypeName());
            }
            if (!ObjectUtil.isEmpty((Object)(infoUser = this.userService.getInfo(item.getCreatorUserId())))) {
                item.setCreatorUserName(infoUser.getRealName());
            }
            item.setCreatorTimeFormat(ObjectUtil.isNull((Object)item.getCreatorTime()) ? null : DateUtil.daFormat((Long)item.getCreatorTime()));
            item.setLastModifyTimeFormat(ObjectUtil.isNull((Object)item.getLastModifyTime()) ? null : DateUtil.daFormat((Long)item.getLastModifyTime()));
        });
    }
}

