/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.logistics.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasSpaceEntity;
import com.bringspring.logistics.mapper.BasSpaceMapper;
import com.bringspring.logistics.model.basspace.BasSpaceCrForm;
import com.bringspring.logistics.model.basspace.BasSpaceInfoVO;
import com.bringspring.logistics.model.basspace.BasSpacePagination;
import com.bringspring.logistics.model.basspace.BasSpaceUpForm;
import com.bringspring.logistics.service.BasSpaceService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BasSpaceServiceImpl
extends ServiceImpl<BasSpaceMapper, BasSpaceEntity>
implements BasSpaceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceEntity> getList(BasSpacePagination pagination) {
        Object basSpaceObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int basSpaceNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basSpaceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "bas_space"));
            if (ObjectUtil.isEmpty((Object)basSpaceObj)) {
                return new ArrayList<BasSpaceEntity>();
            }
            queryWrapper = (QueryWrapper)basSpaceObj;
            ++basSpaceNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basSpaceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "bas_space"));
            if (ObjectUtil.isEmpty((Object)basSpaceObj)) {
                return new ArrayList<BasSpaceEntity>();
            }
            queryWrapper = (QueryWrapper)basSpaceObj;
            ++basSpaceNum;
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId()) && !"1".equals(pagination.getCompanyId())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)t.eq(BasSpaceEntity::getCompanyId, (Object)pagination.getCompanyId());
            });
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)t.like(BasSpaceEntity::getSpaceName, (Object)pagination.getKeyword());
            });
        }
        if (StringUtil.isNotEmpty((String)pagination.getOrgId())) {
            ++basSpaceNum;
            queryWrapper.lambda().eq(BasSpaceEntity::getOrgId, (Object)pagination.getOrgId());
        }
        if (StringUtil.isNotEmpty((String)pagination.getParentId())) {
            ++basSpaceNum;
            queryWrapper.lambda().eq(BasSpaceEntity::getParentId, (Object)pagination.getParentId());
        }
        if (StringUtil.isNotEmpty((String)pagination.getSpaceType())) {
            ++basSpaceNum;
            queryWrapper.lambda().eq(BasSpaceEntity::getSpaceType, (Object)pagination.getSpaceType());
        }
        if (StringUtil.isNotEmpty((String)pagination.getSpaceName())) {
            ++basSpaceNum;
            queryWrapper.lambda().like(BasSpaceEntity::getSpaceName, (Object)pagination.getSpaceName());
        }
        if (StringUtil.isNotEmpty((String)pagination.getSpaceNote())) {
            ++basSpaceNum;
            queryWrapper.lambda().like(BasSpaceEntity::getSpaceNote, (Object)pagination.getSpaceNote());
        }
        if (StringUtil.isNotEmpty((String)pagination.getOrgId())) {
            ++basSpaceNum;
            queryWrapper.lambda().like(BasSpaceEntity::getOrgId, (Object)pagination.getOrgId());
        }
        queryWrapper.lambda().eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(BasSpaceEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(BasSpaceEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                BasSpaceEntity basSpaceEntity = new BasSpaceEntity();
                Field declaredField = basSpaceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceEntity> getListAll() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceEntity> getListAll(BasSpacePagination pagination) {
        String keyword;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId()) && !"1".equals(pagination.getCompanyId())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)t.eq(BasSpaceEntity::getCompanyId, (Object)pagination.getCompanyId());
            });
        }
        if (StringUtils.isNotEmpty((String)(keyword = pagination.getKeyword()))) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)t.like(BasSpaceEntity::getSpaceName, (Object)keyword);
            });
        }
        queryWrapper.lambda().eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().orderByAsc(BasSpaceEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceInfoVO> getSpaceListByIds(String[] ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.in(BasSpaceEntity::getId, (Object[])ids);
        List list = this.list((Wrapper)queryWrapper);
        List listVO = JsonUtil.getJsonToList((Object)list, BasSpaceInfoVO.class);
        return listVO;
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<String> getSpaceNameByIds(String[] ids) {
        if (ObjectUtil.isNotEmpty((Object)ids)) {
            ArrayList<String> list = new ArrayList<String>();
            List<BasSpaceInfoVO> listVO = this.getSpaceListByIds(ids);
            if (!CollectionUtils.isEmpty(listVO)) {
                for (BasSpaceInfoVO item : listVO) {
                    list.add(item.getSpaceName());
                }
            }
            return list;
        }
        return null;
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceEntity> getListByOrg(String orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasSpaceEntity::getOrgId, (Object)orgId);
        queryWrapper.lambda().eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceInfoVO> getSpaceAndParentListByOrg(String orgId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BasSpaceEntity::getOrgId, (Object)orgId);
        queryWrapper.eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        List list = this.list((Wrapper)queryWrapper);
        HashMap<String, BasSpaceEntity> entityMap = new HashMap<String, BasSpaceEntity>();
        list.stream().forEach(item -> entityMap.put(item.getId(), (BasSpaceEntity)item));
        this.recursionParent(entityMap, list);
        list.clear();
        entityMap.forEach((key, value) -> list.add(value));
        List listVO = JsonUtil.getJsonToList((Object)list, BasSpaceInfoVO.class);
        return listVO;
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceInfoVO> getSpaceAndParentListByIds(String[] ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.in(BasSpaceEntity::getId, (Object[])ids);
        List list = this.list((Wrapper)queryWrapper);
        HashMap<String, BasSpaceEntity> entityMap = new HashMap<String, BasSpaceEntity>();
        list.stream().forEach(item -> entityMap.put(item.getId(), (BasSpaceEntity)item));
        this.recursionParent(entityMap, list);
        list.clear();
        entityMap.forEach((key, value) -> list.add(value));
        List listVO = JsonUtil.getJsonToList((Object)list, BasSpaceInfoVO.class);
        return listVO;
    }

    public void recursionParent(Map<String, BasSpaceEntity> entityMap, List<BasSpaceEntity> infoList) {
        infoList.stream().forEach(item -> {
            if (StringUtil.isNotEmpty((String)item.getParentId())) {
                BasSpaceEntity info;
                if (!entityMap.containsKey(item.getParentId()) && (info = this.getInfo(item.getParentId())) != null) {
                    entityMap.put(info.getId(), info);
                    if (StringUtil.isNotEmpty((String)info.getParentId())) {
                        ArrayList<BasSpaceEntity> infos = new ArrayList<BasSpaceEntity>();
                        infos.add(info);
                        this.recursionParent(entityMap, infos);
                    }
                }
            } else {
                return;
            }
        });
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceEntity> getTypeList(BasSpacePagination pagination, String dataType) {
        Object basSpaceObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int basSpaceNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basSpaceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "basSpace"));
            if (ObjectUtil.isEmpty((Object)basSpaceObj)) {
                return new ArrayList<BasSpaceEntity>();
            }
            queryWrapper = (QueryWrapper)basSpaceObj;
            ++basSpaceNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            basSpaceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "basSpace"));
            if (ObjectUtil.isEmpty((Object)basSpaceObj)) {
                return new ArrayList<BasSpaceEntity>();
            }
            queryWrapper = (QueryWrapper)basSpaceObj;
            ++basSpaceNum;
        }
        if (StringUtil.isNotEmpty((String)pagination.getParentId())) {
            ++basSpaceNum;
            queryWrapper.lambda().like(BasSpaceEntity::getParentId, (Object)pagination.getParentId());
        }
        if (StringUtil.isNotEmpty((String)pagination.getSpaceType())) {
            ++basSpaceNum;
            queryWrapper.lambda().eq(BasSpaceEntity::getSpaceType, (Object)pagination.getSpaceType());
        }
        if (StringUtil.isNotEmpty((String)pagination.getSpaceName())) {
            ++basSpaceNum;
            queryWrapper.lambda().like(BasSpaceEntity::getSpaceName, (Object)pagination.getSpaceName());
        }
        if (StringUtil.isNotEmpty((String)pagination.getSpaceNote())) {
            ++basSpaceNum;
            queryWrapper.lambda().like(BasSpaceEntity::getSpaceNote, (Object)pagination.getSpaceNote());
        }
        if (StringUtil.isNotEmpty((String)pagination.getOrgId())) {
            ++basSpaceNum;
            queryWrapper.lambda().like(BasSpaceEntity::getOrgId, (Object)pagination.getOrgId());
        }
        queryWrapper.lambda().eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(BasSpaceEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(BasSpaceEntity::getId);
        } else {
            try {
                String sidx = pagination.getSidx();
                BasSpaceEntity basSpaceEntity = new BasSpaceEntity();
                Field declaredField = basSpaceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public BasSpaceEntity getInfo(String space_id) {
        return this.getInfo(space_id, null);
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public BasSpaceEntity getInfo(String space_id, String menuId) {
        Object sasSpaceEntityObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = StringUtil.isNotEmpty((String)menuId) && !"-1".equals(space_id);
        boolean appPermission = StringUtil.isNotEmpty((String)menuId) && !"-1".equals(space_id);
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            sasSpaceEntityObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "bas_space"));
            if (ObjectUtil.isEmpty((Object)sasSpaceEntityObj)) {
                return new BasSpaceEntity();
            }
            queryWrapper = (QueryWrapper)sasSpaceEntityObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            sasSpaceEntityObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "bas_space"));
            if (ObjectUtil.isEmpty((Object)sasSpaceEntityObj)) {
                return new BasSpaceEntity();
            }
            queryWrapper = (QueryWrapper)sasSpaceEntityObj;
        }
        queryWrapper.lambda().eq(BasSpaceEntity::getId, (Object)space_id);
        queryWrapper.lambda().eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().orderByAsc(BasSpaceEntity::getSortCode);
        return (BasSpaceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    @CacheEvict(value={"BasSpaceCache"}, allEntries=true)
    public void create(BasSpaceCrForm crForm) {
        String mainId = RandomUtil.uuId();
        BasSpaceEntity entity = (BasSpaceEntity)JsonUtil.getJsonToBean((Object)crForm, BasSpaceEntity.class);
        HashSet<String> uniqueParentIds = new HashSet<String>(Arrays.asList(crForm.getParentIds().split(",")));
        entity.setId(mainId);
        uniqueParentIds.add(mainId);
        entity.setParentIds(String.join((CharSequence)",", uniqueParentIds));
        String organizeId = this.userProvider.get().getOrganizeId();
        entity.setCompanyId(organizeId);
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        entity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode());
        this.save(entity);
    }

    @Override
    @Transactional
    @CacheEvict(value={"BasSpaceCache"}, allEntries=true)
    public boolean update(String id, BasSpaceUpForm upForm) {
        BasSpaceEntity entity = (BasSpaceEntity)JsonUtil.getJsonToBean((Object)upForm, BasSpaceEntity.class);
        entity.setId(id);
        BasSpaceEntity existingEntity = (BasSpaceEntity)this.getById((Serializable)((Object)id));
        String oldParentId = existingEntity.getParentId();
        List<BasSpaceEntity> childEntities = this.getAllChildEntities(entity.getId());
        boolean isUpdated = this.updateById(entity);
        if (isUpdated && !oldParentId.equals(entity.getParentId())) {
            for (BasSpaceEntity child : childEntities) {
                this.updateChildEntity(child, entity);
            }
        }
        return isUpdated;
    }

    private List<BasSpaceEntity> getAllChildEntities(String parentId) {
        ArrayList<BasSpaceEntity> resultList = new ArrayList<BasSpaceEntity>();
        List directChildren = this.list((Wrapper)Wrappers.lambdaQuery().eq(BasSpaceEntity::getParentId, (Object)parentId));
        if (CollectionUtil.isNotEmpty((Collection)directChildren)) {
            resultList.addAll(directChildren);
            for (BasSpaceEntity child : directChildren) {
                resultList.addAll(this.getAllChildEntities(child.getId()));
            }
        }
        return resultList;
    }

    private void updateChildEntity(BasSpaceEntity child, BasSpaceEntity newParent) {
        HashSet<String> uniqueParentIds = new HashSet<String>(Arrays.asList(newParent.getParentIds().split(",")));
        uniqueParentIds.add(newParent.getId());
        uniqueParentIds.add(child.getId());
        String newParentIds = String.join((CharSequence)",", uniqueParentIds);
        LinkedHashSet<String> uniqueTreeNames = new LinkedHashSet<String>(Arrays.asList(newParent.getTreeNames().split("/")));
        uniqueTreeNames.add(newParent.getSpaceName());
        uniqueTreeNames.add(child.getSpaceName());
        String newTreeNames = String.join((CharSequence)"/", uniqueTreeNames);
        child.setParentIds(newParentIds);
        child.setTreeNames(newTreeNames);
        this.updateById(child);
    }

    @Override
    @Transactional
    @CacheEvict(value={"BasSpaceCache"}, allEntries=true)
    public void delete(BasSpaceEntity entity) {
        if (entity != null) {
            entity.setDeleteMark(DeleteMarkEnum.DELETED.getCode());
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setDeleteTime(DateUtil.getNowDate());
            this.updateById(entity);
        }
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<String> getChildIdByParentId(String parentId) {
        List<String> listByParentId = this.getListByParentId(parentId).stream().map(item -> item.getId()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(listByParentId)) {
            List<String> strings = this.recursionTreeId(listByParentId);
            listByParentId.addAll(strings);
        }
        return listByParentId;
    }

    public List<String> recursionTreeId(List<String> returnList) {
        ArrayList<String> returnIds = new ArrayList<String>();
        for (String itemId : returnList) {
            List<String> listChild = this.getListByParentId(itemId).stream().map(item -> item.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(listChild)) continue;
            returnIds.addAll(listChild);
            List<String> strings = this.recursionTreeId(listChild);
            returnIds.addAll(strings);
        }
        return returnIds;
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceInfoVO> getListTree(String parentId) {
        BasSpaceEntity info = this.getInfo(parentId);
        ArrayList<BasSpaceEntity> listByParentId = new ArrayList<BasSpaceEntity>();
        listByParentId.add(info);
        if (!ObjectUtil.isEmpty((Object)info)) {
            List listVO = JsonUtil.getJsonToList(listByParentId, BasSpaceInfoVO.class);
            this.recursionTree(listVO);
            return listVO;
        }
        return null;
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceInfoVO> getListTree(String parentId, String menuId) {
        BasSpaceEntity info = this.getInfo(parentId, menuId);
        ArrayList<BasSpaceEntity> listByParentId = new ArrayList<BasSpaceEntity>();
        listByParentId.add(info);
        if (!ObjectUtil.isEmpty((Object)info)) {
            List listVO = JsonUtil.getJsonToList(listByParentId, BasSpaceInfoVO.class);
            this.recursionTree(listVO, menuId);
            return listVO;
        }
        return null;
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceInfoVO> getChildListTree(String parentId) {
        List<BasSpaceEntity> listByParentId = this.getListByParentId(parentId);
        if (!CollectionUtils.isEmpty(listByParentId)) {
            List listVO = JsonUtil.getJsonToList(listByParentId, BasSpaceInfoVO.class);
            this.recursionTree(listVO);
            return listVO;
        }
        return null;
    }

    public void recursionTree(List<BasSpaceInfoVO> returnList) {
        returnList.stream().forEach(item -> {
            List<BasSpaceEntity> listChild = this.getListByParentId(item.getId());
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            List listVO = JsonUtil.getJsonToList(listChild, BasSpaceInfoVO.class);
            item.setChildren(listVO);
            this.recursionTree(listVO);
        });
    }

    public void recursionTree(List<BasSpaceInfoVO> returnList, String menuId) {
        returnList.stream().forEach(item -> {
            List<BasSpaceEntity> listChild = this.getListByParentId(item.getId(), menuId);
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            List listVO = JsonUtil.getJsonToList(listChild, BasSpaceInfoVO.class);
            item.setChildren(listVO);
            this.recursionTree(listVO, menuId);
        });
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceEntity> getListByParentId(String parentId) {
        return this.getListByParentId(parentId, null);
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<BasSpaceEntity> getListByParentId(String parentId, String menuId) {
        Object sasSpaceEntityObj;
        QueryWrapper spaceQueryWrapper = new QueryWrapper();
        boolean pcPermission = StringUtil.isNotEmpty((String)menuId);
        boolean appPermission = StringUtil.isNotEmpty((String)menuId);
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            sasSpaceEntityObj = this.authorizeService.getCondition(new AuthorizeConditionModel(spaceQueryWrapper, menuId, "bas_space"));
            if (ObjectUtil.isEmpty((Object)sasSpaceEntityObj)) {
                return new ArrayList<BasSpaceEntity>();
            }
            spaceQueryWrapper = (QueryWrapper)sasSpaceEntityObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            sasSpaceEntityObj = this.authorizeService.getCondition(new AuthorizeConditionModel(spaceQueryWrapper, menuId, "bas_space"));
            if (ObjectUtil.isEmpty((Object)sasSpaceEntityObj)) {
                return new ArrayList<BasSpaceEntity>();
            }
            spaceQueryWrapper = (QueryWrapper)sasSpaceEntityObj;
        }
        spaceQueryWrapper.lambda().eq(BasSpaceEntity::getParentId, (Object)parentId);
        spaceQueryWrapper.lambda().eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        spaceQueryWrapper.lambda().eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        spaceQueryWrapper.lambda().orderByAsc(BasSpaceEntity::getSortCode);
        List list = this.list((Wrapper)spaceQueryWrapper);
        return list;
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public long selectSpaceCount(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BasSpaceEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(BasSpaceEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().eq(BasSpaceEntity::getParentId, (Object)parentId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public Map<String, String> getBasSpaceCache(String parentId) {
        return this.getBasSpaceCache(parentId, null);
    }

    @Override
    @Cacheable(value={"BasSpaceCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public Map<String, String> getBasSpaceCache(String parentId, String menuId) {
        HashMap<String, String> basSpaceMap = new HashMap<String, String>();
        List<BasSpaceEntity> listByParentId = this.getListByParentId(parentId, menuId);
        if (CollectionUtil.isNotEmpty(listByParentId)) {
            this.recursionTree(listByParentId, basSpaceMap, "", menuId);
        }
        return basSpaceMap;
    }

    public void recursionTree(List<BasSpaceEntity> list, Map<String, String> basSpaceMap, String key, String menuId) {
        list.stream().forEach(item -> {
            String childKey = key + item.getSpaceName();
            List<BasSpaceEntity> listChild = this.getListByParentId(item.getId(), menuId);
            if (!CollectionUtil.isNotEmpty(listChild)) {
                basSpaceMap.put(childKey, item.getId());
                return;
            }
            this.recursionTree(listChild, basSpaceMap, childKey, menuId);
        });
    }
}

