/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.extend.entity.CustomerEntity;
import com.bringspring.extend.model.customer.CustomerCrForm;
import com.bringspring.extend.model.customer.CustomerInfoVO;
import com.bringspring.extend.model.customer.CustomerListVO;
import com.bringspring.extend.model.customer.CustomerUpForm;
import com.bringspring.extend.service.CustomerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u4fe1\u606f"}, value="Customer")
@RequestMapping(value={"/api/extend/saleOrder/Customer"})
public class CustomerController {
    private static final Logger log = LoggerFactory.getLogger(CustomerController.class);
    @Autowired
    private CustomerService customerService;

    @GetMapping
    @ApiOperation(value="\u5217\u8868")
    public ActionResult list(Pagination pagination) {
        pagination.setPageSize(50L);
        pagination.setCurrentPage(1L);
        List<CustomerEntity> list = this.customerService.getList(pagination);
        List listVO = JsonUtil.getJsonToList(list, CustomerListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa")
    public ActionResult create(@RequestBody @Valid CustomerCrForm customerCrForm) {
        CustomerEntity entity = (CustomerEntity)JsonUtil.getJsonToBean((Object)customerCrForm, CustomerEntity.class);
        this.customerService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u4fe1\u606f")
    public ActionResult<CustomerInfoVO> info(@PathVariable(value="id") String id) {
        CustomerEntity entity = this.customerService.getInfo(id);
        CustomerInfoVO vo = (CustomerInfoVO)JsonUtil.getJsonToBean((Object)entity, CustomerInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @ApiOperation(value="\u66f4\u65b0")
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CustomerUpForm customerUpForm) {
        CustomerEntity entity = (CustomerEntity)JsonUtil.getJsonToBean((Object)customerUpForm, CustomerEntity.class);
        boolean ok = this.customerService.update(id, entity);
        if (ok) {
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664")
    public ActionResult delete(@PathVariable(value="id") String id) {
        CustomerEntity entity = this.customerService.getInfo(id);
        if (entity != null) {
            this.customerService.delete(entity);
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }
}

