/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.Page;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FileModel;
import com.bringspring.common.util.DownUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.extend.model.documentpreview.FileListVO;
import com.bringspring.files.enums.FilePreviewTypeEnum;
import com.bringspring.files.model.YozoFileParams;
import com.bringspring.files.model.YozoParams;
import com.bringspring.files.utils.SplicingUrlUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NoDataSourceBind
@Api(tags={"\u6587\u6863\u5728\u7ebf\u9884\u89c8"}, value="DocumentPreview")
@RestController
@RequestMapping(value={"/api/extend/DocumentPreview"})
public class DocumentPreviewController {
    @Autowired
    private ConfigValueUtil configValueUtil;

    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u5217\u8868")
    @GetMapping
    public ActionResult<List<FileListVO>> list(Page page) {
        String path = this.configValueUtil.getDocumentPreviewPath();
        List data = UploadUtil.getFileList((String)this.configValueUtil.getFileType(), (String)"preview", (String)path, (String)page.getKeyword(), (boolean)true);
        List list = JsonUtil.getJsonToList((Object)data, FileListVO.class);
        return ActionResult.success((Object)list);
    }

    @ApiOperation(value="\u6587\u6863\u5728\u7ebf\u9884\u89c8")
    @GetMapping(value={"/{fileId}/Preview"})
    public ActionResult list(@PathVariable(value="fileId") Integer fileId, YozoFileParams params, String previewType) throws UnsupportedEncodingException {
        File file = null;
        String filePath = this.configValueUtil.getDocumentPreviewPath();
        if (this.configValueUtil.getFileType().equals("minio")) {
            List fileList = UploadUtil.getFileList((String)this.configValueUtil.getFileType(), (String)"preview", (String)filePath, null, (boolean)false);
            if (fileList.get(fileId) == null) {
                return ActionResult.fail((String)"\u6587\u4ef6\u627e\u4e0d\u5230!");
            }
            String url = YozoParams.DOMAINS + "/api/extend/DocumentPreview/down/" + ((FileModel)fileList.get(fileId)).getFileName();
            if (previewType.equals(FilePreviewTypeEnum.YOZO_ONLINE_PREVIEW.getType())) {
                params.setUrl(url);
                String urlPath = SplicingUrlUtil.getPreviewUrl((YozoFileParams)params);
                return ActionResult.success((String)"success", (Object)XSSEscape.escape((String)urlPath));
            }
            if (previewType.equals(FilePreviewTypeEnum.LOCAL_PREVIEW.getType())) {
                return ActionResult.success((String)"success", (Object)url);
            }
        } else {
            File filePaths = new File(XSSEscape.escapePath((String)filePath));
            List files = FileUtil.getFile((File)filePaths);
            if (fileId > files.size()) {
                return ActionResult.fail((String)"\u6587\u4ef6\u627e\u4e0d\u5230!");
            }
            file = (File)files.get(fileId);
            if (file != null) {
                String url = YozoParams.DOMAINS + "/api/extend/DocumentPreview/down/" + file.getName();
                if (previewType.equals(FilePreviewTypeEnum.YOZO_ONLINE_PREVIEW.getType())) {
                    params.setUrl(url);
                    String urlPath = SplicingUrlUtil.getPreviewUrl((YozoFileParams)params);
                    return ActionResult.success((String)"success", (Object)XSSEscape.escape((String)urlPath));
                }
                if (previewType.equals(FilePreviewTypeEnum.LOCAL_PREVIEW.getType())) {
                    return ActionResult.success((String)"success", (Object)url);
                }
            }
        }
        return ActionResult.fail((String)"\u6587\u4ef6\u627e\u4e0d\u5230!");
    }

    @NoDataSourceBind
    @GetMapping(value={"/down/{fileName}"})
    public void down(@PathVariable(value="fileName") String fileName) throws DataException {
        String filePath = this.configValueUtil.getDocumentPreviewPath();
        List fileList = UploadUtil.getFileList((String)this.configValueUtil.getFileType(), (String)"preview", (String)filePath, null, (boolean)false);
        List collect = fileList.stream().filter(t -> fileName.equals(t.getFileName())).collect(Collectors.toList());
        if (collect.size() > 0) {
            UploadUtil.streamToDown((String)this.configValueUtil.getFileType(), (String)fileName, (String)"preview", (String)filePath);
        }
        if (FileUtil.fileIsFile((String)(filePath = filePath + fileName)) && !DownUtil.dowloadFile((String)filePath, (String)fileName, null).booleanValue()) {
            throw new DataException("\u4e0b\u8f7d\u5931\u8d25");
        }
    }
}

