/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.extend.entity.ProjectGanttEntity;
import com.bringspring.extend.model.projectgantt.ProjectGanttCrForm;
import com.bringspring.extend.model.projectgantt.ProjectGanttInfoVO;
import com.bringspring.extend.model.projectgantt.ProjectGanttListVO;
import com.bringspring.extend.model.projectgantt.ProjectGanttManagerModel;
import com.bringspring.extend.model.projectgantt.ProjectGanttTaskInfoVO;
import com.bringspring.extend.model.projectgantt.ProjectGanttTaskTreeModel;
import com.bringspring.extend.model.projectgantt.ProjectGanttTaskTreeVO;
import com.bringspring.extend.model.projectgantt.ProjectGanttTreeModel;
import com.bringspring.extend.model.projectgantt.ProjectGanttTsakCrForm;
import com.bringspring.extend.model.projectgantt.ProjectGanttTsakUpForm;
import com.bringspring.extend.model.projectgantt.ProjectGanttUpForm;
import com.bringspring.extend.service.ProjectGanttService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9879\u76ee\u8ba1\u5212"}, value="ProjectGantt")
@RestController
@RequestMapping(value={"/api/extend/ProjectGantt"})
public class ProjectGanttController {
    @Autowired
    private ProjectGanttService projectGanttService;
    @Autowired
    private UserService userService;

    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u7ba1\u7406\u5217\u8868")
    @GetMapping
    public ActionResult<ListVO<ProjectGanttListVO>> list(Page page) {
        List<ProjectGanttEntity> data = this.projectGanttService.getList(page);
        List list = JsonUtil.getJsonToList(data, ProjectGanttListVO.class);
        ArrayList userId = new ArrayList();
        list.forEach(t -> {
            String[] ids = t.getManagerIds().split(",");
            Collections.addAll(userId, ids);
        });
        List userList = this.userService.getUserName(userId);
        for (ProjectGanttListVO vo : list) {
            ArrayList managerList = new ArrayList();
            Collections.addAll(managerList, vo.getManagerIds().split(","));
            List<UserEntity> user = userList.stream().filter(t -> managerList.contains(t.getId())).collect(Collectors.toList());
            ArrayList<ProjectGanttManagerModel> list1 = new ArrayList<ProjectGanttManagerModel>();
            user.forEach(t -> {
                ProjectGanttManagerModel model1 = new ProjectGanttManagerModel();
                model1.setAccount(t.getRealName());
                model1.setHeadIcon(t.getHeadIcon());
                list1.add(model1);
            });
            vo.setManagersInfo(list1);
        }
        ListVO listVO = new ListVO();
        listVO.setList(list);
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u4efb\u52a1\u5217\u8868")
    @GetMapping(value={"/{projectId}/Task"})
    public ActionResult<ListVO<ProjectGanttTaskTreeVO>> taskList(Page page, @PathVariable(value="projectId") String projectId) {
        List<ProjectGanttEntity> data;
        List<ProjectGanttEntity> dataAll = data = this.projectGanttService.getTaskList(projectId);
        if (!StringUtils.isEmpty((CharSequence)page.getKeyword())) {
            data = data.stream().filter(t -> String.valueOf(t.getFullName()).contains(page.getKeyword()) || String.valueOf(t.getEnCode()).contains(page.getKeyword())).collect(Collectors.toList());
        }
        List list = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(data, dataAll), ProjectGanttEntity.class);
        List treeList = JsonUtil.getJsonToList((Object)list, ProjectGanttTreeModel.class);
        List trees = TreeDotUtils.convertListToTreeDot((List)treeList);
        List listVO = JsonUtil.getJsonToList((Object)trees, ProjectGanttTaskTreeVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u8ba1\u5212\u4efb\u52a1\u6811\u5f62\uff08\u65b0\u5efa\u4efb\u52a1\uff09")
    @GetMapping(value={"/{projectId}/Task/Selector/{id}"})
    public ActionResult<ListVO<ProjectGanttTaskTreeVO>> taskTreeView(@PathVariable(value="projectId") String projectId, @PathVariable(value="id") String id) {
        ArrayList<ProjectGanttTaskTreeModel> treeList = new ArrayList<ProjectGanttTaskTreeModel>();
        List<ProjectGanttEntity> data = this.projectGanttService.getTaskList(projectId);
        if (!"0".equals(id)) {
            data.remove(this.projectGanttService.getInfo(id));
        }
        for (ProjectGanttEntity entity : data) {
            ProjectGanttTaskTreeModel treeModel = new ProjectGanttTaskTreeModel();
            treeModel.setId(entity.getId());
            treeModel.setFullName(entity.getFullName());
            treeModel.setParentId(entity.getParentId());
            treeList.add(treeModel);
        }
        List trees = TreeDotUtils.convertListToTreeDotFilter(treeList);
        List listVO = JsonUtil.getJsonToList((Object)trees, ProjectGanttTaskTreeVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u8ba1\u5212\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<ProjectGanttInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ProjectGanttEntity entity = this.projectGanttService.getInfo(id);
        ProjectGanttInfoVO vo = (ProjectGanttInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, ProjectGanttInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u8ba1\u5212\u4fe1\u606f")
    @GetMapping(value={"Task/{id}"})
    public ActionResult<ProjectGanttTaskInfoVO> taskInfo(@PathVariable(value="id") String id) throws DataException {
        ProjectGanttEntity entity = this.projectGanttService.getInfo(id);
        ProjectGanttTaskInfoVO vo = (ProjectGanttTaskInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, ProjectGanttTaskInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5220\u9664\u9879\u76ee\u8ba1\u5212/\u4efb\u52a1")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        if (this.projectGanttService.allowDelete(id)) {
            ProjectGanttEntity entity = this.projectGanttService.getInfo(id);
            if (entity != null) {
                this.projectGanttService.delete(entity);
                return ActionResult.success((String)MsgCode.SU003.get());
            }
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25\uff0c\u6b64\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        return ActionResult.fail((String)"\u6b64\u8bb0\u5f55\u88ab\u5173\u8054\u5f15\u7528,\u4e0d\u5141\u8bb8\u88ab\u5220\u9664");
    }

    @ApiOperation(value="\u6dfb\u52a0\u9879\u76ee\u8ba1\u5212")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ProjectGanttCrForm projectGanttCrForm) {
        ProjectGanttEntity entity = (ProjectGanttEntity)JsonUtil.getJsonToBean((Object)projectGanttCrForm, ProjectGanttEntity.class);
        entity.setType(1);
        entity.setParentId("0");
        if (this.projectGanttService.isExistByFullName(projectGanttCrForm.getFullName(), entity.getId())) {
            return ActionResult.fail((String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.projectGanttService.isExistByEnCode(projectGanttCrForm.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.projectGanttService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u8ba1\u5212")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ProjectGanttUpForm projectGanttUpForm) {
        ProjectGanttEntity entity = (ProjectGanttEntity)JsonUtil.getJsonToBean((Object)projectGanttUpForm, ProjectGanttEntity.class);
        if (this.projectGanttService.isExistByFullName(projectGanttUpForm.getFullName(), id)) {
            return ActionResult.fail((String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.projectGanttService.isExistByEnCode(projectGanttUpForm.getEnCode(), id)) {
            return ActionResult.fail((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.projectGanttService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u6dfb\u52a0\u9879\u76ee\u4efb\u52a1")
    @PostMapping(value={"/Task"})
    public ActionResult createTask(@RequestBody @Valid ProjectGanttTsakCrForm projectGanttTsakCrForm) {
        ProjectGanttEntity entity = (ProjectGanttEntity)JsonUtil.getJsonToBean((Object)projectGanttTsakCrForm, ProjectGanttEntity.class);
        entity.setType(2);
        if (this.projectGanttService.isExistByFullName(projectGanttTsakCrForm.getFullName(), entity.getId())) {
            return ActionResult.fail((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        this.projectGanttService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u4efb\u52a1")
    @PutMapping(value={"/Task/{id}"})
    public ActionResult updateTask(@PathVariable(value="id") String id, @RequestBody @Valid ProjectGanttTsakUpForm projectGanttTsakCrForm) {
        ProjectGanttEntity entity = (ProjectGanttEntity)JsonUtil.getJsonToBean((Object)projectGanttTsakCrForm, ProjectGanttEntity.class);
        if (this.projectGanttService.isExistByFullName(projectGanttTsakCrForm.getFullName(), id)) {
            return ActionResult.fail((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.projectGanttService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }
}

