/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.BigDataEntity;
import com.bringspring.extend.mapper.BigDataMapper;
import com.bringspring.extend.service.BigDataService;
import com.bringspring.system.base.exception.WorkFlowException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BigDataServiceImpl
extends ServiceImpl<BigDataMapper, BigDataEntity>
implements BigDataService {
    private static final Logger log = LoggerFactory.getLogger(BigDataServiceImpl.class);
    @Autowired
    private DataSourceModel dataSourceUtils;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<BigDataEntity> getList(Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (pagination.getKeyword() != null) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(BigDataEntity::getFullName, (Object)pagination.getKeyword())).or()).like(BigDataEntity::getEnCode, (Object)pagination.getKeyword());
            });
        }
        if (StringUtils.isEmpty((CharSequence)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(BigDataEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)pagination.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)pagination.getSidx());
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(int insertCount) throws WorkFlowException {
        int index;
        Integer code = ((BigDataMapper)this.baseMapper).maxCode();
        if (code == null) {
            code = 0;
        }
        int n = index = code == 0 ? 10000001 : code;
        if (index > 11500001) {
            throw new WorkFlowException("\u9632\u6b62\u6076\u610f\u521b\u5efa\u8fc7\u591a\u6570\u636e");
        }
        try {
            String dbName = "true".equals(this.configValueUtil.getMultiTenancy()) ? this.userProvider.get().getTenantDbConnectionString() : this.dataSourceUtils.getDbName();
            Connection conn = ConnUtil.getConn((DataSourceMod)this.dataSourceUtils, (String)dbName);
            try {
                Statement pstm = null;
                try {
                    String sql = "";
                    sql = DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceUtils) != false || DbTypeUtil.checkDM((DataSourceMod)this.dataSourceUtils) != false ? "INSERT INTO ext_bigdata(F_ID,F_ENCODE,F_FULL_NAME,F_CREATOR_TIME)  VALUES (?,?,?,to_date(?,'yyyy-mm-dd hh24:mi:ss'))" : "INSERT INTO ext_bigdata(F_ID,F_ENCODE,F_FULL_NAME,F_CREATOR_TIME)  VALUES (?,?,?,?)";
                    pstm = conn.prepareStatement(sql);
                    conn.setAutoCommit(false);
                    if (DbTypeUtil.checkPostgre((DataSourceMod)this.dataSourceUtils).booleanValue()) {
                        for (int i = 0; i < insertCount; ++i) {
                            pstm.setString(1, RandomUtil.uuId());
                            pstm.setInt(2, index);
                            pstm.setString(3, "\u6d4b\u8bd5\u5927\u6570\u636e" + index);
                            pstm.setDate(4, new Date(System.currentTimeMillis()));
                            pstm.addBatch();
                            ++index;
                        }
                    } else {
                        java.util.Date date = new java.util.Date();
                        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String time = sf.format(date);
                        for (int i = 0; i < insertCount; ++i) {
                            pstm.setString(1, RandomUtil.uuId());
                            pstm.setInt(2, index);
                            pstm.setString(3, "\u6d4b\u8bd5\u5927\u6570\u636e" + index);
                            pstm.setString(4, time);
                            pstm.addBatch();
                            ++index;
                        }
                    }
                    pstm.executeBatch();
                    conn.commit();
                    pstm.close();
                    conn.close();
                }
                finally {
                    if (Collections.singletonList(pstm).get(0) != null) {
                        pstm.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

