/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.EmployeeEntity;
import com.bringspring.extend.mapper.EmployeeMapper;
import com.bringspring.extend.model.EmployeeModel;
import com.bringspring.extend.model.employee.EmployeeImportVO;
import com.bringspring.extend.model.employee.PaginationEmployee;
import com.bringspring.extend.service.EmployeeService;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmployeeServiceImpl
extends ServiceImpl<EmployeeMapper, EmployeeEntity>
implements EmployeeService {
    private static final Logger log = LoggerFactory.getLogger(EmployeeServiceImpl.class);
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<EmployeeEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().orderByDesc(EmployeeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<EmployeeEntity> getList(PaginationEmployee paginationEmployee) {
        String propertyValue;
        QueryWrapper queryWrapper = new QueryWrapper();
        String propertyName = paginationEmployee.getCondition() != null ? paginationEmployee.getCondition() : null;
        String string = propertyValue = paginationEmployee.getKeyword() != null ? paginationEmployee.getKeyword() : null;
        if (!StringUtils.isEmpty((CharSequence)propertyName) && !StringUtils.isEmpty((CharSequence)propertyValue)) {
            switch (propertyName) {
                case "EnCode": {
                    queryWrapper.lambda().like(EmployeeEntity::getEnCode, (Object)propertyValue);
                    break;
                }
                case "FullName": {
                    queryWrapper.lambda().like(EmployeeEntity::getFullName, (Object)propertyValue);
                    break;
                }
                case "Telephone": {
                    queryWrapper.lambda().like(EmployeeEntity::getTelephone, (Object)propertyValue);
                    break;
                }
                case "DepartmentName": {
                    queryWrapper.lambda().like(EmployeeEntity::getDepartmentName, (Object)propertyValue);
                    break;
                }
                case "PositionName": {
                    queryWrapper.lambda().like(EmployeeEntity::getPositionName, (Object)propertyValue);
                    break;
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)paginationEmployee.getSidx())) {
            queryWrapper.lambda().orderByDesc(EmployeeEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(paginationEmployee.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)paginationEmployee.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)paginationEmployee.getSidx());
        }
        Page page = new Page(paginationEmployee.getCurrentPage(), paginationEmployee.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationEmployee.setData(userIPage.getRecords(), page.getTotal());
    }

    @Override
    public EmployeeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EmployeeEntity::getId, (Object)id);
        return (EmployeeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(EmployeeEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public void create(EmployeeEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setSortCode(RandomUtil.parses());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setCreatorTime(new Date());
        this.save(entity);
    }

    @Override
    public void update(String id, EmployeeEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        this.updateById(entity);
    }

    @Override
    public Map<String, Object> importPreview(List<EmployeeModel> personList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        if (personList != null) {
            int i;
            for (i = 0; i < personList.size(); ++i) {
                HashMap<String, String> dataRowMap = new HashMap<String, String>();
                EmployeeModel model = personList.get(i);
                dataRowMap.put("enCode", model.getEnCode());
                dataRowMap.put("fullName", model.getFullName());
                dataRowMap.put("gender", model.getGender());
                dataRowMap.put("departmentName", model.getDepartmentName());
                dataRowMap.put("positionName", model.getPositionName());
                dataRowMap.put("workingNature", model.getWorkingNature());
                dataRowMap.put("idNumber", model.getIdNumber());
                dataRowMap.put("telephone", model.getTelephone());
                dataRowMap.put("attendWorkTime", model.getAttendWorkTime());
                dataRowMap.put("birthday", model.getBirthday());
                dataRowMap.put("education", model.getEducation());
                dataRowMap.put("major", model.getMajor());
                dataRowMap.put("graduationAcademy", model.getGraduationAcademy());
                dataRowMap.put("graduationTime", model.getGraduationTime());
                dataRow.add(dataRowMap);
            }
            for (i = 1; i < 15; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("AutoIncrement", false);
                columnsMap.put("AutoIncrementSeed", 0);
                columnsMap.put("AutoIncrementStep", 1);
                columnsMap.put("Caption", this.getColumns(i));
                columnsMap.put("ColumnMapping", 1);
                columnsMap.put("ColumnName", this.getColumns(i));
                columnsMap.put("Container", null);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columnsMap.put("DateTimeMode", 3);
                columnsMap.put("DefaultValue", null);
                columnsMap.put("DesignMode", false);
                columnsMap.put("Expression", "");
                columnsMap.put("ExtendedProperties", "");
                columnsMap.put("MaxLength", -1);
                columnsMap.put("Namespace", "");
                columnsMap.put("Ordinal", 0);
                columnsMap.put("Prefix", "");
                columnsMap.put("ReadOnly", false);
                columnsMap.put("Site", null);
                columnsMap.put("Table", personList);
                columnsMap.put("Unique", false);
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    @Override
    public EmployeeImportVO importData(List<EmployeeModel> dt) {
        for (EmployeeModel model : dt) {
            model.setAttendWorkTime(DateUtil.cstFormat((String)model.getAttendWorkTime()));
            model.setBirthday(DateUtil.cstFormat((String)model.getBirthday()));
            model.setGraduationTime(DateUtil.cstFormat((String)model.getGraduationTime()));
        }
        List entitys = JsonUtil.getJsonToList(dt, EmployeeEntity.class);
        int sum = 0;
        int num = 0;
        ArrayList<EmployeeEntity> errList = new ArrayList<EmployeeEntity>();
        for (EmployeeEntity entity : entitys) {
            entity.setId(RandomUtil.uuId());
            entity.setCreatorUserId(this.userProvider.get().getUserId());
            entity.setCreatorTime(new Date());
            try {
                ((EmployeeMapper)this.baseMapper).insert(entity);
                ++sum;
            }
            catch (Exception e) {
                errList.add(entity);
                log.error("\u5bfc\u5165\u7b2c" + (++num + 1) + "\u6761\u6570\u636e\u5931\u8d25");
            }
        }
        EmployeeImportVO vo = new EmployeeImportVO();
        vo.setSnum(sum);
        vo.setFnum(num);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList(errList, EmployeeModel.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportPdf(List<EmployeeEntity> list, String outputUrl) {
        try {
            Document document = new Document();
            try {
                BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
                Font font = new Font(bfChinese, 11.0f, 0);
                PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outputUrl));
                document.open();
                PdfPTable row = new PdfPTable(13);
                row.setWidthPercentage(100.0f);
                String[] titles = new String[]{"\u59d3\u540d", "\u6027\u522b", "\u90e8\u95e8", "\u804c\u4f4d", "\u7528\u5de5\u6027\u8d28", "\u8eab\u4efd\u8bc1\u53f7", "\u8054\u7cfb\u7535\u8bdd", "\u51fa\u751f\u5e74\u6708", "\u53c2\u52a0\u5de5\u4f5c", "\u6700\u9ad8\u5b66\u5386", "\u6240\u5b66\u4e13\u4e1a", "\u6bd5\u4e1a\u9662\u6821", "\u6bd5\u4e1a\u65f6\u95f4"};
                for (String title : titles) {
                    row.addCell(this.createCell(title, font));
                }
                document.add((Element)row);
                for (EmployeeEntity entity : list) {
                    row = new PdfPTable(13);
                    row.setWidthPercentage(100.0f);
                    row.addCell(this.createCell(entity.getFullName(), font));
                    row.addCell(this.createCell(entity.getGender(), font));
                    row.addCell(this.createCell(entity.getDepartmentName(), font));
                    row.addCell(this.createCell(entity.getPositionName(), font));
                    row.addCell(this.createCell(entity.getWorkingNature(), font));
                    row.addCell(this.createCell(entity.getIdNumber(), font));
                    row.addCell(this.createCell(entity.getTelephone(), font));
                    row.addCell(this.createCell(entity.getAttendWorkTime() != null ? DateUtil.daFormat((Date)entity.getAttendWorkTime()) : "", font));
                    row.addCell(this.createCell(entity.getBirthday() != null ? DateUtil.daFormat((Date)entity.getBirthday()) : "", font));
                    row.addCell(this.createCell(entity.getEducation(), font));
                    row.addCell(this.createCell(entity.getMajor(), font));
                    row.addCell(this.createCell(entity.getGraduationAcademy(), font));
                    row.addCell(this.createCell(entity.getGraduationTime() != null ? DateUtil.daFormat((Date)entity.getGraduationTime()) : "", font));
                    document.add((Element)row);
                }
                document.close();
            }
            finally {
                if (Collections.singletonList(document).get(0) != null) {
                    document.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private PdfPCell createCell(String value, Font font) {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(1);
        cell.setPhrase(new Phrase(value, font));
        return cell;
    }

    private String getKey(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\u5de5\u53f7", "F_EnCode");
        map.put("\u59d3\u540d", "F_FullName");
        map.put("\u6027\u522b", "F_Gender");
        map.put("\u90e8\u95e8", "F_DepartmentName");
        map.put("\u5c97\u4f4d", "F_PositionName");
        map.put("\u7528\u5de5\u6027\u8d28", "F_WorkingNature");
        map.put("\u8eab\u4efd\u8bc1\u53f7", "F_IDNumber");
        map.put("\u8054\u7cfb\u7535\u8bdd", "F_Telephone");
        map.put("\u51fa\u751f\u5e74\u6708", "F_Birthday");
        map.put("\u53c2\u52a0\u5de5\u4f5c", "F_AttendWorkTime");
        map.put("\u6700\u9ad8\u5b66\u5386", "F_Education");
        map.put("\u6240\u5b66\u4e13\u4e1a", "F_Major");
        map.put("\u6bd5\u4e1a\u9662\u6821", "F_GraduationAcademy");
        map.put("\u6bd5\u4e1a\u65f6\u95f4", "F_GraduationTime");
        return (String)map.get(key);
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u5de5\u53f7");
        map.put(2, "\u59d3\u540d");
        map.put(3, "\u6027\u522b");
        map.put(4, "\u90e8\u95e8");
        map.put(5, "\u5c97\u4f4d");
        map.put(6, "\u7528\u5de5\u6027\u8d28");
        map.put(7, "\u8eab\u4efd\u8bc1\u53f7");
        map.put(8, "\u8054\u7cfb\u7535\u8bdd");
        map.put(9, "\u51fa\u751f\u5e74\u6708");
        map.put(10, "\u53c2\u52a0\u5de5\u4f5c");
        map.put(11, "\u6700\u9ad8\u5b66\u5386");
        map.put(12, "\u6240\u5b66\u4e13\u4e1a");
        map.put(13, "\u6bd5\u4e1a\u9662\u6821");
        map.put(14, "\u6bd5\u4e1a\u65f6\u95f4");
        return (String)map.get(key);
    }
}

