/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.ProjectGanttEntity;
import com.bringspring.extend.mapper.ProjectGanttMapper;
import com.bringspring.extend.service.ProjectGanttService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectGanttServiceImpl
extends ServiceImpl<ProjectGanttMapper, ProjectGanttEntity>
implements ProjectGanttService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ProjectGanttEntity> getList(Page page) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ProjectGanttEntity::getType, (Object)1)).orderByAsc(ProjectGanttEntity::getSortCode)).orderByDesc(ProjectGanttEntity::getCreatorTime);
        if (!StringUtils.isEmpty((CharSequence)page.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(ProjectGanttEntity::getEnCode, (Object)page.getKeyword())).or()).like(ProjectGanttEntity::getFullName, (Object)page.getKeyword());
            });
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ProjectGanttEntity> getTaskList(String projectId) {
        ProjectGanttEntity entity = this.getInfo(projectId);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ProjectGanttEntity::getType, (Object)2)).eq(ProjectGanttEntity::getProjectId, (Object)projectId)).orderByAsc(ProjectGanttEntity::getSortCode);
        List list = this.list((Wrapper)queryWrapper);
        list.add(entity);
        return list;
    }

    @Override
    public ProjectGanttEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProjectGanttEntity::getId, (Object)id);
        return (ProjectGanttEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean allowDelete(String id) {
        Pagination pagination = new Pagination();
        Long subdataCount = this.getList((Page)pagination).stream().filter(t -> String.valueOf(t.getProjectId()).equals(id)).count();
        return subdataCount == 0L;
    }

    @Override
    public void delete(ProjectGanttEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public void create(ProjectGanttEntity entity) {
        entity.setId(RandomUtil.uuId());
        if (entity.getEnabledMark() == null) {
            entity.setEnabledMark(1);
        }
        entity.setSortCode(RandomUtil.parses());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String id, ProjectGanttEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProjectGanttEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((CharSequence)id)) {
            queryWrapper.lambda().ne(ProjectGanttEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProjectGanttEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((CharSequence)id)) {
            queryWrapper.lambda().ne(ProjectGanttEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        ProjectGanttEntity upEntity = (ProjectGanttEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().lt(ProjectGanttEntity::getSortCode, (Object)upSortCode)).eq(ProjectGanttEntity::getParentId, (Object)upEntity.getParentId())).orderByDesc(ProjectGanttEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((ProjectGanttEntity)downEntity.get(0)).getSortCode());
            ((ProjectGanttEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById(downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        ProjectGanttEntity downEntity = (ProjectGanttEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().gt(ProjectGanttEntity::getSortCode, (Object)upSortCode)).eq(ProjectGanttEntity::getParentId, (Object)downEntity.getParentId())).orderByAsc(ProjectGanttEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((ProjectGanttEntity)upEntity.get(0)).getSortCode());
            ((ProjectGanttEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById(upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }
}

