/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.model.dataInterface.DataInterfaceActionVo;
import com.bringspring.system.base.service.BillRuleService;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.service.FlowTaskService;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictionaryConversion {
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private DataInterfaceService dataInterfaceService;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private FlowTaskService flowTaskService;
    public final String regEx = "[\\[\\]\"]";

    public String dateSwap(String date, String format) {
        if (StringUtils.isNotEmpty((String)date)) {
            DateTimeFormatter ftf = DateTimeFormatter.ofPattern(format);
            if (date.contains(",")) {
                String[] dates = date.split(",");
                long time1 = Long.parseLong(dates[0]);
                long time2 = Long.parseLong(dates[1]);
                String value1 = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time1), ZoneId.systemDefault()));
                String value2 = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time2), ZoneId.systemDefault()));
                return value1 + "\u81f3" + value2;
            }
            long time = Long.parseLong(date);
            String value = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
            return value;
        }
        return date;
    }

    public String provinceData(String data) {
        if (StringUtils.isNotEmpty((String)data)) {
            try {
                if (data.contains("[[")) {
                    String[][] provinceDataS;
                    ArrayList<String> addList = new ArrayList<String>();
                    for (String[] AddressData : provinceDataS = (String[][])JsonUtil.getJsonToBean((String)data, String[][].class)) {
                        ArrayList<String> provList = new ArrayList<String>(Arrays.asList(AddressData));
                        List proList = this.provinceService.getProList(provList);
                        List adList = proList.stream().map(pro -> pro.getFullName()).collect(Collectors.toList());
                        addList.add(String.join((CharSequence)"/", adList));
                    }
                    return String.join((CharSequence)";", addList);
                }
                if (data.contains("[")) {
                    List idList = JsonUtil.getJsonToList((String)data, String.class);
                    ArrayList<String> nameList = new ArrayList<String>();
                    for (String orgId : idList) {
                        ProvinceEntity info = this.provinceService.getInfo(orgId);
                        nameList.add(Objects.nonNull(info) ? info.getFullName() : orgId);
                    }
                    return String.join((CharSequence)"/", nameList);
                }
                String[] strs = data.split(",");
                ArrayList<String> provList = new ArrayList<String>(Arrays.asList(strs));
                ArrayList<String> proNameList = new ArrayList<String>();
                List proList = this.provinceService.getProList(provList);
                for (ProvinceEntity entity : proList) {
                    proNameList.add(entity.getFullName());
                }
                return String.join((CharSequence)"/", proNameList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String comSelectValue(String value, String showLevel) {
        if (StringUtils.isNotEmpty((String)String.valueOf(value))) {
            OrganizeEntity organizeEntity = this.organizeService.getInfo(String.valueOf(value));
            if ("all".equals(showLevel)) {
                value = PermissionUtil.getLinkInfoByOrgId((String)value, (OrganizeService)this.organizeService, (Boolean)false);
            } else if (organizeEntity != null) {
                value = organizeEntity.getFullName();
            }
        }
        return value;
    }

    public String comSelectValues(String ids) {
        ArrayList<String> comValueList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        if (ids.contains("[[")) {
            String[][] idArrays;
            for (String[] array : idArrays = (String[][])JsonUtil.getJsonToBean((String)ids, String[][].class)) {
                ArrayList<String> idList = new ArrayList<String>();
                for (String s : array) {
                    OrganizeEntity info = this.organizeService.getInfo(s);
                    idList.add(Objects.nonNull(info) ? info.getFullName() : s);
                }
                String orgCom = idList.stream().collect(Collectors.joining("/"));
                comValueList.add(orgCom);
            }
            return comValueList.stream().collect(Collectors.joining(";"));
        }
        if (ids.contains("[")) {
            List idList = JsonUtil.getJsonToList((String)ids, String.class);
            ArrayList<String> nameList = new ArrayList<String>();
            for (String orgId : idList) {
                OrganizeEntity info = this.organizeService.getInfo(orgId);
                nameList.add(Objects.nonNull(info) ? info.getFullName() : orgId);
            }
            return nameList.stream().collect(Collectors.joining("/"));
        }
        String[] idList = (ids = ids.replaceAll("\"", "")).split(",");
        if (idList.length > 0) {
            ArrayList<String> comSelectList = new ArrayList<String>();
            for (String id : idList) {
                OrganizeEntity organizeEntity = this.organizeService.getInfo(id);
                if (organizeEntity == null) continue;
                comSelectList.add(organizeEntity.getFullName());
            }
            return String.join((CharSequence)"/", comSelectList);
        }
        return null;
    }

    public String posSelectValue(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            PositionEntity positionServiceInfo = this.positionService.getInfo(id);
            if (ObjectUtil.isNotEmpty((Object)positionServiceInfo)) {
                return positionServiceInfo.getFullName();
            }
            return id;
        }
        return "";
    }

    public String posSelectValues(String ids) {
        if (StringUtils.isEmpty((String)ids)) {
            return "";
        }
        ArrayList<String> posList = new ArrayList<String>();
        if (ids.contains("[")) {
            List idList = JsonUtil.getJsonToList((String)ids, String.class);
            ArrayList<String> nameList = new ArrayList<String>();
            for (String orgId : idList) {
                PositionEntity info = this.positionService.getInfo(orgId);
                nameList.add(Objects.nonNull(info) ? info.getFullName() : orgId);
            }
            posList = nameList;
        } else {
            String[] idList = ids.split(",");
            if (idList.length > 0) {
                for (String id : idList) {
                    PositionEntity positionEntity = this.positionService.getInfo(id);
                    if (!ObjectUtil.isNotEmpty((Object)positionEntity)) continue;
                    posList.add(positionEntity.getFullName());
                }
            }
        }
        return String.join((CharSequence)"/", posList);
    }

    public String userSelectValue(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            UserEntity userEntity = this.userService.getInfo(id);
            if (ObjectUtil.isNotEmpty((Object)userEntity)) {
                return userEntity.getRealName();
            }
            return id;
        }
        return "";
    }

    public String userSelectValueNoAccount(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            UserEntity userEntity = this.userService.getInfo(id);
            if (ObjectUtil.isNotEmpty((Object)userEntity)) {
                return userEntity.getRealName();
            }
            return id;
        }
        return "";
    }

    public String userSelectValues(String ids) {
        if (StringUtils.isEmpty((String)ids)) {
            return ids;
        }
        if (ids.contains("[")) {
            ArrayList<String> nameList = new ArrayList<String>();
            List jsonToList = JsonUtil.getJsonToList((String)ids, String.class);
            for (String userId : jsonToList) {
                UserEntity info = this.userService.getInfo(userId);
                nameList.add(Objects.nonNull(info) ? info.getRealName() : userId);
            }
            return String.join((CharSequence)";", nameList);
        }
        ArrayList<String> userInfoList = new ArrayList<String>();
        String[] idList = ids.split(",");
        if (idList.length > 0) {
            for (String id : idList) {
                UserEntity userEntity = this.userService.getInfo(id);
                if (!ObjectUtil.isNotEmpty((Object)userEntity)) continue;
                String info = userEntity.getRealName();
                userInfoList.add(info);
            }
        }
        return String.join((CharSequence)"-", userInfoList);
    }

    public String switchSelectValue(String data, String activeTxt, String inactiveTxt) {
        if (StringUtils.isNotEmpty((String)data)) {
            if (data.equals("0") || data.equals("false")) {
                return inactiveTxt;
            }
            if (data.equals("1") || data.equals("true")) {
                return activeTxt;
            }
            return data;
        }
        return null;
    }

    public String getPopupSelectValue(String interfaceId, String propsValue, String relationField, String dataValue, Map<String, Object> dataMaps) {
        if (StringUtils.isNotEmpty((String)dataValue)) {
            List dataInterfaceDataList;
            Object data = this.dataInterfaceService.infoToId(interfaceId).getData();
            if (data instanceof DataInterfaceActionVo) {
                DataInterfaceActionVo actionVo = (DataInterfaceActionVo)data;
                dataInterfaceDataList = (List)actionVo.getData();
            } else {
                dataInterfaceDataList = (List)data;
            }
            Map dataMap = dataInterfaceDataList.stream().filter(d -> d.get(propsValue).equals(dataValue)).findFirst().orElse(null);
            if (dataMap != null) {
                dataMaps.putAll(dataMap);
                return String.valueOf(dataMap.get(relationField));
            }
            return null;
        }
        return null;
    }

    public String getFileNameInJson(String fileJson) {
        if (StringUtils.isNotEmpty((String)fileJson) && !"null".equals(fileJson)) {
            return fileJson;
        }
        return "";
    }

    public String getDicName(String feild, String dictionaryTypeId) {
        if (StringUtils.isNotEmpty((String)feild)) {
            String[] feilds = (feild = feild.replaceAll("[\\[\\]\"]", "")).split(",");
            if (feilds.length > 1) {
                StringBuilder feildsValue = new StringBuilder();
                for (String feil : feilds) {
                    DictionaryDataEntity dictionaryDataEntity = this.dictionaryDataService.getSwapInfo(feil, dictionaryTypeId);
                    if (dictionaryDataEntity == null) continue;
                    feildsValue.append(dictionaryDataEntity.getFullName() + ",");
                }
                String finalValue = StringUtils.isEmpty((CharSequence)feildsValue) || feildsValue.equals("") ? feildsValue.toString() : feildsValue.substring(0, feildsValue.length() - 1);
                return finalValue;
            }
            DictionaryDataEntity dictionaryDataentity = this.dictionaryDataService.getSwapInfo(feild, dictionaryTypeId);
            if (dictionaryDataentity != null) {
                return dictionaryDataentity.getFullName();
            }
            return feild;
        }
        return feild;
    }

    public String getDynName(String urlId, String label, String value, String feildValue) {
        if (StringUtils.isNotEmpty((String)feildValue)) {
            feildValue = feildValue.replaceAll("[\\[\\]\"]", "");
            ActionResult object = this.dataInterfaceService.infoToId(urlId);
            if (object.getData() != null && object.getData() instanceof DataInterfaceActionVo) {
                DataInterfaceActionVo vo = (DataInterfaceActionVo)object.getData();
                List dataList = (List)vo.getData();
                String[] feildValues = feildValue.split(",");
                if (feildValues.length > 0) {
                    StringBuilder feildVa = new StringBuilder();
                    for (String feild : feildValues) {
                        for (Map data : dataList) {
                            if (!String.valueOf(data.get(value)).equals(feild)) continue;
                            feildVa.append(data.get(label) + ",");
                        }
                    }
                    String finalValue = StringUtils.isEmpty((CharSequence)feildVa) || feildVa.equals("") ? feildVa.toString() : feildVa.substring(0, feildVa.length() - 1);
                    return finalValue;
                }
                Iterator iterator = dataList.iterator();
                if (iterator.hasNext()) {
                    Map data = (Map)iterator.next();
                    if (feildValue.equals(String.valueOf(data.get(value)))) {
                        return data.get(label).toString();
                    }
                    return feildValue;
                }
            }
            return feildValue;
        }
        return feildValue;
    }

    public String getDynName(String urlId, String name, String id, String children, String feildValue) {
        List<Object> result = new ArrayList();
        if (StringUtils.isNotEmpty((String)feildValue)) {
            ActionResult object = this.dataInterfaceService.infoToId(urlId);
            DataInterfaceActionVo actionVo = (DataInterfaceActionVo)object.getData();
            List dataList = new ArrayList();
            if (actionVo.getData() instanceof List) {
                dataList = (List)actionVo.getData();
            }
            JSONArray dataAll = JsonUtil.getListToJsonArray(dataList);
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            this.treeToList(id, name, children, dataAll, list);
            String value = feildValue.replaceAll("\\[", "").replaceAll("\\]", "");
            result = list.stream().filter(t -> value.contains(String.valueOf(t.get(id)))).map(t -> String.valueOf(t.get(name))).collect(Collectors.toList());
        }
        return String.join((CharSequence)",", result);
    }

    private void treeToList(String id, String fullName, String children, JSONArray data, List<Map<String, String>> result) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(id, String.valueOf(ob.get((Object)id)));
            tree.put(fullName, String.valueOf(ob.get((Object)fullName)));
            result.add(tree);
            if (ob.get((Object)children) == null) continue;
            JSONArray childArray = ob.getJSONArray(children);
            this.treeToList(id, fullName, children, childArray, result);
        }
    }

    public String getBillNumber(String encode, Boolean isCache) throws DataException {
        return this.billRuleService.getBillNumber(encode, isCache.booleanValue());
    }

    public FlowTaskEntity getInfoSubmit(String id, SFunction<FlowTaskEntity, ?> ... columns) {
        return this.flowTaskService.getInfoSubmit(id, columns);
    }

    public void deleteFlowTask(FlowTaskEntity flowTaskEntity) throws WorkFlowException {
        this.flowTaskService.delete(flowTaskEntity);
    }
}

