/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.erp.entity.ErpEnterEntity;
import com.bringspring.erp.entity.ErpEnterOperateEntity;
import com.bringspring.erp.mapper.ErpEnterCheckOperateMapper;
import com.bringspring.erp.mapper.ErpEnterOperateMapper;
import com.bringspring.erp.model.enter.ErpEnterInfoVO;
import com.bringspring.erp.model.enterOperate.ErpEnterOperateCrForm;
import com.bringspring.erp.service.ErpEnterCheckOperateService;
import com.bringspring.erp.service.ErpEnterOperateService;
import com.bringspring.erp.service.ErpEnterService;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"erp_enter_check_operate"}, value="erp")
@RequestMapping(value={"/api/erp/ErpEnterCheckOperate"})
public class ErpEnterCheckOperateController {
    private static final Logger log = LoggerFactory.getLogger(ErpEnterCheckOperateController.class);
    @Autowired
    private ErpEnterCheckOperateService erpEnterCheckOperateService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpEnterService erpEnterService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ErpMaterialTypeService erpMaterialTypeService;
    @Autowired
    private ErpEnterOperateMapper erpEnterOperateMapper;
    @Autowired
    private ErpEnterOperateService erpEnterOperateService;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private ErpEnterCheckOperateMapper erpEnterCheckOperateMapper;

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ErpEnterOperateCrForm erpEnterOperateCrForm) throws DataException {
        this.erpEnterCheckOperateService.create(erpEnterOperateCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpEnterInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ErpEnterOperateEntity erpEnterOperateEntity = (ErpEnterOperateEntity)this.erpEnterOperateService.getById((Serializable)((Object)id));
        ErpEnterEntity entity = this.erpEnterService.getInfo(erpEnterOperateEntity.getEnterId());
        ErpEnterInfoVO vo = (ErpEnterInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpEnterInfoVO.class);
        vo.setProperties(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
        vo.setPricingScheme(erpEnterOperateEntity.getPricingScheme());
        vo.setMaterialType(this.erpMaterialTypeService.getInfo(vo.getMaterialType()).getFullName());
        vo.setErpEntrepotList(this.erpEntrepotService.getListFull());
        vo.setNumber(erpEnterOperateEntity.getNumber());
        vo.setReceiveNumber(erpEnterOperateEntity.getNumber() - erpEnterOperateEntity.getCheckNumber() - erpEnterOperateEntity.getRetreatNumber());
        vo.setApplyCode(erpEnterOperateEntity.getApplyCode());
        vo.setBatch(erpEnterOperateEntity.getBatch());
        return ActionResult.success((Object)vo);
    }
}

