/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.erp.entity.ErpEnterEntity;
import com.bringspring.erp.entity.ErpMaterialTypeEntity;
import com.bringspring.erp.mapper.ErpBatchMapper;
import com.bringspring.erp.mapper.ErpEnterOperateMapper;
import com.bringspring.erp.model.enter.ErpEnterImportReturnVO;
import com.bringspring.erp.model.enter.ErpEnterImportVO;
import com.bringspring.erp.model.enter.ErpEnterInfoVO;
import com.bringspring.erp.model.enter.ErpEnterListVO;
import com.bringspring.erp.model.enter.ErpEnterPagination;
import com.bringspring.erp.service.ErpEnterOperateService;
import com.bringspring.erp.service.ErpEnterService;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"erp_enter"}, value="erp")
@RequestMapping(value={"/api/erp/ErpEnter"})
public class ErpEnterController {
    private static final Logger log = LoggerFactory.getLogger(ErpEnterController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpEnterService erpEnterService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ErpMaterialTypeService erpMaterialTypeService;
    @Autowired
    private ErpEnterOperateMapper erpEnterOperateMapper;
    @Autowired
    private ErpEnterOperateService erpEnterOperateService;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private ErpBatchMapper erpBatchMapper;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ErpEnterPagination erpEnterPagination) throws IOException {
        List<ErpEnterEntity> list = this.erpEnterService.getList(erpEnterPagination);
        List listVO = JsonUtil.getJsonToList(list, ErpEnterListVO.class);
        for (ErpEnterListVO erpEnterVO : listVO) {
            if (StringUtils.isNotEmpty((CharSequence)erpEnterVO.getBuyer())) {
                erpEnterVO.setBuyer(this.baseDataUtil.userSelectValue(erpEnterVO.getBuyer()));
            }
            erpEnterVO.setProperties(this.baseDataUtil.getDictName(erpEnterVO.getProperties(), "materialProperties"));
            erpEnterVO.setInvoiceTaxName(this.baseDataUtil.getDictName(erpEnterVO.getApplyTaxRate(), "contractRate"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpEnterPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpEnterInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ErpEnterEntity entity = this.erpEnterService.getInfo(id);
        ErpEnterInfoVO vo = (ErpEnterInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpEnterInfoVO.class);
        vo.setProperties(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
        ErpMaterialTypeEntity info = this.erpMaterialTypeService.getInfo(vo.getMaterialType());
        vo.setMaterialType(ObjectUtil.isNotEmpty((Object)info) ? this.erpMaterialTypeService.getInfo(vo.getMaterialType()).getFullName() : vo.getMaterialType());
        vo.setErpEntrepotList(this.erpEntrepotService.getListFull());
        vo.setBatch(vo.getProcureCode() + this.erpEnterService.getNumber(vo.getProcureCode()));
        vo.setSum(entity.getNumber() - entity.getReceiveNumber());
        if (StrUtil.isEmpty((CharSequence)vo.getApplyCode())) {
            vo.setApplyCode(this.erpEnterService.getApplyCode(vo.getProcureCode(), vo.getCode()));
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ErpEnterInfoVO> detailInfo(@PathVariable(value="id") String id) {
        ErpEnterEntity entity = this.erpEnterService.getInfo(id);
        ErpEnterInfoVO vo = (ErpEnterInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpEnterInfoVO.class);
        vo.setProperties(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
        ErpMaterialTypeEntity info = this.erpMaterialTypeService.getInfo(vo.getMaterialType());
        vo.setMaterialType(ObjectUtil.isNotEmpty((Object)info) ? this.erpMaterialTypeService.getInfo(vo.getMaterialType()).getFullName() : vo.getMaterialType());
        if (StringUtils.isNotEmpty((CharSequence)vo.getBuyer())) {
            vo.setBuyer(this.baseDataUtil.userSelectValue(vo.getBuyer()));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getCreatorUserId())) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getLastModifyUserId())) {
            vo.setLastModifyUserName(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        }
        vo.setErpEnterOperateList(this.erpEnterOperateService.getListByEnterId(id));
        if (StrUtil.isEmpty((CharSequence)vo.getApplyCode())) {
            vo.setApplyCode(this.erpEnterService.getApplyCode(vo.getProcureCode(), vo.getCode()));
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, ErpEnterImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 200) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e200\u6761");
        }
        Map<String, Object> map = this.erpEnterService.importPreview(fileImportList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<ErpEnterImportReturnVO> ImportData(@RequestBody ErpEnterImportVO data) throws DataException {
        List dataList = JsonUtil.getJsonToList(data.getList(), ErpEnterImportVO.class);
        ErpEnterImportReturnVO result = this.erpEnterService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u7269\u6599\u5165\u5e93.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u7269\u6599\u5165\u5e93.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }
}

