/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.model.ofmaterial.ErpMaterialCrForm;
import com.bringspring.erp.model.ofmaterial.ErpMaterialInfoVO;
import com.bringspring.erp.model.ofmaterial.ErpMaterialListQuery;
import com.bringspring.erp.model.ofmaterial.ErpMaterialListVO;
import com.bringspring.erp.model.ofmaterial.ErpMaterialPagination;
import com.bringspring.erp.model.ofmaterial.ErpMaterialPaginationExportModel;
import com.bringspring.erp.model.ofmaterial.ErpMaterialUpForm;
import com.bringspring.erp.model.ofmaterial.MaterialImportReturnVO;
import com.bringspring.erp.model.ofmaterial.MaterialImportVO;
import com.bringspring.erp.plugin.MaterialPlugin;
import com.bringspring.erp.plugin.MaterialPluginServiceLocator;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.erp.util.DeleteMarkEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u7269\u8d44\u5e93\u5b58\u5217\u8868"}, value="erp")
@RequestMapping(value={"/api/erp/erpMaterial"})
public class ErpMaterialController {
    private static final Logger log = LoggerFactory.getLogger(ErpMaterialController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpMaterialService ofMaterialService;
    @Autowired
    private ErpMaterialTypeService ofMaterialTypeService;
    @Autowired
    private MaterialPluginServiceLocator materialPluginServiceLocator;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ErpMaterialPagination ofMaterialPagination) throws IOException {
        List<ErpMaterialEntity> list = this.ofMaterialService.getList(ofMaterialPagination);
        List listVO = JsonUtil.getJsonToList(list, ErpMaterialListVO.class);
        for (ErpMaterialListVO ofMaterialVO : listVO) {
            ofMaterialVO.setPictures(this.baseDataUtil.getFileNameInJson(ofMaterialVO.getPictures()));
            if (StringUtils.isNotEmpty((CharSequence)ofMaterialVO.getCreatorUserId())) {
                ofMaterialVO.setCreatorUserName(this.baseDataUtil.userSelectValue(ofMaterialVO.getCreatorUserId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)ofMaterialVO.getLastModifyUserId())) {
                ofMaterialVO.setLastModifyUserName(this.baseDataUtil.userSelectValue(ofMaterialVO.getLastModifyUserId()));
            }
            ofMaterialVO.setPropertiesName(this.baseDataUtil.getDictName(ofMaterialVO.getProperties(), "materialProperties"));
            ofMaterialVO.setMaterialTypeName(this.ofMaterialTypeService.getInfo(ofMaterialVO.getMaterialTypeId()).getFullName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofMaterialPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/materialListQuery"})
    public ActionResult list(ErpMaterialListQuery ofMaterialListQuery) throws IOException {
        List<ErpMaterialEntity> list = this.ofMaterialService.getMaterialList(ofMaterialListQuery);
        List listVO = JsonUtil.getJsonToList(list, ErpMaterialListVO.class);
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ErpMaterialCrForm ofMaterialCrForm) throws DataException {
        ErpMaterialEntity entity;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u589e\u5931\u8d25");
        }
        if (StrUtil.isEmpty((CharSequence)ofMaterialCrForm.getCode())) {
            Calendar calendar = Calendar.getInstance();
            String yearNum = String.valueOf(calendar.get(1));
            String code = this.baseDataUtil.getBillNumber("erpMaterialCode", Boolean.valueOf(false));
            ofMaterialCrForm.setCode(code.replaceFirst(yearNum, yearNum + "3"));
        }
        if (!this.ofMaterialService.checkCodeUnique(entity = (ErpMaterialEntity)JsonUtil.getJsonToBean((Object)ofMaterialCrForm, ErpMaterialEntity.class))) {
            return ActionResult.fail((String)"\u7f16\u7801\u51b2\u7a81\uff0c\u65b0\u589e\u5931\u8d25");
        }
        if (!this.ofMaterialService.checkNameUnique(entity)) {
            return ActionResult.fail((String)"\u540d\u79f0\u51b2\u7a81\uff0c\u65b0\u589e\u5931\u8d25");
        }
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.ofMaterialService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u7269\u6599\u7ba1\u7406.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u7269\u6599\u7ba1\u7406.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(ErpMaterialPaginationExportModel ofMaterialPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((CharSequence)ofMaterialPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        ErpMaterialPagination ofmaterialPagination = (ErpMaterialPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)ofMaterialPaginationExportModel), ErpMaterialPagination.class));
        List<ErpMaterialEntity> list = this.ofMaterialService.getTypeList(ofmaterialPagination, ofMaterialPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, ErpMaterialListVO.class);
        Map<Integer, DeleteMarkEnum> allToMap = DeleteMarkEnum.getAllToMap();
        for (ErpMaterialListVO ofMaterialVO : listVO) {
            if (StringUtils.isNotEmpty((CharSequence)ofMaterialVO.getMaterialTypeId())) {
                ofMaterialVO.setMaterialTypeName(this.ofMaterialTypeService.getInfo(ofMaterialVO.getMaterialTypeId()).getFullName());
            }
            if (ofMaterialVO.getDeleteMark() != null) {
                ofMaterialVO.setDeleteMarkDesc(ofMaterialVO.getDeleteMark().equals("0") ? "\u6b63\u5e38" : "\u505c\u7528");
            }
            ofMaterialVO.setPictures(this.baseDataUtil.getFileNameInJson(ofMaterialVO.getPictures()));
            if (StringUtils.isNotEmpty((CharSequence)ofMaterialVO.getCreatorUserId())) {
                ofMaterialVO.setCreatorUserName(this.baseDataUtil.userSelectValue(ofMaterialVO.getCreatorUserId()));
            }
            if (!StringUtils.isNotEmpty((CharSequence)ofMaterialVO.getLastModifyUserId())) continue;
            ofMaterialVO.setLastModifyUserName(this.baseDataUtil.userSelectValue(ofMaterialVO.getLastModifyUserId()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((CharSequence)ofMaterialPaginationExportModel.getSelectKey()) ? ofMaterialPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block40: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "materialTypeId": {
                        entitys.add(new ExcelExportEntity("\u7269\u8d44\u5206\u7c7b", (Object)"materialTypeName"));
                        continue block40;
                    }
                    case "fullName": {
                        entitys.add(new ExcelExportEntity("\u7269\u8d44\u540d\u79f0", (Object)"fullName"));
                        continue block40;
                    }
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u7269\u8d44\u7f16\u7801", (Object)"code"));
                        continue block40;
                    }
                    case "supplier": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546", (Object)"supplier"));
                        continue block40;
                    }
                    case "matUnit": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u91cf\u5355\u4f4d", (Object)"matUnit"));
                        continue block40;
                    }
                    case "deleteMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u8bc6", (Object)"deleteMarkDesc"));
                        continue block40;
                    }
                    case "pictures": {
                        entitys.add(new ExcelExportEntity("\u7269\u8d44\u7167\u7247", (Object)"pictures"));
                        continue block40;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block40;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserName"));
                        continue block40;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block40;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserName"));
                        continue block40;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block40;
                    }
                    case "brand": {
                        entitys.add(new ExcelExportEntity("\u54c1\u724c", (Object)"brand"));
                        continue block40;
                    }
                    case "model": {
                        entitys.add(new ExcelExportEntity("\u89c4\u683c\u578b\u53f7", (Object)"model"));
                        continue block40;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u7269\u8d44\u5e93\u5b58\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u7269\u8d44\u5e93\u5b58\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpMaterialInfoVO> info(@PathVariable(value="id") String id) {
        ErpMaterialEntity entity = this.ofMaterialService.getInfo(id);
        ErpMaterialInfoVO vo = (ErpMaterialInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpMaterialInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ErpMaterialInfoVO> detailInfo(@PathVariable(value="id") String id) {
        ErpMaterialEntity entity = this.ofMaterialService.getInfo(id);
        ErpMaterialInfoVO vo = (ErpMaterialInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpMaterialInfoVO.class);
        if (StringUtils.isNotEmpty((CharSequence)vo.getMaterialTypeId())) {
            vo.setMaterialTypeName(this.ofMaterialTypeService.getInfo(vo.getMaterialTypeId()).getFullName());
        }
        vo.setPictures(this.baseDataUtil.getFileNameInJson(vo.getPictures()));
        if (StringUtils.isNotEmpty((CharSequence)vo.getCreatorUserId())) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getLastModifyUserId())) {
            vo.setLastModifyUserName(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        }
        vo.setProperties(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ErpMaterialUpForm ofMaterialUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        ErpMaterialEntity entity = this.ofMaterialService.getInfo(id);
        if (entity != null) {
            ErpMaterialEntity subentity = (ErpMaterialEntity)JsonUtil.getJsonToBean((Object)ofMaterialUpForm, ErpMaterialEntity.class);
            if (!this.ofMaterialService.checkCodeUnique(subentity)) {
                return ActionResult.fail((String)"\u7f16\u7801\u51b2\u7a81\uff0c\u66f4\u65b0\u5931\u8d25");
            }
            if (!this.ofMaterialService.checkNameUnique(subentity)) {
                return ActionResult.fail((String)"\u540d\u79f0\u51b2\u7a81\uff0c\u66f4\u65b0\u5931\u8d25");
            }
            subentity.setLastModifyTime(null);
            subentity.setLastModifyUserId(null);
            subentity.setCompanyId(userInfo.getOrganizeId());
            this.ofMaterialService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        ErpMaterialEntity entity = this.ofMaterialService.getInfo(id);
        if (entity != null) {
            String checkResultStr = "";
            Map<String, MaterialPlugin> serviceLocatorAll = this.materialPluginServiceLocator.getAll();
            Set<Map.Entry<String, MaterialPlugin>> entries = serviceLocatorAll.entrySet();
            for (Map.Entry<String, MaterialPlugin> entry : entries) {
                String tempStr = entry.getValue().checkMaterialExistData(id);
                if (!StringUtils.isNotEmpty((CharSequence)tempStr)) continue;
                checkResultStr = checkResultStr + tempStr + "\uff0c";
            }
            if (StringUtils.isNotEmpty((CharSequence)checkResultStr)) {
                return ActionResult.fail((String)(checkResultStr + "\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            this.ofMaterialService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/price/{id}"})
    public ActionResult<ErpMaterialEntity> OfMaterialPrice(@PathVariable(value="id") String id) {
        ErpMaterialEntity ErpMaterialEntity2 = (ErpMaterialEntity)this.ofMaterialService.getById((Serializable)((Object)id));
        return ActionResult.success((Object)ErpMaterialEntity2);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, MaterialImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 200) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e200\u6761");
        }
        Map<String, Object> map = this.ofMaterialService.importPreview(fileImportList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<MaterialImportReturnVO> ImportData(@RequestBody MaterialImportVO data) throws DataException {
        List dataList = JsonUtil.getJsonToList(data.getList(), MaterialImportVO.class);
        MaterialImportReturnVO result = this.ofMaterialService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }
}

