/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.erp.entity.ErpConsumingApplyEntity;
import com.bringspring.erp.entity.ErpConsumingDetailEntity;
import com.bringspring.erp.entity.ErpEntrepotEntity;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.entity.ErpOutboundEntity;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyInfoVO;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingDetailModel;
import com.bringspring.erp.model.erpoutbound.ErpOutboundCrForm;
import com.bringspring.erp.model.erpoutbound.ErpOutboundInfoVO;
import com.bringspring.erp.model.erpoutbound.ErpOutboundListVO;
import com.bringspring.erp.model.erpoutbound.ErpOutboundPagination;
import com.bringspring.erp.model.erpoutbound.ErpOutboundUpForm;
import com.bringspring.erp.model.ofmaterial.ErpMaterialInfoVO;
import com.bringspring.erp.service.ErpConsumingApplyService;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.erp.service.ErpOutboundService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u51fa\u5e93\u8bb0\u5f55\u8868 \u9500\u552e\u51fa\u5e93 \u8c03\u62e8"}, value="erp")
@RequestMapping(value={"/api/erp/ErpOutbound"})
public class ErpOutboundController {
    private static final Logger log = LoggerFactory.getLogger(ErpOutboundController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpOutboundService erpOutboundService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private ErpMaterialService erpMaterialService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ErpMaterialTypeService ofMaterialTypeService;
    @Autowired
    private ErpConsumingApplyService erpConsumingApplyService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private CrmCustomerService crmCustomerService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ErpOutboundPagination erpOutboundPagination) throws IOException {
        List<ErpOutboundEntity> list = this.erpOutboundService.getList(erpOutboundPagination);
        List listVO = JsonUtil.getJsonToList(list, ErpOutboundListVO.class);
        for (ErpOutboundListVO erpOutboundVO : listVO) {
            ErpMaterialEntity codeInfo;
            ErpEntrepotEntity info;
            OrganizeEntity organizeServiceInfo;
            erpOutboundVO.setTypeName(this.baseDataUtil.getDictName(erpOutboundVO.getType(), "inAndOutStorageType"));
            erpOutboundVO.setStatusName(this.baseDataUtil.getDictName(erpOutboundVO.getStatus(), "outboundStatus"));
            if (!StrUtil.isBlank((CharSequence)erpOutboundVO.getCompanyId()) && ObjectUtil.isNotEmpty((Object)(organizeServiceInfo = this.organizeService.getInfo(erpOutboundVO.getCompanyId())))) {
                erpOutboundVO.setCompanyId(organizeServiceInfo.getFullName());
            }
            if (!StrUtil.isBlank((CharSequence)erpOutboundVO.getWarehouseIdOut()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(erpOutboundVO.getWarehouseIdOut())))) {
                erpOutboundVO.setWarehouseIdOut(info.getEntrepotName());
            }
            if (StrUtil.isBlank((CharSequence)erpOutboundVO.getMaterialCode()) || !ObjectUtil.isNotEmpty((Object)(codeInfo = this.erpMaterialService.getCodeInfo(erpOutboundVO.getMaterialCode())))) continue;
            erpOutboundVO.setMaterialName(codeInfo.getFullName());
            erpOutboundVO.setMaterialId(codeInfo.getId());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpOutboundPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ErpOutboundCrForm erpOutboundCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ErpOutboundEntity entity = (ErpOutboundEntity)JsonUtil.getJsonToBean((Object)erpOutboundCrForm, ErpOutboundEntity.class);
        entity.setId(mainId);
        this.erpOutboundService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpOutboundInfoVO> info(@PathVariable(value="id") String id) {
        ErpOutboundEntity entity = this.erpOutboundService.getInfo(id);
        ErpOutboundInfoVO vo = (ErpOutboundInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpOutboundInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ErpOutboundInfoVO> detailInfo(@PathVariable(value="id") String id) {
        ErpMaterialInfoVO materialInfoVO;
        ErpMaterialEntity codeInfo;
        OrganizeEntity organizeServiceInfo;
        ErpEntrepotEntity info;
        ErpOutboundEntity entity = this.erpOutboundService.getInfo(id);
        ErpMaterialEntity materialEntity = this.erpMaterialService.getCodeInfo(entity.getMaterialCode());
        ErpOutboundInfoVO vo = (ErpOutboundInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpOutboundInfoVO.class);
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), "inAndOutStorageType"));
        vo.setStatus(this.baseDataUtil.getDictName(vo.getStatus(), "outboundStatus"));
        if (!StrUtil.isBlank((CharSequence)vo.getWarehouseIdOut()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(vo.getWarehouseIdOut())))) {
            vo.setWarehouseIdOut(info.getEntrepotName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getWarehouseIdEnter()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(vo.getWarehouseIdEnter())))) {
            vo.setWarehouseIdEnter(info.getEntrepotName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getCompanyId()) && ObjectUtil.isNotEmpty((Object)(organizeServiceInfo = this.organizeService.getInfo(vo.getCompanyId())))) {
            vo.setCompanyId(organizeServiceInfo.getFullName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getMaterialCode()) && ObjectUtil.isNotEmpty((Object)(codeInfo = this.erpMaterialService.getCodeInfo(vo.getMaterialCode())))) {
            vo.setMaterialCode(codeInfo.getFullName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getConsumingId())) {
            CrmCustomerEntity customerEntity;
            RkContractProjectEntity projectEntity;
            RkContractEntity rkContractEntity;
            ErpConsumingApplyEntity applyServiceInfo = this.erpConsumingApplyService.getInfo(vo.getConsumingId());
            ErpConsumingApplyInfoVO consumingInfo = (ErpConsumingApplyInfoVO)JsonUtil.getJsonToBean((Object)applyServiceInfo, ErpConsumingApplyInfoVO.class);
            consumingInfo.setSaleManager(this.baseDataUtil.userSelectValues(consumingInfo.getSaleManager()));
            consumingInfo.setProjectManager(this.baseDataUtil.userSelectValues(consumingInfo.getProjectManager()));
            consumingInfo.setApplyPerson(this.baseDataUtil.userSelectValues(consumingInfo.getApplyPerson()));
            if (!StrUtil.isBlank((CharSequence)consumingInfo.getContractId()) && ObjectUtil.isNotEmpty((Object)(rkContractEntity = this.contractService.getInfo(consumingInfo.getContractId())))) {
                consumingInfo.setContractId(rkContractEntity.getContractName());
            }
            if (!StrUtil.isBlank((CharSequence)consumingInfo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(consumingInfo.getProjectId())))) {
                consumingInfo.setProjectId(projectEntity.getProjectName());
            }
            if (!StrUtil.isBlank((CharSequence)consumingInfo.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(customerEntity = this.crmCustomerService.getInfo(consumingInfo.getCustomerId())))) {
                consumingInfo.setCustomerId(customerEntity.getName());
            }
            List<ErpConsumingDetailEntity> ErpConsumingDetailList = this.erpConsumingApplyService.GetErpConsumingDetailList(vo.getConsumingId());
            consumingInfo.setErpConsumingDetailList(JsonUtil.getJsonToList(ErpConsumingDetailList, ErpConsumingDetailModel.class));
            vo.setErpConsumingApplyInfoVO(consumingInfo);
            if (ObjectUtil.isNotEmpty((Object)applyServiceInfo)) {
                vo.setConsumingId(applyServiceInfo.getDescription());
                vo.setProjectCode(applyServiceInfo.getProjectCode());
                vo.setSaleManager(this.baseDataUtil.userSelectValues(applyServiceInfo.getSaleManager()));
                vo.setProjectManager(this.baseDataUtil.userSelectValues(applyServiceInfo.getProjectManager()));
                vo.setApplyPerson(this.baseDataUtil.userSelectValues(applyServiceInfo.getApplyPerson()));
                RkContractProjectEntity pro = this.rkContractProjectService.getInfo(applyServiceInfo.getProjectId());
                if (ObjectUtil.isNotEmpty((Object)pro)) {
                    vo.setProjectName(pro.getProjectName());
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(materialInfoVO = (ErpMaterialInfoVO)JsonUtil.getJsonToBean((Object)materialEntity, ErpMaterialInfoVO.class)).getMaterialTypeId())) {
            materialInfoVO.setMaterialTypeName(this.ofMaterialTypeService.getInfo(materialInfoVO.getMaterialTypeId()).getFullName());
        }
        materialInfoVO.setPictures(this.baseDataUtil.getFileNameInJson(materialInfoVO.getPictures()));
        if (StringUtils.isNotEmpty((CharSequence)materialInfoVO.getCreatorUserId())) {
            materialInfoVO.setCreatorUserName(this.baseDataUtil.userSelectValue(materialInfoVO.getCreatorUserId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)materialInfoVO.getLastModifyUserId())) {
            materialInfoVO.setLastModifyUserName(this.baseDataUtil.userSelectValue(materialInfoVO.getLastModifyUserId()));
        }
        materialInfoVO.setProperties(this.baseDataUtil.getDictName(materialInfoVO.getProperties(), "materialProperties"));
        vo.setMaterialInfoVO(materialInfoVO);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ErpOutboundUpForm erpOutboundUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        ErpOutboundEntity entity = this.erpOutboundService.getInfo(id);
        if (entity != null) {
            ErpOutboundEntity subentity = (ErpOutboundEntity)JsonUtil.getJsonToBean((Object)erpOutboundUpForm, ErpOutboundEntity.class);
            this.erpOutboundService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        ErpOutboundEntity entity = this.erpOutboundService.getInfo(id);
        if (entity != null) {
            this.erpOutboundService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/handleOperate/{id}"})
    @DSTransactional
    public ActionResult handleOperate(@PathVariable(value="id") String id, @RequestBody @Valid ErpOutboundUpForm erpOutboundUpForm) throws DataException {
        ErpOutboundEntity entity = this.erpOutboundService.getInfo(id);
        if (entity != null) {
            entity.setStatus(erpOutboundUpForm.getStatus());
            if (erpOutboundUpForm.getStatus().equals("accepted")) {
                entity.setCheckUserId(erpOutboundUpForm.getCheckUserId());
                String strDate = DateUtil.daFormatYmd((Long)Long.valueOf(erpOutboundUpForm.getCheckDate()));
                entity.setCheckDate(DateUtil.stringToDates((String)strDate));
            }
            this.erpOutboundService.update(id, entity);
            return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

