/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.erp.entity.ErpConsumingApplyEntity;
import com.bringspring.erp.entity.ErpConsumingDetailEntity;
import com.bringspring.erp.entity.ErpEntrepotEntity;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.entity.ErpStorageRecordsEntity;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyInfoVO;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingDetailModel;
import com.bringspring.erp.model.erpStorageRecords.ErpStorageRecordsCrForm;
import com.bringspring.erp.model.erpStorageRecords.ErpStorageRecordsInfoVO;
import com.bringspring.erp.model.erpStorageRecords.ErpStorageRecordsListVO;
import com.bringspring.erp.model.erpStorageRecords.ErpStorageRecordsPagination;
import com.bringspring.erp.model.erpStorageRecords.ErpStorageRecordsPaginationExportModel;
import com.bringspring.erp.model.erpStorageRecords.ErpStorageRecordsUpForm;
import com.bringspring.erp.model.ofmaterial.ErpMaterialInfoVO;
import com.bringspring.erp.service.ErpConsumingApplyService;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.erp.service.ErpStorageRecordsService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u51fa/\u5165\u5e93\u8bb0\u5f55\u8868-\u6d41\u6c34"}, value="erp")
@RequestMapping(value={"/api/erp/ErpStorageRecords"})
public class ErpStorageRecordsController {
    private static final Logger log = LoggerFactory.getLogger(ErpStorageRecordsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpStorageRecordsService erpStorageRecordsService;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private ErpMaterialService erpMaterialService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private ErpMaterialTypeService ofMaterialTypeService;
    @Autowired
    private ErpConsumingApplyService erpConsumingApplyService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private CrmCustomerService crmCustomerService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ErpStorageRecordsPagination erpStorageRecordsPagination) throws IOException {
        List<ErpStorageRecordsEntity> list = this.erpStorageRecordsService.getList(erpStorageRecordsPagination);
        List listVO = JsonUtil.getJsonToList(list, ErpStorageRecordsListVO.class);
        for (ErpStorageRecordsListVO erpStorageRecordsVO : listVO) {
            OrganizeEntity organizeServiceInfo;
            ErpMaterialEntity codeInfo;
            ErpEntrepotEntity info;
            erpStorageRecordsVO.setTypeName(this.baseDataUtil.getDictName(erpStorageRecordsVO.getType(), "inAndOutStorageType"));
            if (!StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getWarehouseId()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(erpStorageRecordsVO.getWarehouseId())))) {
                erpStorageRecordsVO.setWarehouseId(info.getEntrepotName());
            }
            if (!StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getContractId())) {
                List<String> contractList = Arrays.asList(erpStorageRecordsVO.getContractId().split(","));
                StringBuffer stringBuffer = new StringBuffer();
                for (String s : contractList) {
                    RkContractEntity info2 = this.rkContractService.getInfo(s);
                    if (!ObjectUtil.isNotEmpty((Object)info2)) continue;
                    stringBuffer.append(info2.getContractName() + ",");
                }
                String contractName = stringBuffer.toString();
                String contractNameStr = "";
                if (!StrUtil.isBlank((CharSequence)contractName) && contractName.endsWith(",") && contractName.length() > 3) {
                    contractNameStr = contractName.substring(0, contractName.length() - 1);
                }
                erpStorageRecordsVO.setContractId(contractNameStr);
            }
            if (!StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getMaterialCode()) && ObjectUtil.isNotEmpty((Object)(codeInfo = this.erpMaterialService.getCodeInfo(erpStorageRecordsVO.getMaterialCode())))) {
                erpStorageRecordsVO.setMaterialCode(codeInfo.getFullName());
                erpStorageRecordsVO.setMaterialId(codeInfo.getId());
                erpStorageRecordsVO.setMaterialCodeShow(codeInfo.getCode());
                erpStorageRecordsVO.setMaterialBrand(codeInfo.getBrand());
                erpStorageRecordsVO.setMaterialModel(codeInfo.getModel());
            }
            if (StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getCompanyId()) || !ObjectUtil.isNotEmpty((Object)(organizeServiceInfo = this.organizeService.getInfo(erpStorageRecordsVO.getCompanyId())))) continue;
            erpStorageRecordsVO.setCompanyId(organizeServiceInfo.getFullName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpStorageRecordsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ErpStorageRecordsCrForm erpStorageRecordsCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ErpStorageRecordsEntity entity = (ErpStorageRecordsEntity)JsonUtil.getJsonToBean((Object)erpStorageRecordsCrForm, ErpStorageRecordsEntity.class);
        entity.setId(mainId);
        this.erpStorageRecordsService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(ErpStorageRecordsPaginationExportModel erpStorageRecordsPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)erpStorageRecordsPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        ErpStorageRecordsPagination erpStorageRecordsPagination = (ErpStorageRecordsPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)erpStorageRecordsPaginationExportModel), ErpStorageRecordsPagination.class));
        List<ErpStorageRecordsEntity> list = this.erpStorageRecordsService.getTypeList(erpStorageRecordsPagination, erpStorageRecordsPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, ErpStorageRecordsListVO.class);
        for (ErpStorageRecordsListVO erpStorageRecordsVO : listVO) {
            RkContractProjectEntity project;
            OrganizeEntity organizeServiceInfo;
            ErpMaterialEntity codeInfo;
            ErpEntrepotEntity info;
            erpStorageRecordsVO.setType(this.baseDataUtil.getDictName(erpStorageRecordsVO.getType(), "inAndOutStorageType"));
            if (!StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getWarehouseId()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(erpStorageRecordsVO.getWarehouseId())))) {
                erpStorageRecordsVO.setWarehouseId(info.getEntrepotName());
            }
            if (!StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getContractId())) {
                List<String> contractList = Arrays.asList(erpStorageRecordsVO.getContractId().split(","));
                StringBuffer stringBuffer = new StringBuffer();
                for (String s : contractList) {
                    RkContractEntity info2 = this.rkContractService.getInfo(s);
                    if (!ObjectUtil.isNotEmpty((Object)info2)) continue;
                    stringBuffer.append(info2.getContractCode() + "," + info2.getContractName() + ";");
                }
                String contractName = stringBuffer.toString();
                String contractNameStr = "";
                if (!StrUtil.isBlank((CharSequence)contractName) && contractName.endsWith(";") && contractName.length() > 3) {
                    contractNameStr = contractName.substring(0, contractName.length() - 1);
                }
                erpStorageRecordsVO.setContractId(contractNameStr);
            }
            if (!StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getMaterialCode()) && ObjectUtil.isNotEmpty((Object)(codeInfo = this.erpMaterialService.getCodeInfo(erpStorageRecordsVO.getMaterialCode())))) {
                erpStorageRecordsVO.setMaterialCode(codeInfo.getFullName());
                erpStorageRecordsVO.setMaterialId(codeInfo.getId());
                erpStorageRecordsVO.setMaterialCodeShow(codeInfo.getCode());
                erpStorageRecordsVO.setMaterialBrand(codeInfo.getBrand());
                erpStorageRecordsVO.setMaterialModel(codeInfo.getModel());
            }
            if (!StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getCompanyId()) && ObjectUtil.isNotEmpty((Object)(organizeServiceInfo = this.organizeService.getInfo(erpStorageRecordsVO.getCompanyId())))) {
                erpStorageRecordsVO.setCompanyId(organizeServiceInfo.getFullName());
            }
            if (StrUtil.isNotEmpty((CharSequence)erpStorageRecordsVO.getOutboundDate())) {
                erpStorageRecordsVO.setOutboundDate(DateUtil.date((long)Long.parseLong(erpStorageRecordsVO.getOutboundDate())).toString("yyyy-MM-dd  HH:mm"));
            }
            if (StrUtil.isBlank((CharSequence)erpStorageRecordsVO.getConsumingId())) continue;
            ErpConsumingApplyEntity erpConsumingApplyEntity = this.erpConsumingApplyService.getInfo(erpStorageRecordsVO.getConsumingId());
            erpStorageRecordsVO.setOutProjectCode(erpConsumingApplyEntity.getProjectCode());
            erpStorageRecordsVO.setOutProjectName(erpConsumingApplyEntity.getApplyPerson());
            if (!StrUtil.isNotEmpty((CharSequence)erpConsumingApplyEntity.getProjectId()) || !ObjectUtil.isNotEmpty((Object)(project = this.rkContractProjectService.getInfo(erpConsumingApplyEntity.getProjectId())))) continue;
            erpStorageRecordsVO.setOutProjectName(project.getProjectName());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)erpStorageRecordsPaginationExportModel.getSelectKey()) ? erpStorageRecordsPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block40: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u516c\u53f8", (Object)"companyId"));
                        continue block40;
                    }
                    case "warehouseId": {
                        entitys.add(new ExcelExportEntity("\u4ed3\u5e93", (Object)"warehouseId"));
                        continue block40;
                    }
                    case "materialCode": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599", (Object)"materialCode"));
                        continue block40;
                    }
                    case "amount": {
                        entitys.add(new ExcelExportEntity("\u5165/\u51fa\u5e93\u6570\u91cf", (Object)"amount"));
                        continue block40;
                    }
                    case "price": {
                        entitys.add(new ExcelExportEntity("\u5165/\u51fa\u5e93\u5355\u4ef7", (Object)"price"));
                        continue block40;
                    }
                    case "outboundDate": {
                        entitys.add(new ExcelExportEntity("\u5165/\u51fa\u5e93\u65f6\u95f4", (Object)"outboundDate"));
                        continue block40;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u6d41\u6c34\u7c7b\u578b", (Object)"type"));
                        continue block40;
                    }
                    case "contractId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u53f7", (Object)"contractId"));
                        continue block40;
                    }
                    case "applyCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u7533\u8bf7\u660e\u7ec6\u53f7", (Object)"applyCode"));
                        continue block40;
                    }
                    case "batch": {
                        entitys.add(new ExcelExportEntity("\u6279\u6b21", (Object)"batch"));
                        continue block40;
                    }
                    case "outProjectCode": {
                        entitys.add(new ExcelExportEntity("\u51fa\u5e93\u9879\u76ee", (Object)"outProjectCode"));
                        continue block40;
                    }
                    case "outProjectName": {
                        entitys.add(new ExcelExportEntity("\u51fa\u5e93\u9879\u76ee\u540d\u79f0", (Object)"outProjectName"));
                        continue block40;
                    }
                    case "outProjectUser": {
                        entitys.add(new ExcelExportEntity("\u51fa\u5e93\u9886\u7528\u4eba", (Object)"outProjectUser"));
                        continue block40;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block40;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpStorageRecordsInfoVO> info(@PathVariable(value="id") String id) {
        ErpStorageRecordsEntity entity = this.erpStorageRecordsService.getInfo(id);
        ErpStorageRecordsInfoVO vo = (ErpStorageRecordsInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpStorageRecordsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ErpStorageRecordsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OrganizeEntity organizeServiceInfo;
        ErpMaterialEntity codeInfo;
        ErpEntrepotEntity info;
        ErpStorageRecordsEntity entity = this.erpStorageRecordsService.getInfo(id);
        ErpMaterialEntity materialEntity = this.erpMaterialService.getCodeInfo(entity.getMaterialCode());
        ErpStorageRecordsInfoVO vo = (ErpStorageRecordsInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpStorageRecordsInfoVO.class);
        if (!StrUtil.isBlank((CharSequence)vo.getWarehouseId()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(vo.getWarehouseId())))) {
            vo.setWarehouseId(info.getEntrepotName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getContractId())) {
            List<String> contractList = Arrays.asList(vo.getContractId().split(","));
            StringBuffer stringBuffer = new StringBuffer();
            for (String s : contractList) {
                RkContractEntity info2 = this.rkContractService.getInfo(s);
                if (ObjectUtil.isNotEmpty((Object)info2)) {
                    stringBuffer.append(info2.getContractName() + ",");
                    continue;
                }
                List info1 = this.rkContractService.getListByCode(s);
                if (!CollectionUtil.isNotEmpty((Collection)info1)) continue;
                stringBuffer.append(info1.stream().map(RkContractEntity::getContractName).collect(Collectors.joining(",")));
            }
            String contractName = stringBuffer.toString();
            String contractNameStr = "";
            if (!StrUtil.isBlank((CharSequence)contractName) && contractName.endsWith(",") && contractName.length() > 3) {
                contractNameStr = contractName.substring(0, contractName.length() - 1);
            }
            vo.setContractId(contractNameStr);
        }
        if (!StrUtil.isBlank((CharSequence)vo.getMaterialCode()) && ObjectUtil.isNotEmpty((Object)(codeInfo = this.erpMaterialService.getCodeInfo(vo.getMaterialCode())))) {
            vo.setMaterialCode(codeInfo.getFullName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getCompanyId()) && ObjectUtil.isNotEmpty((Object)(organizeServiceInfo = this.organizeService.getInfo(vo.getCompanyId())))) {
            vo.setCompanyId(organizeServiceInfo.getFullName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getConsumingId())) {
            CrmCustomerEntity customerEntity;
            RkContractProjectEntity projectEntity;
            RkContractEntity rkContractEntity;
            ErpConsumingApplyEntity erpConsumingApplyEntity = this.erpConsumingApplyService.getInfo(vo.getConsumingId());
            ErpConsumingApplyEntity applyServiceInfo = this.erpConsumingApplyService.getInfo(vo.getConsumingId());
            ErpConsumingApplyInfoVO consumingInfo = (ErpConsumingApplyInfoVO)JsonUtil.getJsonToBean((Object)applyServiceInfo, ErpConsumingApplyInfoVO.class);
            consumingInfo.setSaleManager(this.baseDataUtil.userSelectValues(consumingInfo.getSaleManager()));
            consumingInfo.setProjectManager(this.baseDataUtil.userSelectValues(consumingInfo.getProjectManager()));
            consumingInfo.setApplyPerson(this.baseDataUtil.userSelectValues(consumingInfo.getApplyPerson()));
            if (!StrUtil.isBlank((CharSequence)consumingInfo.getContractId()) && ObjectUtil.isNotEmpty((Object)(rkContractEntity = this.rkContractService.getInfo(consumingInfo.getContractId())))) {
                consumingInfo.setContractId(rkContractEntity.getContractName());
            }
            if (!StrUtil.isBlank((CharSequence)consumingInfo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(consumingInfo.getProjectId())))) {
                consumingInfo.setProjectId(projectEntity.getProjectName());
            }
            if (!StrUtil.isBlank((CharSequence)consumingInfo.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(customerEntity = this.crmCustomerService.getInfo(consumingInfo.getCustomerId())))) {
                consumingInfo.setCustomerId(customerEntity.getName());
            }
            List<ErpConsumingDetailEntity> ErpConsumingDetailList = this.erpConsumingApplyService.GetErpConsumingDetailList(vo.getConsumingId());
            consumingInfo.setErpConsumingDetailList(JsonUtil.getJsonToList(ErpConsumingDetailList, ErpConsumingDetailModel.class));
            vo.setErpConsumingApplyInfoVO(consumingInfo);
            if (ObjectUtil.isNotEmpty((Object)applyServiceInfo)) {
                vo.setConsumingId(applyServiceInfo.getDescription());
                vo.setApplyPerson(this.baseDataUtil.userSelectValues(applyServiceInfo.getApplyPerson()));
            }
        }
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), "inAndOutStorageType"));
        ErpMaterialInfoVO materialInfoVO = (ErpMaterialInfoVO)JsonUtil.getJsonToBean((Object)materialEntity, ErpMaterialInfoVO.class);
        if (StringUtils.isNotEmpty((CharSequence)materialInfoVO.getMaterialTypeId())) {
            materialInfoVO.setMaterialTypeName(this.ofMaterialTypeService.getInfo(materialInfoVO.getMaterialTypeId()).getFullName());
        }
        materialInfoVO.setPictures(this.baseDataUtil.getFileNameInJson(materialInfoVO.getPictures()));
        if (StringUtils.isNotEmpty((CharSequence)materialInfoVO.getCreatorUserId())) {
            materialInfoVO.setCreatorUserName(this.baseDataUtil.userSelectValue(materialInfoVO.getCreatorUserId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)materialInfoVO.getLastModifyUserId())) {
            materialInfoVO.setLastModifyUserName(this.baseDataUtil.userSelectValue(materialInfoVO.getLastModifyUserId()));
        }
        materialInfoVO.setProperties(this.baseDataUtil.getDictName(materialInfoVO.getProperties(), "materialProperties"));
        vo.setMaterialInfoVO(materialInfoVO);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ErpStorageRecordsUpForm erpStorageRecordsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        ErpStorageRecordsEntity entity = this.erpStorageRecordsService.getInfo(id);
        if (entity != null) {
            ErpStorageRecordsEntity subentity = (ErpStorageRecordsEntity)JsonUtil.getJsonToBean((Object)erpStorageRecordsUpForm, ErpStorageRecordsEntity.class);
            this.erpStorageRecordsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        ErpStorageRecordsEntity entity = this.erpStorageRecordsService.getInfo(id);
        if (entity != null) {
            this.erpStorageRecordsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

